//+------------------------------------------------------------------+ 
//|                                                  r_Gator_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "       "
//---     
#property indicator_chart_window
//---    
#property indicator_buffers 3 
//---    
#property indicator_plots   3
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                          //        
#define INDICATOR_NAME "r_Gator"         //    
#define SIZE 1                           //      CountIndicator  
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 3
//---     
#property indicator_plots   3
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        
#property indicator_color1  clrRed
//---    1  2
#property indicator_width1  2
//---   
#property indicator_label1  "r_Gator Fast"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---        
#property indicator_color2  clrGreen
//---    2  2
#property indicator_width2  2
//---   
#property indicator_label2 "r_Gator"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_LINE
//---        
#property indicator_color3  clrBlue
//---    3  2
#property indicator_width3  2
//---   
#property indicator_label3 "r_Gator Slow"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;   //   
//---
input uint period1=5;    //   MA 
input uint period2=8;    //   MA
input uint period3=13;   //   MA
input int  Shift1=0;     //   MA    
input int  Shift2=0;     //   MA    
input int  Shift3=0;     //   MA    
//+----------------------------------------------+
//---   ,   
//---      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    r_Gator
   Ind_Handle=iCustom(Symbol(),TimeFrame,"r_Gator",period1,period2,period3,0,0,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      r_Gator");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,Ind1Buffer,0.0,min_rates_total,Shift1);
   IndInit(1,Ind2Buffer,0.0,min_rates_total,Shift2);
   IndInit(2,Ind3Buffer,0.0,min_rates_total,Shift3);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
//---
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,Ind1Buffer,1,Ind2Buffer,2,Ind3Buffer,
      time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---    2    Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb1,       //     1
                    double&  IndBuf1[],       //    1
                    uint     BuffNumb2,       //     2
                    double&  IndBuf2[],       //    2
                    uint     BuffNumb3,       //     3
                    double&  IndBuf3[],       //    3
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---      
         if(CopyBuffer(IndHandle,BuffNumb1,iTime[bar],1,Arr)<=0) return(RESET); IndBuf1[bar]=Arr[0];
         if(CopyBuffer(IndHandle,BuffNumb2,iTime[bar],1,Arr)<=0) return(RESET); IndBuf2[bar]=Arr[0];
         if(CopyBuffer(IndHandle,BuffNumb3,iTime[bar],1,Arr)<=0) return(RESET); IndBuf3[bar]=Arr[0];
        }
      else
        {
         IndBuf1[bar]=IndBuf1[bar+1];
         IndBuf2[bar]=IndBuf2[bar+1];
         IndBuf3[bar]=IndBuf3[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
