//+------------------------------------------------------------------+
//|                                                          HLR.mq4 |
//|                                      Copyright  2007, Alexandre |
//|                      http://www.kroufr.ru/content/view/1184/124/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Alexandre"
#property link      "http://www.kroufr.ru/content/view/1184/124/"
#property description "Hi-Lo Range Oscillator"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---        
#property indicator_color1 clrRed
//---   -  
#property indicator_style1  STYLE_SOLID
//---     1
#property indicator_width1  1
//---   
#property indicator_label1  "Hi-Lo Range Oscillator"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 80
#property indicator_level2 50
#property indicator_level3 20
#property indicator_levelcolor clrLimeGreen
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint HLR_Range=40; //   
input int  Shift=0;      //      
//+----------------------------------------------+
//---   ,   
//---      
double HLRBuffer[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+   
//| HLR indicator initialization function                            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=int(HLR_Range+1);
//---      
   SetIndexBuffer(0,HLRBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(HLRBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"Hi-Lo Range Oscillator(",HLR_Range,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+ 
//| HLR iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---       
   double m_pr,HH,LL, HL;
//---        
   int limit,bar;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---   
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HH=high[ArrayMaximum(high,bar,HLR_Range)];
      LL=low [ArrayMinimum(low, bar,HLR_Range)];    
      m_pr=(high[bar]+low[bar])/2.0;
      HL=HH-LL;
      if(HL) HLRBuffer[bar]=100.0*(m_pr-LL)/(HL);
      else HLRBuffer[bar]=0.0;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
