//+------------------------------------------------------------------+
//|                                      Exp_RangeExpansionIndex.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//+----------------------------------------------+
//|                             |
//+----------------------------------------------+
#include <TradeAlgorithms.mqh>
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
/*enum MarginMode  -     TradeAlgorithms.mqh
  {
   FREEMARGIN=0,     //MM     
   BALANCE,          //MM     
   LOSSFREEMARGIN,   //MM       
   LOSSBALANCE,      //MM       
   LOT               //  
  }; */
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
input double MM=0.1;              //       
input MarginMode MMMode=LOT;      //    
input int    StopLoss_=1000;      //   
input int    TakeProfit_=2000;    //   
input int    Deviation_=10;       // .    
input bool   BuyPosOpen=true;     //     
input bool   SellPosOpen=true;    //     
input bool   BuyPosClose=true;    //     
input bool   SellPosClose=true;   //     
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H8; //  
input uint REI_Period=8;                          //  
input uint Up_Indicator_level=+60;                //   
input uint Dn_Indicator_level=-60;                //   
input uint SignalBar=1;                           //      
//+----------------------------------------------+
//---          
int TimeShiftSec;
//---      
int InpInd_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    RangeExpansionIndex
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"RangeExpansionIndex",REI_Period);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("      RangeExpansionIndex");
      return(INIT_FAILED);
     }
//---          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);
//---     
   min_rates_total=int(REI_Period+8);
   min_rates_total+=int(3+SignalBar);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   GlobalVariableDel_(Symbol());
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;
//---       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);
//---   
   double Ind[2];
//---   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;
//---    
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //---   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;
      //---      
      if(CopyBuffer(InpInd_Handle,0,SignalBar,2,Ind)<=0) {Recount=true; return;}
      //---    
      if(Ind[1]>Dn_Indicator_level)
        {
         if(BuyPosOpen && Ind[0]<=Dn_Indicator_level) BUY_Open=true;
         if(SellPosClose) SELL_Close=true;
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
      else  BUY_Close=true;;
      //---    
      if(Ind[1]<Up_Indicator_level)
        {
         if(SellPosOpen && Ind[0]>=Up_Indicator_level) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
      else SELL_Close=true;
     }
//---  
//---  
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);
//---     
   SellPositionClose(SELL_Close,Symbol(),Deviation_);
//---  
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//---  
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//---
  }
//+------------------------------------------------------------------+
