//+------------------------------------------------------------------+
//|                                                     AdoValue.mqh |
//|                                             Copyright GF1D, 2010 |
//|                                             garf1eldhome@mail.ru |
//+------------------------------------------------------------------+
#property copyright "GF1D, 2010"
#property link      "garf1eldhome@mail.ru"

#include <Object.mqh>
#include "..\AdoTypes.mqh"

//--------------------------------------------------------------------
/// \brief  \~english Class that stores variables of general mql types
class CAdoValue : public CObject
{
private:
   bool _BoolValue;
   long _LongValue;
   double _DoubleValue;
   string _StringValue;
   MqlDateTime _DateValue;
   
   int _ValueType;
   bool _HasValue;
   
public:
   /// \brief  \~english constructor
   CAdoValue() { _HasValue = false; }

   /// \brief  \~english Sets value
   void SetValue(const bool val);
   /// \brief  \~english Sets value
   void SetValue(const short val);
   /// \brief  \~english Sets value
   void SetValue(const int val);
   /// \brief  \~english Sets value
   void SetValue(const long val);
   /// \brief  \~english Sets value
   void SetValue(const float val);
   /// \brief  \~english Sets value
   void SetValue(const double val);
   /// \brief  \~english Sets value
   void SetValue(const char val);
   /// \brief  \~english Sets value
   void SetValue(const string val);
   /// \brief  \~english Sets value
   void SetValue(const datetime val);
   /// \brief  \~english Sets value
   void SetValue(const MqlDateTime& val);
   
   /// \brief  \~english Returns boolean value
   const bool ToBool() { return _BoolValue; }
   /// \brief  \~english Returns long value
   const long ToLong() { return _LongValue; }
   /// \brief  \~english Returns double value
   const double ToDouble() { return _DoubleValue; }
   /// \brief  \~english Returns string value
   const string ToString() { return _StringValue; }
   /// \brief  \~english Returns date value
   const MqlDateTime ToDatetime() { return _DateValue; }
   
   /// \brief  \~english Returns value, converted to string
   const string AnyToString();
   
   /// \brief  \~english Clears value
   void Empty();
   
   /// \brief  \~english Checks if object has value
   const bool HasValue() { return _HasValue; }
   
   /// \brief  \~english Returns type of the value, stored in the object
   virtual int Type() { return _ValueType; }

};

//--------------------------------------------------------------------
CAdoValue::SetValue(const bool val)
{
   _BoolValue = val;
   _ValueType = ADOTYPE_BOOL;
   _HasValue = true;
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const long val)
{
   _LongValue = val;
   _ValueType = ADOTYPE_LONG;
   _HasValue = true;
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const double val)
{
   _DoubleValue = val;
   _ValueType = ADOTYPE_DOUBLE;
   _HasValue = true;
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const string val)
{
   _StringValue = val;
   _ValueType = ADOTYPE_STRING;
   _HasValue = true;
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const MqlDateTime &val)
{
   _DateValue = val;
   _ValueType = ADOTYPE_DATETIME;
   _HasValue = true;
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const short val)
{
   SetValue((long)val);
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const int val)
{
   SetValue((long)val);
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const float val)
{
   SetValue((double)val);
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const char val)
{
   SetValue(CharToString(val));
}

//--------------------------------------------------------------------
CAdoValue::SetValue(const datetime val)
{
   MqlDateTime time;
   TimeToStruct(val, time);
   SetValue(time);
}

//--------------------------------------------------------------------
CAdoValue::Empty(void)
{
   _HasValue = false;
   _BoolValue = NULL;
   _LongValue = NULL;
   _DoubleValue = NULL;
   _StringValue = NULL;
   _DateValue.day = _DateValue.mon = _DateValue.year = 0;
   _DateValue.sec = _DateValue.min = _DateValue.hour = 0;
}

//--------------------------------------------------------------------
string CAdoValue::AnyToString(void)
{
   if (!_HasValue) return "";
   
   switch (Type())
   {
      case ADOTYPE_BOOL: return (string)_BoolValue;
      case ADOTYPE_LONG: return IntegerToString(_LongValue);
      case ADOTYPE_DOUBLE: return DoubleToString(_DoubleValue);
      case ADOTYPE_STRING: return _StringValue;
      case ADOTYPE_DATETIME: 
         return (string)_DateValue.day + "." + (string)_DateValue.mon + "." + (string)_DateValue.year + " " 
              + (string)_DateValue.hour + ":" + (string)_DateValue.min + ":" + (string)_DateValue.sec;
      default: return "";
   }
}