/*
 * @(#)mclmcr.h    generated by: makeheader 5.1.3  Thu Jan 11 16:05:33 2007
 *
 *		built from:	../../src/include/copyright.h
 *				../../src/include/pragma_interface.h
 *				./MecMfileReader.cpp
 *				./MexAuthFileReader.cpp
 *				./app_state.cpp
 *				./arraydata.cpp
 *				./arrayfactory.cpp
 *				./arrayref.cpp
 *				./charbuffer.cpp
 *				./jmi_proxy.cpp
 *				./matrix_proxy.cpp
 *				./mclComponentData.cpp
 *				./mclPathMacros.cpp
 *				./mclRuntimePathMacros.cpp
 *				./mclcpp.cpp
 *				./mclmcr.cpp
 *				./mclmcrmcc.cpp
 *				./mcr_inst.cpp
 *				./mcr_inst_init.cpp
 *				./mcr_inst_term.cpp
 *				./mwarray_common.cpp
 *				./mwarray_sparse.cpp
 *				./mx_types.cpp
 *				./mxarray_utils.cpp
 *				./objallocator.cpp
 *				./registry.cpp
 *				./runmain.cpp
 *				mclcppAPI.cpp
 *				mclcppExternC.cpp
 *				mclcppOpaqueC.cpp
 */

#if defined(_MSC_VER) || __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ > 3)
#pragma once
#endif

#ifndef mclmcr_h
#define mclmcr_h


/*
 * Copyright 1984-2003 The MathWorks, Inc.
 * All Rights Reserved.
 */



/* Copyright 2003-2004 The MathWorks, Inc. */

/* Only define EXTERN_C if it hasn't been defined already. This allows
 * individual modules to have more control over managing their exports.
 */
#ifndef EXTERN_C

#ifdef __cplusplus
  #define EXTERN_C extern "C"
#else
  #define EXTERN_C extern
#endif

#endif


#include <stdarg.h>
#include <string.h>
#include <wchar.h>
#include "matrix.h"


EXTERN_C bool mclInitializeApplication(const char **options, int count);


EXTERN_C void mclInhibitShutdown(void);


EXTERN_C void mclUninhibitShutdown(void);


EXTERN_C void mclSetExitCode(int code);


EXTERN_C bool mclTerminateApplication(void);


#include <stdarg.h>
#include <string.h>
#include <wchar.h>
#include "matrix.h"


#ifdef __cplusplus
class MclMcr {};
#endif


typedef void* HMCRINSTANCE;
#ifdef __cplusplus

extern "C" {
#endif

    typedef int (*mclOutputHandlerFcn)(const char *s);

#ifdef __cplusplus
}
#endif



/* All the types of components we can generate code for. These values 
 * determine how the component initializes itself.
 */
typedef enum
{
    NoObjectType,
    COMObject,
    JavaObject,
    DotNetObject
} mccComponentType;

typedef enum {
  ExeTarget,
  LibTarget,
  MexTarget,
  SfunTarget,
  AnyTarget
} mccTargetType;




/* define MW_CALL_CONV to __cdecl if building on windows */
#ifndef MW_CALL_CONV
#if defined( _MSC_VER) || defined(__BORLANDC__) || defined(__WATCOMC__) || defined(__LCC__)
#define MW_CALL_CONV __cdecl
#else
#define MW_CALL_CONV
#endif /* using some PC compiler */
#endif /* MW_CALL_CONV */



EXTERN_C void mclEnableWarning(const char *warnID);


EXTERN_C void mclDisableWarning(const char *warnID);


#ifdef __cplusplus
extern "C" {
#endif
typedef void (*mclErrorCallbackFcnPtr)(void);
#ifdef __cplusplus
}
#endif


EXTERN_C mclErrorCallbackFcnPtr mclSetErrorCallbackFcn(mclErrorCallbackFcnPtr newFcn);


EXTERN_C int mclWrite(int fd, const void *ptr, size_t count);


EXTERN_C const char *mclGetPathMacro(const char* macro);


EXTERN_C void mclAddPathMacro(const char* macro, const char* expansion);


EXTERN_C void mclAddCanonicalPathMacro(const char* macro, const char* expansion);


EXTERN_C void mclRemovePathMacro(const char* macro);


/* Remove a directory and all subdirectories, if possible.
 * No hard error if dir does not exist or is not writable.
 * NOTE: The implementation of this function needs to be 
 * fixed to call rmRF when issue with static init of messsage
 * context gets fixed.
 */
EXTERN_C bool mclRemoveDirectory(const char* path);

EXTERN_C bool mclFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, mxArray** prhs);


EXTERN_C bool mclSwapPath(char ***oldPath, char **old_cwd, char **newPath,
		 const char *current_directory);

 
EXTERN_C int mclGetMaxPathLen(void);

 
EXTERN_C int mclGetDotNetComponentType(void);

 
EXTERN_C int mclGetMCCTargetType(bool isLibrary);


EXTERN_C int mclGetActiveID(void);


EXTERN_C bool mclmcrInitialize(void);



#ifdef _WIN32
#if ULONG_MAX == 0xffffffff 
typedef long int32_t;
#else
typedef int int32_t;
#endif
#endif

#define MAX_FIELD_NAME_SIZE 1024

typedef struct _wcsStackPointer
{
  char * hPtr;
  char   sPtr[MAX_FIELD_NAME_SIZE];
  int buffLen;
} *pwcsStackPointer;


EXTERN_C void deleteWcsStackPointer_hPtr(pwcsStackPointer ptr);


EXTERN_C void initializeWcsStackPointer(pwcsStackPointer *ptr);


EXTERN_C void deleteWcsStackPointer(pwcsStackPointer ptr);


EXTERN_C int mwMbstowcs( pwcsStackPointer sp, const char *sourceString);


EXTERN_C void utf16_to_lcp_n_fcn(char * target, int * targetSize,
                    char const * source, int sourceSize);


EXTERN_C int utf16_strlen_fcn(char const * s);


EXTERN_C char * utf16_strncpy_fcn(char * dst, char const * src, int n);


EXTERN_C char * utf16_strdup_fcn(const char * sl);



/* PATH_MAX is the maximum number of characters that can appear in a full
 * path specification. Define it, if it isn't already defined.
 */

#if !defined(PATH_MAX) || (defined(PATH_MAX) && PATH_MAX<1024)
#undef PATH_MAX

/* _WIN32 is always defined, for both Win32 and Win64 platforms */
#ifdef _WIN32
#ifdef _MAX_PATH
#define PATH_MAX _MAX_PATH
#endif
#endif

/* Windows platforms on which _MAX_PATH is not defined, and all UNIX 
 * platforms that don't define PATH_MAX. (Most UNIX platforms should 
 * define PATH_MAX in <limits.h>)
 */
#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

#endif


/* Extract the path from a file name specified by either absolute or
 * relative path. For example:
 *
 *   /home/foo/bar.exe -> /home/foo
 *   ./bar.exe -> <full path to cwd>/bar.exe
 *   bar.exe -> <empty string>
 *
 * Returns a pointer to the memory passed in by the caller. 
 */
EXTERN_C char* separatePathName(const char *fullname, char *buf, size_t bufLen);


/* Set print handlers to be used when no MCR is active.
 */
EXTERN_C void mclSetDefaultPrintHandlers(mclOutputHandlerFcn outFcn,
                                mclOutputHandlerFcn errFcn);


EXTERN_C void mclSetInternalErrorHandler(mclOutputHandlerFcn fcn);


#ifdef __cplusplus
class JmiProxy { MclMcr dependency; };
#endif


EXTERN_C mxArray* mclJObject2mJava(void* j);


EXTERN_C void* mclMJava2jObject(mxArray *pa);


EXTERN_C mclOutputHandlerFcn mclGetJavaSystemPrintHandler (const char* n);


EXTERN_C mxArray* mclmxSerialize(mxArray* pa);


EXTERN_C mxArray* mclmxDeserialize(const void *ps, size_t len);


EXTERN_C mxArray* mclmxCreateSharedCopy(mxArray* pa);

 
EXTERN_C mxArray* mclmxCreateConvertedCopy (mxArray* mx, mxClassID classid_out);

 
EXTERN_C mxArray* mclmxMustBeSparse (mxArray* mx);


/* Aggregate component-specific data.
 * Note: If you add fields here, make sure you update mclCreateComponentData
 * and mclDestroyComponentData.
 */
typedef struct mcl_component_data
{
    /* Key used to decrypt session key. This key has been encrypted with the
     * MCR's public key.
     */
    const unsigned char *public_data;

    /* Name of the component */
    const char *name_data;

    /* Root directory of the component (appended to the name of the 
     * CTF directory, if the root_data is non-NULL). Not used, I think.
     * TODO: Determine if this is used, and remove it if it isn't.
     */
    const char *root_data;

    /* Encrypted session key */
    const unsigned char *session_data;

    /* List of directories that will comprise the ENTIRE MATLAB path of the
     * application.
     */
    const char ** matlab_path_data;
    int matlab_path_data_count;

    /* List of directories that will comprise the ENTIRE Java class path 
     * of the application.
     */
    const char **classpath_data;
    int classpath_data_count;

    /* List of directories that will comprise the library load path
     * of the application.
     */
    const char **lib_path_data;
    int lib_path_data_count;

    /* MCR instance-specific options */
    const char **application_options;
    int application_option_count;
    
    /* Global (all MCR instances in this process) application options. */
    const char **runtime_options;
    int runtime_option_count;

    /* Directory in the CTF archive that contains the MATLAB preference
     * files.
     */
    const char *preferences_dir;

    /* Warning status: a list of warnings and their states (on or off).
     * For example, the string:
     *
     *    "off MCR:Extract"
     * 
     * means, turn the MCR:Extract warning off at the earliest possible time
     * during application initialization.
     */

    const char **set_warning_state;
    int set_warning_state_count;

    /* The directory where the component resides */
    const char *path_to_component;

} mclComponentData;

 
EXTERN_C mclComponentData *mclCreateComponentData(
    unsigned char *public_data, char *name_data, char *root_data,
    unsigned char *session_data,
    char **matlab_path_data, int matlab_path_data_count,
    char **classpath_data, int classpath_data_count,
    char **lib_path_data, int lib_path_data_count,
    char **application_options, int application_option_count,
    char **runtime_options, int runtime_option_count,
    char *prefdir,
    const char *path_to_component,
    char **warning_state, int warning_state_count);


EXTERN_C void mclDestroyComponentData(mclComponentData *cdata);



#include <stdarg.h>
#include "matrix.h"

typedef real64_T mxDouble;
typedef real32_T mxSingle;
typedef int8_T mxInt8;
typedef uint8_T mxUint8;
typedef int16_T mxInt16;
typedef uint16_T mxUint16;
typedef int32_T mxInt32;
typedef uint32_T mxUint32;
#if !defined(__MW_STDINT_H__)
#  if defined( linux ) || defined( __linux ) || defined( __linux__ )
#    include <stdint.h>
     typedef int64_t mxInt64;
     typedef uint64_t mxUint64;
#  elif defined( macintosh ) || defined( __APPLE__ ) || defined( __APPLE_CC__ )
#    if defined( __GNUC__ )
#      include <stdint.h>
       typedef int64_t mxInt64;
       typedef uint64_t mxUint64;
#    endif
#  elif defined( sun ) || defined( __sun )
#    include <inttypes.h>
     typedef int64_t mxInt64;
     typedef uint64_t mxUint64;
#  elif defined( __hpux )
#    include <inttypes.h>
     typedef int64_t mxInt64;
     typedef uint64_t mxUint64;
#  elif defined(_MSC_VER)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  elif defined(__BORLANDC__)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  elif defined(__WATCOMC__)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  elif defined(__LCC__)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  endif
#else
   typedef int64_T mxInt64;
   typedef uint64_T mxUint64;
#endif



#ifdef __cplusplus

/* Forward declarations */
class ref_count_obj;
class char_buffer;
class array_ref;
class array_buffer;
class error_info;

/* Class declarations */

class ref_count_obj
{
public:
    virtual int addref() = 0;
    virtual int release() = 0;
};

class char_buffer: public ref_count_obj
{
public:
    virtual int size() = 0;
    virtual const char* get_buffer() = 0;
    virtual int set_buffer(const char* str) = 0;
    virtual int compare_to(char_buffer* p) = 0;
};

class array_ref: public ref_count_obj
{
public:
    virtual mxClassID classID() = 0;
    virtual array_ref* deep_copy() = 0;
    virtual array_ref* shared_copy() = 0;
    virtual array_ref* serialize() = 0;
    virtual int element_size() = 0;
    virtual int number_of_elements() = 0;
    virtual int number_of_nonzeros() = 0;
    virtual int maximum_nonzeros() = 0;
    virtual int number_of_dimensions() = 0;
    virtual array_ref* get_dimensions() = 0;
    virtual int number_of_fields() = 0;
    virtual char_buffer* get_field_name(int i) = 0;
    virtual bool is_empty() = 0;
    virtual bool is_sparse() = 0;
    virtual bool is_numeric() = 0;
    virtual bool is_complex() = 0;
    virtual int make_complex() = 0;
    virtual bool equals(array_ref* p) = 0;
    virtual int compare_to(array_ref* p) = 0;
    virtual int hash_code() = 0;
    virtual char_buffer* to_string() = 0;
    virtual array_ref* row_index() = 0;
    virtual array_ref* column_index() = 0;
    virtual array_ref* get(int num_indices, const int* index) = 0;
    virtual array_ref* get(const char* name, int num_indices, const int* index) = 0;
    virtual array_ref* getV(int num_indices, va_list vargs) = 0;
    virtual array_ref* getV(const char* name, int num_indices, va_list vargs) = 0;
    virtual int set(array_ref* p) = 0;
    virtual array_ref* real() = 0;
    virtual array_ref* imag() = 0;
    virtual int get_numeric(mxDouble* x, int len) = 0;
    virtual int get_numeric(mxSingle* x, int len) = 0;
    virtual int get_numeric(mxInt8* x, int len) = 0;
    virtual int get_numeric(mxUint8* x, int len) = 0;
    virtual int get_numeric(mxInt16* x, int len) = 0;
    virtual int get_numeric(mxUint16* x, int len) = 0;
    virtual int get_numeric(mxInt32* x, int len) = 0;
    virtual int get_numeric(mxUint32* x, int len) = 0;
    virtual int get_numeric(mxInt64* x, int len) = 0;
    virtual int get_numeric(mxUint64* x, int len) = 0;
    virtual int get_char(mxChar* x, int len) = 0;
    virtual int get_logical(mxLogical* x, int len) = 0;
    virtual int set_numeric(const mxDouble* x, int len) = 0;
    virtual int set_numeric(const mxSingle* x, int len) = 0;
    virtual int set_numeric(const mxInt8* x, int len) = 0;
    virtual int set_numeric(const mxUint8* x, int len) = 0;
    virtual int set_numeric(const mxInt16* x, int len) = 0;
    virtual int set_numeric(const mxUint16* x, int len) = 0;
    virtual int set_numeric(const mxInt32* x, int len) = 0;
    virtual int set_numeric(const mxUint32* x, int len) = 0;
    virtual int set_numeric(const mxInt64* x, int len) = 0;
    virtual int set_numeric(const mxUint64* x, int len) = 0;
    virtual int set_char(const mxChar* x, int len) = 0;
    virtual int set_logical(const mxLogical* x, int len) = 0;
};

class array_buffer: public ref_count_obj
{
public:
    virtual int size() = 0;
    virtual array_ref* get(int offset) = 0;
    virtual int set(int offset, array_ref* p) = 0;
    virtual int add(array_ref* pa) = 0;
    virtual int remove(int offset) = 0;
    virtual int clear() = 0;
    virtual array_ref* to_cell(int offset, int len) = 0;
};

class error_info: public ref_count_obj
{
public:
    virtual const char* get_message() = 0;
};

#endif /* #ifdef __cplusplus */


#ifdef __cplusplus
/* This is an extern "C" API exclusively for use by C++ programs. It
 * exists solely to work around binary incompatibilities between different
 * C++ compilers. For example, a Borland C++ program cannot invoke a method
 * on an array_ref object created by a library compiled with Microsoft Visual 
 * C++. The mwArray API, therefore, invokes array_ref methods indirectly, by
 * passing the array_ref object to one of these extern "C" routines, which
 * are implemented in the MCLMCR module. Since this module is part of the
 * MCR, it can invoke array_ref methods with impunity.
 *
 * This API needs to be protected by #ifdef __cplusplus because some of the
 * input arguments to the functions it contains are pointers to objects.
 * Translating all of these to void *'s is overly complex and unnecessary,
 * as this API is always going to be called from a C++ program.
 */



class MclCppExternC {};


EXTERN_C int ref_count_obj_addref(ref_count_obj *obj);


EXTERN_C int ref_count_obj_release(ref_count_obj *obj);


EXTERN_C int char_buffer_size(char_buffer *obj);


EXTERN_C const char* char_buffer_get_buffer(char_buffer *obj);


EXTERN_C int char_buffer_set_buffer(char_buffer *obj, const char* str);


EXTERN_C int char_buffer_compare_to(char_buffer *obj, char_buffer* p);


EXTERN_C mxClassID array_ref_classID(array_ref *obj);


EXTERN_C array_ref* array_ref_deep_copy(array_ref *obj);


EXTERN_C array_ref* array_ref_shared_copy(array_ref *obj);


EXTERN_C array_ref* array_ref_serialize(array_ref *obj);


EXTERN_C int array_ref_element_size(array_ref *obj);


EXTERN_C int array_ref_number_of_elements(array_ref *obj);


EXTERN_C int array_ref_number_of_nonzeros(array_ref *obj);


EXTERN_C int array_ref_maximum_nonzeros(array_ref *obj);


EXTERN_C int array_ref_number_of_dimensions(array_ref *obj);


EXTERN_C array_ref* array_ref_get_dimensions(array_ref *obj);


EXTERN_C int array_ref_number_of_fields(array_ref *obj);


EXTERN_C char_buffer* array_ref_get_field_name(array_ref *obj, int i);


EXTERN_C bool array_ref_is_empty(array_ref *obj);


EXTERN_C bool array_ref_is_sparse(array_ref *obj);


EXTERN_C bool array_ref_is_numeric(array_ref *obj);


EXTERN_C bool array_ref_is_complex(array_ref *obj);


EXTERN_C int array_ref_make_complex(array_ref *obj);


EXTERN_C bool array_ref_equals(array_ref *obj, array_ref* p);


EXTERN_C int array_ref_compare_to(array_ref *obj, array_ref* p);


EXTERN_C int array_ref_hash_code(array_ref *obj);


EXTERN_C char_buffer* array_ref_to_string(array_ref *obj);


EXTERN_C array_ref* array_ref_row_index(array_ref *obj);


EXTERN_C array_ref* array_ref_column_index(array_ref *obj);


EXTERN_C array_ref* array_ref_get_int(array_ref *obj, int num_indices, const int* index);


EXTERN_C array_ref* array_ref_get_const_char(array_ref *obj, const char* name, int num_indices, const int* index);


EXTERN_C array_ref* array_ref_getV_int(array_ref *obj, int num_indices, va_list vargs);


EXTERN_C array_ref* array_ref_getV_const_char(array_ref *obj, const char* name, int num_indices, va_list vargs);


EXTERN_C int array_ref_set(array_ref *obj, array_ref* p);


EXTERN_C array_ref* array_ref_real(array_ref *obj);


EXTERN_C array_ref* array_ref_imag(array_ref *obj);


EXTERN_C int array_ref_get_numeric_mxDouble(array_ref *obj, mxDouble* x, int len);


EXTERN_C int array_ref_get_numeric_mxSingle(array_ref *obj, mxSingle* x, int len);


EXTERN_C int array_ref_get_numeric_mxInt8(array_ref *obj, mxInt8* x, int len);


EXTERN_C int array_ref_get_numeric_mxUint8(array_ref *obj, mxUint8* x, int len);


EXTERN_C int array_ref_get_numeric_mxInt16(array_ref *obj, mxInt16* x, int len);


EXTERN_C int array_ref_get_numeric_mxUint16(array_ref *obj, mxUint16* x, int len);


EXTERN_C int array_ref_get_numeric_mxInt32(array_ref *obj, mxInt32* x, int len);


EXTERN_C int array_ref_get_numeric_mxUint32(array_ref *obj, mxUint32* x, int len);


EXTERN_C int array_ref_get_numeric_mxInt64(array_ref *obj, mxInt64* x, int len);


EXTERN_C int array_ref_get_numeric_mxUint64(array_ref *obj, mxUint64* x, int len);


EXTERN_C int array_ref_get_char(array_ref *obj, mxChar* x, int len);


EXTERN_C int array_ref_get_logical(array_ref *obj, mxLogical* x, int len);


EXTERN_C int array_ref_set_numeric_mxDouble(array_ref *obj, const mxDouble* x, int len);


EXTERN_C int array_ref_set_numeric_mxSingle(array_ref *obj, const mxSingle* x, int len);


EXTERN_C int array_ref_set_numeric_mxInt8(array_ref *obj, const mxInt8* x, int len);


EXTERN_C int array_ref_set_numeric_mxUint8(array_ref *obj, const mxUint8* x, int len);


EXTERN_C int array_ref_set_numeric_mxInt16(array_ref *obj, const mxInt16* x, int len);


EXTERN_C int array_ref_set_numeric_mxUint16(array_ref *obj, const mxUint16* x, int len);


EXTERN_C int array_ref_set_numeric_mxInt32(array_ref *obj, const mxInt32* x, int len);


EXTERN_C int array_ref_set_numeric_mxUint32(array_ref *obj, const mxUint32* x, int len);


EXTERN_C int array_ref_set_numeric_mxInt64(array_ref *obj, const mxInt64* x, int len);


EXTERN_C int array_ref_set_numeric_mxUint64(array_ref *obj, const mxUint64* x, int len);


EXTERN_C int array_ref_set_char(array_ref *obj, const mxChar* x, int len);


EXTERN_C int array_ref_set_logical(array_ref *obj, const mxLogical* x, int len);


EXTERN_C int array_buffer_size(array_buffer *obj);


EXTERN_C array_ref* array_buffer_get(array_buffer *obj, int offset);


EXTERN_C int array_buffer_set(array_buffer *obj, int offset, array_ref* p);


EXTERN_C int array_buffer_add(array_buffer *obj, array_ref* pa);


EXTERN_C int array_buffer_remove(array_buffer *obj, int offset);


EXTERN_C int array_buffer_clear(array_buffer *obj);


EXTERN_C array_ref* array_buffer_to_cell(array_buffer *obj, int offset, int len);


EXTERN_C const char* error_info_get_message(error_info *obj);


#endif /* #ifdef __cplusplus */


#ifdef __cplusplus
class MclCpp { MclCppExternC dependency; };
#endif


#define MCLCPP_OK    0
#define MCLCPP_ERR  -1


EXTERN_C void mclAcquireMutex(void);


EXTERN_C void mclReleaseMutex(void);



#ifdef __cplusplus

class mwLock
{
public:
    mwLock()
    {
        mclAcquireMutex();
    }
    virtual ~mwLock()
    {
        mclReleaseMutex();
    }
};

#endif



EXTERN_C int mclcppGetLastError(void** ppv);


EXTERN_C int mclcppCreateError(void** ppv, const char* msg);


EXTERN_C void mclcppSetLastError(const char* msg);


EXTERN_C int mclcppErrorCheck(void);



#ifdef __cplusplus

#include <iostream>
#include <exception>

class mwException : public std::exception
{
public:
    mwException() : std::exception()
    {
        m_err = 0;
        mclcppCreateError((void**)&m_err, "Unspecified error");
    }
    mwException(const char* msg) : std::exception()
    {
        m_err = 0;
        mclcppCreateError((void**)&m_err, (msg ? msg : "Unspecified error"));
    }
    mwException(const mwException& e) : std::exception()
    {
        m_err = e.m_err;
        if (m_err)
            ref_count_obj_addref(m_err);
    }
    mwException(error_info* pe)
    {
        m_err = 0;
        if (pe)
        {
            m_err = pe;
            ref_count_obj_addref(m_err);
        }
        else
        {
            mclcppCreateError((void**)&m_err, "Unspecified error");
        }
    }
    mwException(error_info* pe, bool bAddRef)
    {
        m_err = 0;
        if (pe)
        {
            m_err = pe;
            if (bAddRef)
                ref_count_obj_addref(m_err);
        }
        else
        {
            mclcppCreateError((void**)&m_err, "Unspecified error");
        }
    }
    mwException(const std::exception& e) : std::exception()
    {
        m_err = 0;
        mclcppCreateError((void**)&m_err, e.what());
    }
    virtual ~mwException() throw()
    {
        if (m_err)
            ref_count_obj_release(m_err);
    }
    mwException& operator=(const std::exception& e)
    {
        if (m_err)
            ref_count_obj_release(m_err);
        mclcppCreateError((void**)&m_err, e.what());
        return *this;
    }
    mwException& operator=(const mwException& e)
    {
        if (m_err)
            ref_count_obj_release(m_err);
        m_err = e.m_err;
        if (m_err)
            ref_count_obj_addref(m_err);
        return *this;
    }
    const char *what() const throw()
    {
        return (m_err ? error_info_get_message(m_err) : NULL);
    }
    static void raise_error()
    {
        error_info* pe = 0;
        if (mclcppGetLastError((void**)&pe) == MCLCPP_ERR)
	{
	    throw mwException();
	}
        throw mwException(pe, false);
    }
    static void check_raise_error()
    {
        if (!mclcppErrorCheck())
            return;
        mwException::raise_error();
    }
protected:
    error_info* m_err;
};


#endif




#ifdef __cplusplus

template<typename T>
class mw_auto_ptr_t
{
public:
    mw_auto_ptr_t()
    {
        m_p = 0;
    }
    explicit mw_auto_ptr_t(T* p)
    {
        m_p = p;
        addref();
    }
    mw_auto_ptr_t(T*p, bool bAddRef)
    {
        m_p = p;
        if (bAddRef)
            addref();
    }
    virtual ~mw_auto_ptr_t()
    {
        if (m_p)
	    ref_count_obj_release(m_p);
    }
    void addref()
    {
        if (m_p)
	    ref_count_obj_addref(m_p);
    }
    void release()
    {
        if (m_p)
        {
	    ref_count_obj_release(m_p);
            m_p = 0;
        }
    }
    void attach(T* p, bool bAddRef)
    {
        release();
        m_p = p;
        if (bAddRef)
            addref();
    }
    T* detach()
    {
        T* p = m_p;
        m_p = 0;
        return p;
    }
    T* operator->(void) const
    {
        if (!m_p)
            throw mwException("Null pointer");
        return m_p;
    }
    T** operator&(void)
    {
        release();
        return &m_p;
    }
    operator T*() const
    {
        return m_p;
    }
    mw_auto_ptr_t<T>& operator=(T* p)
    {
        release();
        m_p = p;
        addref();
        return *this;
    }
    mw_auto_ptr_t<T>& operator=(const mw_auto_ptr_t<T>& ptr)
    {
        release();
        m_p = ptr.m_p;
        addref();
        return *this;
    }
    bool operator!() const
    {
        return (m_p == 0);
    }
    operator bool() const
    {
        return (m_p != 0);
    }
    bool operator==(const mw_auto_ptr_t<T>& ptr)
    {
        return (m_p == (T*)ptr);
    }
    bool operator!=(const mw_auto_ptr_t<T>& ptr)
    {
        return (m_p != (T*)ptr);
    }
protected:
    T* m_p;
};

#endif /* ifdef  __cplusplus */



EXTERN_C int mclCreateCharBuffer(void** ppv, const char* str);



#ifdef __cplusplus

//#include <iostream>

class mwString
{
public:
    mwString()
    {
        if (mclCreateCharBuffer((void**)&m_str, "") == MCLCPP_ERR)
            mwException::raise_error();
    }
    mwString(const char* str)
    {
        if (mclCreateCharBuffer((void**)&m_str, str) == MCLCPP_ERR)
            mwException::raise_error();
    }
    mwString(char_buffer* buff, bool bAddref)
    {
	m_str.attach(buff, bAddref);
    }
    mwString(const mwString& str)
    {
        if (mclCreateCharBuffer((void**)&m_str, str) == MCLCPP_ERR)
            mwException::raise_error();
        if (char_buffer_set_buffer(m_str, (const char*)str) == MCLCPP_ERR)
            mwException::raise_error();
    }
    virtual ~mwString(){}
public:
    int Length() const
    {
        return char_buffer_size(m_str);
    }
    operator const char* () const
    {
        return char_buffer_get_buffer(m_str);
    }
    mwString& operator=(const mwString& str)
    {
        if (&str == this)
            return *this;
        if (char_buffer_set_buffer(m_str, (const char*)str) == MCLCPP_ERR)
            mwException::raise_error();
        return *this;
    }
    mwString& operator=(const char* str)
    {
        if (char_buffer_set_buffer(m_str, str) == MCLCPP_ERR)
            mwException::raise_error();
        return *this;
    }
    bool operator==(const mwString& str) const
    {
        return (char_buffer_compare_to(m_str, str.m_str) == 0);
    }
    bool operator!=(const mwString& str) const
    {
        return (char_buffer_compare_to(m_str, str.m_str) != 0);
    }
    bool operator<(const mwString& str) const
    {
        return (char_buffer_compare_to(m_str, str.m_str) < 0);
    }
    bool operator<=(const mwString& str) const
    {
        return (char_buffer_compare_to(m_str, str.m_str) <= 0);
    }
    bool operator>(const mwString& str) const
    {
        return (char_buffer_compare_to(m_str, str.m_str) > 0);
    }
    bool operator>=(const mwString& str) const
    {
        return (char_buffer_compare_to(m_str, str.m_str) >= 0);
    }
    friend std::ostream& operator<<(std::ostream& os, const mwString& str)
    {
        os << (const char*)str;
        return os;
    }
private:
    mw_auto_ptr_t<char_buffer> m_str;
};

#endif



EXTERN_C double mclGetEps(void);


EXTERN_C double mclGetInf(void);


EXTERN_C double mclGetNaN(void);


EXTERN_C bool mclIsFinite(double x);


EXTERN_C bool mclIsInf(double x);


EXTERN_C bool mclIsNaN(double x);


EXTERN_C int mclGetEmptyArray(void** ppv, mxClassID classid);


EXTERN_C int mclGetMatrix(void** ppv, int num_rows, int num_cols, mxClassID classid, mxComplexity cmplx);


EXTERN_C int mclGetArray(void** ppv, int num_dims, const int* dims, mxClassID classid, mxComplexity cmplx);


EXTERN_C int mclGetNumericMatrix(void** ppv, int num_rows, int num_cols, mxClassID mxID, mxComplexity cmplx);


EXTERN_C int mclGetNumericArray(void** ppv, int num_dims, const int* dims, mxClassID mxID, mxComplexity cmplx);


EXTERN_C int mclGetScalarDouble(void** ppv, mxDouble re, mxDouble im, mxComplexity cmplx);


EXTERN_C int mclGetScalarSingle(void** ppv, mxSingle re, mxSingle im, mxComplexity cmplx);


EXTERN_C int mclGetScalarInt8(void** ppv, mxInt8 re, mxInt8 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarUint8(void** ppv, mxUint8 re, mxUint8 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarInt16(void** ppv, mxInt16 re, mxInt16 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarUint16(void** ppv, mxUint16 re, mxUint16 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarInt32(void** ppv, mxInt32 re, mxInt32 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarUint32(void** ppv, mxUint32 re, mxUint32 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarInt64(void** ppv, mxInt64 re, mxInt64 im, mxComplexity cmplx);


EXTERN_C int mclGetScalarUint64(void** ppv, mxUint64 re, mxUint64 im, mxComplexity cmplx);


EXTERN_C int mclGetCharMatrix(void** ppv, int num_rows, int num_cols);


EXTERN_C int mclGetCharArray(void** ppv, int num_dims, const int* dims);


EXTERN_C int mclGetScalarChar(void** ppv, mxChar x);


EXTERN_C int mclGetString(void** ppv, const char* str);


EXTERN_C int mclGetCharMatrixFromStrings(void** ppv, int m, const char** str);


EXTERN_C int mclGetLogicalMatrix(void** ppv, int num_rows, int num_cols);


EXTERN_C int mclGetLogicalArray(void** ppv, int num_dims, const int* dims);


EXTERN_C int mclGetScalarLogical(void** ppv, mxLogical x);


EXTERN_C int mclGetCellMatrix(void** ppv, int num_rows, int num_cols);


EXTERN_C int mclGetCellArray(void** ppv, int num_dims, const int* dims);


EXTERN_C int mclGetStructMatrix(void** ppv, int num_rows, int num_cols, int nFields, const char** fieldnames);


EXTERN_C int mclGetStructArray(void** ppv, int num_dims, const int* dims, int nFields, const char** fieldnames);


EXTERN_C int mclGetNumericSparse(void** ppv, int data_size, const int* rowindex, const int* colindex, const void* rData,
                        const void* iData, int num_rows, int num_cols, int nzmax, mxClassID mxType, mxComplexity cmplx);


EXTERN_C int mclGetLogicalSparse(void** ppv, int data_size, const int* rowindex, const int* colindex, const mxLogical* rData,
                        int num_rows, int num_cols, int nzmax);


EXTERN_C int mclDeserializeArray(void** ppv, void** ppa);


EXTERN_C int mclcppGetArrayBuffer(void** ppv, int size);


EXTERN_C int mclcppFeval(HMCRINSTANCE inst, const char* name, int nargout, void** lhs, void* rhs);


EXTERN_C int mclcppArrayToString(const mxArray* parray, char** ppstr);


EXTERN_C int mclmxArray2ArrayHandle(void** pphArray, mxArray* pmxArray);


EXTERN_C int mclArrayHandle2mxArray(mxArray** ppArrayImpl, void* phArray);


EXTERN_C size_t mclHashNBytes (size_t u, size_t n, const char * pb);

EXTERN_C bool mclInitializeInstance(HMCRINSTANCE* inst);

EXTERN_C bool mclFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, mxArray** prhs);

EXTERN_C bool mclInternalFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, mxArray** prhs);

EXTERN_C bool mclSetGlobal(HMCRINSTANCE inst, const char* name, mxArray* px);


EXTERN_C bool mclAddPath(HMCRINSTANCE inst, const char* dirName);


EXTERN_C bool mclAddPath(HMCRINSTANCE inst, const char* dir);


EXTERN_C bool mclChangeDirectory(HMCRINSTANCE inst, const char* dir);


EXTERN_C bool mclChangeDirectoryFeval(HMCRINSTANCE inst, const char* dir);


EXTERN_C bool mclDirName(HMCRINSTANCE inst, const char* name, char *path,
		int pathlen);

 
EXTERN_C bool mclFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, mxArray** prhs);


EXTERN_C bool mclGetDispatcherPathID(HMCRINSTANCE inst, void **path);


EXTERN_C bool mclGetGlobal(HMCRINSTANCE inst, const char* name, mxArray** ppx);


EXTERN_C const char *mclGetInstanceCWD(HMCRINSTANCE inst);


EXTERN_C char **mclGetInstancePath(HMCRINSTANCE inst);


EXTERN_C void mclGetLastErrIdAndMsg(const char **last_id, const char **last_msg);


EXTERN_C int mclGetID(HMCRINSTANCE inst);

 
EXTERN_C const char* mclGetLastErrorCode(HMCRINSTANCE inst);

 
EXTERN_C const char* mclGetLastErrorMessage(HMCRINSTANCE inst);


EXTERN_C bool mclIsDemoMCR(HMCRINSTANCE inst, bool *isdemo);


EXTERN_C void mclKillAllFigures(HMCRINSTANCE inst);


EXTERN_C int mclMain(HMCRINSTANCE inst, int argc, const char* argv[],
            const char* name, int nlhs);

 
EXTERN_C bool mclMexFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, const mxArray** prhs);

 
EXTERN_C bool mclMlfFeval(HMCRINSTANCE inst, const char* name, int nargout, int fnout, int fnin, ...);

 
EXTERN_C bool mclMlfVFeval(HMCRINSTANCE inst, const char* name, int nargout, int fnout, int fnin, va_list ap);


EXTERN_C bool mclPopActivation(HMCRINSTANCE inst);


EXTERN_C bool mclPushActivation(HMCRINSTANCE inst);


EXTERN_C bool mclRegisterExternalFunction(HMCRINSTANCE inst, const char* varname, mxFunctionPtr fcn);


EXTERN_C bool mclRemovePath(HMCRINSTANCE inst, const char* dirName);

 
EXTERN_C void mclSetErrorHandler(HMCRINSTANCE inst, mclOutputHandlerFcn eh);


EXTERN_C bool mclSetGlobal(HMCRINSTANCE inst, const char* name, mxArray* px);


EXTERN_C void mclSetLastErrIdAndMsg(HMCRINSTANCE inst, const char* newid, const char* newmsg);

 
EXTERN_C void mclSetPrintHandler(HMCRINSTANCE inst, mclOutputHandlerFcn ph);


EXTERN_C void mclWaitForFiguresToDie(HMCRINSTANCE inst);


EXTERN_C bool mclWhich(HMCRINSTANCE inst, const char* name, char *path, int pathlen);

 
/* Get stack trace string when error happens
*/
EXTERN_C int mclGetStackTrace(HMCRINSTANCE inst, char*** stack);

 
/* Free the stack trace string allocated earlier 
*/
EXTERN_C bool mclFreeStackTrace(char*** stack, int nStackDepth);


EXTERN_C bool mclGetMCRVersion(const char **version);


EXTERN_C bool mclInitializeComponentInstance(HMCRINSTANCE* inst,
                                    const mclComponentData *cdata,
                                    bool replace_path,
                                    mccComponentType ctype,
                                    mccTargetType ttype,
                                    mclOutputHandlerFcn error_handler,
                                    mclOutputHandlerFcn print_handler);

EXTERN_C bool mclTerminateInstance(HMCRINSTANCE* inst);


EXTERN_C mxArray *mclCreateCellArrayFromArrayList(int narray, mxArray *parray[]);


EXTERN_C mxArray* mclCreateSharedCopy(mxArray* px);


EXTERN_C mxArray* mclCreateEmptyArray(void);


EXTERN_C mxArray* mclCreateSimpleFunctionHandle(mxFunctionPtr fcn);



#ifdef __LCC__
/* Must undefine EXTERN_C here (and redefine it later) because LCC's version
 * of windows.h has its own definition of EXTERN_C.
 */
#undef EXTERN_C
#endif

#ifdef _WIN32
#include <windows.h>
#endif

#ifdef __LCC__
#undef EXTERN_C
#define EXTERN_C extern
#endif




#ifndef _WIN32
typedef const struct _GUID *REFCLSID, *REFGUID;
typedef long HRESULT;
#endif

/* Enums the component types */
typedef enum COMPONENT_TYPE
{
    COMPONENT_TYPE_MATLABXL  = 1,
    COMPONENT_TYPE_MATLABCOM = 2
} COMPONENT_TYPE;
/* Structure for getting Method argument info list  */
typedef struct _METHODARG_INFO
{
    char szArgName[256];                   /* Name of argument */
    unsigned short vt;                     /* Type of argument */
    unsigned short wFlags;                 /* Param flags */
    unsigned long nInd;                    /* Indirecttion. 0 = Value, 1 = ptr, 2 = ptr to ptr, etc. */
    struct _METHODARG_INFO* pNext;         /* Pointer to next METHODARG_INFO in list, s/b NULL for end of list */
} _METHODARG_INFO, *METHODARG_INFO;

/* Structure for getting Method info list  */
typedef struct _METHOD_INFO
{
    char szMethodName[256];                /* Name of method */
    unsigned long nArgs;                   /* Number of arguments */
    unsigned short vtRet;                  /* Return type of the function */
    unsigned long nRetInd;                 /* Return type indirecttion. 0 = Value, 1 = ptr, 2 = ptr to ptr, etc. */
    long dispid;                           /* DISPID of method */
    char szIID[40];                        /* IID of interface the method belongs to */
    struct _METHODARG_INFO* pargInfo;      /* Pointer to NULL-term'ed METHODARG_INFO list */
    struct _METHOD_INFO* pNext;            /* Pointer to next METHOD_INFO in list, s/b NULL for end of list */
} _METHOD_INFO, *METHOD_INFO;

/* Structure for getting Property info list  */
typedef struct _PROPERTY_INFO
{
    char szPropertyName[256];              /* Name of property */
    long dispid;                           /* DISPID of property */
    char szIID[40];                        /* IID of interface the property belongs to */
    struct _METHOD_INFO* pgetInfo;         /* Property get method info */
    struct _METHOD_INFO* pputInfo;         /* Property put method info */
    struct _PROPERTY_INFO* pNext;          /* Points to next in list s/b null for end of list */
} _PROPERTY_INFO, *PROPERTY_INFO;

/* Structure for getting Interface info list from the registry */
typedef struct _INTERFACE_INFO
{
    char szInterfaceName[256];             /* Name of interface */
    char szIID[40];                        /* IID string */
    char szLIBID[40];                      /* LIBID string */
    unsigned short wMajorRev;              /* TypeLib major rev number */
    unsigned short wMinorRev;              /* TypeLib minor rev number */
    struct _INTERFACE_INFO* pNext;         /* Pointer to next INTERFACE_INFO in list, s/b NULL for end of list */
} _INTERFACE_INFO, *INTERFACE_INFO;

/* Structure for getting CoClass info list from the registry */
typedef struct _COCLASS_INFO
{
    char szClassName[256];                 /* Name of class */
    char szInprocServer32[512];            /* Name of containing dll */
    char szProgID[256];                    /* ProgID */
    char szVerIndProgID[256];              /* Version independent ProgID */
    char szCLSID[40];                      /* CLSID string */
    char szLIBID[40];                      /* LIBID string */
    unsigned short wMajorRev;              /* TypeLib major rev number */
    unsigned short wMinorRev;              /* TypeLib minor rev number */
    struct _METHOD_INFO* pmethodInfo;      /* Pointer to null term'd list of METHOD_INFO's for class methods */
    struct _METHOD_INFO* peventInfo;       /* Pointer to null term'd list of METHOD_INFO's for events */
    struct _PROPERTY_INFO* ppropInfo;      /* Pointer to null term'd list of PROPERTY_INFO's for class properties */
    struct _COCLASS_INFO* pNext;           /* Pointer to next COCLASS_INFO in list, s/b NULL for end of list */
} _COCLASS_INFO, *COCLASS_INFO;

/* Structure for getting TypeLib info list for a given component */
typedef struct _TYPELIB_INFO
{
    char szLibName[256];                   /* Library name */
    char szLIBID[40];                      /* LIBID string */
    unsigned short wMajorRev;              /* Major revision number */
    unsigned short wMinorRev;              /* Minor revision number */
    char szFileName[512];                  /* Type lib file name */
    struct _COCLASS_INFO* pclsInfo;        /* Pointer to NULL-term'ed COCLASS_INFO list */
    struct _INTERFACE_INFO* pintInfo;      /* Pointer to NULL-term'ed INTERFACE_INFO list */
    struct _TYPELIB_INFO* pNext;           /* Pointer to next TYPELIB_INFO in list, s/b NULL for end of list */
} _TYPELIB_INFO, *TYPELIB_INFO;



/* Convert a CLSID to a char string using StringFromCLSID */
EXTERN_C void mclCLSIDtochar(REFCLSID clsid, char* szCLSID, int length);


/* Convert a GUID to a char string using StringFromGUID2 */
EXTERN_C void mclGUIDtochar(REFGUID guid, char* szGUID, int length);


/*
 Converts a null term'ed string rep of a GUID to an actual GUID. Input 
 string must be in the general form "{00000000-0000-0000-0000-000000000000}",
 where the {}'s and -'s are optional and the string must be null-term'ed.
 White space may appear anywhere except between digits in the first 3 elements 
 (00000000-0000-0000). Processing stops when the required elements/digits have
 been processed, or when either '{' or '\0' is encountered. Output GUID is 
 returned in *pguid. Returns 1 for success, 0 for failure.
*/
EXTERN_C int mclGUIDFromString(const char* lpszGUID, struct _GUID* pguid);


/* Frees a TYPELIB_INFO list that has been allocated by GetComponentInfo */
EXTERN_C void mclFreeComponentInfo(TYPELIB_INFO* ppInfo);


/*
   Retrieves information from HKEY_CLASSES_ROOT\TypeLib\{..} for a particular LIBID.
   The LIBID is input in char form, i.e.: "{00000000-0000-0000-0000-000000000000}" format.
   Information is returned for a particular version number, the most recent version
   number, or all versions, depending on the values of nMajorRev and nMinorRev
   as follows:
   nMajorRev > 0 - Return specific (MajorRev,MinorRev). Return NULL if not exact match
   nMajorRev = 0 - Return most recent (MajorRev,MinorRev)
   nMajorRev < 0 - Return all versions.
   Information is returned in a NULL term'ed list of TYPELIB_INFO structures. If no qualifying 
   keys exist, NULL is returned for *ppInfo. A populated TYPELIB_INFO list should be freed 
   by calling FreeComponentInfo.
*/
EXTERN_C HRESULT mclGetLIBIDInfo(const char* lpszLIBID, int nMajorRev, int nMinorRev, int nInfo, TYPELIB_INFO *ppInfo);


/*
   Retrieves information about a particular component by name, or all components. The 
   component must exist in the "MatLab COM Builder Components" component catagory. 
   This routine loops through all CLSID's in the MatLab COM Builder Components, and 
   returns info on the first component name that matches the component name listed in 
   the VersionIndependentProgID key for the given CLSID. Information is returned for a 
   particular version number, the most recent version number, or all versions, depending 
   on the values of nMajorRev and nMinorRev as follows:
   nMajorRev > 0 - Return specific (MajorRev,MinorRev). Return NULL if not exact match
   nMajorRev = 0 - Return most recent (MajorRev,MinorRev)
   nMajorRev < 0 - Return all versions.
   If the input component name string, lpszComponent, is NULL, then information for all 
   versions of all components in the catagory is returned. Information is returned in a 
   NULL term'ed list of TYPELIB_INFO structures. If no qualifying keys exist, NULL is 
   returned for *ppInfo. A populated TYPELIB_INFO list should be freed  by calling 
   mclFreeComponentInfo.
*/
EXTERN_C HRESULT mclGetComponentInfo(const char* lpszComponent, int nMajorRev, int nMinorRev, int nInfo, 
                            int nType, TYPELIB_INFO* ppInfo);


/* Register the component in the registry. */
EXTERN_C HRESULT mclRegisterServer(const char* szModuleName,     /* DLL module handle */
                         REFCLSID clsid,               /* Class ID */
                         REFGUID libid,                /* GUID of TypeLib */
                         unsigned short wMajorRev,     /* Major rev number of TypeLib */
                         unsigned short wMinorRev,     /* Minor rev number of TypeLib */
                         const char* szFriendlyName,   /* Friendly Name */
                         const char* szVerIndProgID,   /* Programmatic */
                         const char* szProgID,         /* IDs */
                         const char* szThreadingModel); /* ThreadingModel */


/* Remove the component from the registry. */
EXTERN_C HRESULT mclUnregisterServer(REFCLSID clsid,             /* Class ID */
                           const char* szVerIndProgID, /* Programmatic */
                           const char* szProgID);       /* IDs */


/* Register a MatLab XL component */
EXTERN_C HRESULT mclRegisterMatLabXLComponent(const char* szModuleName,     /* DLL module handle */
                                    REFCLSID clsid,               /* Class ID */
                                    REFGUID libid,                /* GUID of TypeLib */
                                    unsigned short wMajorRev,     /* Major rev number of TypeLib */
                                    unsigned short wMinorRev,     /* Minor rev number of TypeLib */
                                    const char* szFriendlyName,   /* Friendly Name */
                                    const char* szVerIndProgID,   /* Programmatic */
                                    const char* szProgID);         /* IDs */


/* Unregister a MatLab XL component */
EXTERN_C HRESULT mclUnRegisterMatLabXLComponent(REFCLSID clsid,             /* Class ID */
                                      const char* szVerIndProgID, /* Programmatic */
                                      const char* szProgID);       /* IDs */


/* Register a MatLab XL component */
EXTERN_C HRESULT mclRegisterMatLabCOMComponent(const char* szModuleName,     /* DLL module handle */
                                     REFCLSID clsid,               /* Class ID */
                                     REFGUID libid,                /* GUID of TypeLib */
                                     unsigned short wMajorRev,     /* Major rev number of TypeLib */
                                     unsigned short wMinorRev,     /* Minor rev number of TypeLib */
                                     const char* szFriendlyName,   /* Friendly Name */
                                     const char* szVerIndProgID,   /* Programmatic */
                                     const char* szProgID);         /* IDs */


/* Unregister a MatLab XL component */
EXTERN_C HRESULT mclUnRegisterMatLabCOMComponent(REFCLSID clsid,             /* Class ID */
                                       const char* szVerIndProgID, /* Programmatic */
                                       const char* szProgID);       /* IDs */


/* Main functions passed to mclRunMain must be of this type. This typedef
 * must be placed OUTSIDE of an extern "C" block to ensure that it has the
 * right linkage in the automatically generated MCLMCRRT proxy API. See
 * mclmcrrt/GenLibProxyAPI.pl for more details.
 */
typedef int (*mclMainFcnType)(int, const char **);


EXTERN_C int mclRunMain(mclMainFcnType run_main,
               int argc,
               const char **argv);


#ifdef __cplusplus
/* This public extern "C" API provides functions to create and manipulate
 * arrays. The API represents arrays as oqaque objects (void *'s, to be
 * precise). 
 *
 * The MATLAB Compiler and related Builder products use this API to insulate
 * the generated code from changes in the underlying matrix data structure.
 */



/* Opaque handle type definition. */
typedef void * array_handle;


EXTERN_C mxClassID array_handle_classID(array_handle handle);


EXTERN_C array_handle array_handle_deep_copy(array_handle handle);


EXTERN_C array_handle array_handle_shared_copy(array_handle handle);


EXTERN_C array_handle array_handle_serialize(array_handle handle);


EXTERN_C int array_handle_element_size(array_handle handle);


EXTERN_C int array_handle_number_of_elements(array_handle handle);


EXTERN_C int array_handle_number_of_nonzeros(array_handle handle);


EXTERN_C int array_handle_maximum_nonzeros(array_handle handle);


EXTERN_C int array_handle_number_of_dimensions(array_handle handle);


EXTERN_C array_handle array_handle_get_dimensions(array_handle handle);


EXTERN_C int array_handle_number_of_fields(array_handle handle);


EXTERN_C char_buffer* array_handle_get_field_name(array_handle handle, int i);


EXTERN_C bool array_handle_is_empty(array_handle handle);


EXTERN_C bool array_handle_is_sparse(array_handle handle);


EXTERN_C bool array_handle_is_numeric(array_handle handle);


EXTERN_C bool array_handle_is_complex(array_handle handle);


EXTERN_C int array_handle_make_complex(array_handle handle);


EXTERN_C bool array_handle_equals(array_handle handle, array_handle p);


EXTERN_C int array_handle_compare_to(array_handle handle, array_handle p);


EXTERN_C int array_handle_hash_code(array_handle handle);


EXTERN_C char_buffer* array_handle_to_string(array_handle handle);


EXTERN_C array_handle array_handle_row_index(array_handle handle);


EXTERN_C array_handle array_handle_column_index(array_handle handle);


EXTERN_C array_handle array_handle_get_int(array_handle handle, int num_indices, const int* index);


EXTERN_C array_handle array_handle_get_const_char(array_handle handle, const char* name, int num_indices, const int* index);


EXTERN_C array_handle array_handle_getV_int(array_handle handle, int num_indices, va_list vargs);


EXTERN_C array_handle array_handle_getV_const_char(array_handle handle, const char* name, int num_indices, va_list vargs);


EXTERN_C int array_handle_set(array_handle handle, array_handle p);


EXTERN_C array_handle array_handle_real(array_handle handle);


EXTERN_C array_handle array_handle_imag(array_handle handle);


EXTERN_C int array_handle_get_numeric_mxDouble(array_handle handle, mxDouble* x, int len);


EXTERN_C int array_handle_get_numeric_mxSingle(array_handle handle, mxSingle* x, int len);


EXTERN_C int array_handle_get_numeric_mxInt8(array_handle handle, mxInt8* x, int len);


EXTERN_C int array_handle_get_numeric_mxUint8(array_handle handle, mxUint8* x, int len);


EXTERN_C int array_handle_get_numeric_mxInt16(array_handle handle, mxInt16* x, int len);


EXTERN_C int array_handle_get_numeric_mxUint16(array_handle handle, mxUint16* x, int len);


EXTERN_C int array_handle_get_numeric_mxInt32(array_handle handle, mxInt32* x, int len);


EXTERN_C int array_handle_get_numeric_mxUint32(array_handle handle, mxUint32* x, int len);


EXTERN_C int array_handle_get_numeric_mxInt64(array_handle handle, mxInt64* x, int len);


EXTERN_C int array_handle_get_numeric_mxUint64(array_handle handle, mxUint64* x, int len);


EXTERN_C int array_handle_get_char(array_handle handle, mxChar* x, int len);


EXTERN_C int array_handle_get_logical(array_handle handle, mxLogical* x, int len);


EXTERN_C int array_handle_set_numeric_mxDouble(array_handle handle, const mxDouble* x, int len);


EXTERN_C int array_handle_set_numeric_mxSingle(array_handle handle, const mxSingle* x, int len);


EXTERN_C int array_handle_set_numeric_mxInt8(array_handle handle, const mxInt8* x, int len);


EXTERN_C int array_handle_set_numeric_mxUint8(array_handle handle, const mxUint8* x, int len);


EXTERN_C int array_handle_set_numeric_mxInt16(array_handle handle, const mxInt16* x, int len);


EXTERN_C int array_handle_set_numeric_mxUint16(array_handle handle, const mxUint16* x, int len);


EXTERN_C int array_handle_set_numeric_mxInt32(array_handle handle, const mxInt32* x, int len);


EXTERN_C int array_handle_set_numeric_mxUint32(array_handle handle, const mxUint32* x, int len);


EXTERN_C int array_handle_set_numeric_mxInt64(array_handle handle, const mxInt64* x, int len);


EXTERN_C int array_handle_set_numeric_mxUint64(array_handle handle, const mxUint64* x, int len);


EXTERN_C int array_handle_set_char(array_handle handle, const mxChar* x, int len);


EXTERN_C int array_handle_set_logical(array_handle handle, const mxLogical* x, int len);


#endif /* #ifdef __cplusplus */

#endif /* mclmcr_h */
