//+------------------------------------------------------------------+
//|                                                     AutoCorr.mq5 |
//|                        Copyright 2021, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "2009-2020, MetaQuotes Software Corp."
#property link        "http://www.mql5.com"
#property description "AutoCorrelation Function"
//--- indicator settings
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1   DRAW_LINE
#property indicator_color1  Red
#property indicator_label1  "ACF"
//--- input parameters
input int CorrLen   =  25;  // Correlation Length
input int LagLen    =   1;  // Lag Length
//--- indicator buffers
double    ExtACFBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- check for input value
  
//--- indicator buffers mapping
   SetIndexBuffer(0,ExtACFBuffer,INDICATOR_DATA);
//---
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//--- sets first bar from what index will be drawn
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,CorrLen);
//--- name for DataWindow and indicator subwindow label
   string short_name=StringFormat("ACF(%d,%d)",CorrLen,LagLen);
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
   PlotIndexSetString(0,PLOT_LABEL,short_name);
  }
//+------------------------------------------------------------------+
//| ACF                                                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int i,limit,jj;
   int StartBar;
   double oc[];
   StartBar = CorrLen+LagLen;
//--- check for bars count and input parameter
   if(rates_total<=StartBar )
      return(0);
//--- counting from 0 to rates_total
   ArraySetAsSeries(ExtACFBuffer,false);
   ArraySetAsSeries(close,false);
   ArraySetAsSeries(open,false);
   ArrayResize(oc,CorrLen);
//--- initial buffers
   if(prev_calculated<=0)
     {
      for(i=0; i<StartBar; i++)
       {
        ExtACFBuffer[i]=0.;
       }
      limit=StartBar+1;
     }
   else
      limit=prev_calculated-1;
//-------- the main loop of calculations ----------------------
   for(i=limit; i<rates_total; i++)
    {
      for(jj=0;jj<CorrLen;jj++)
       {
        oc[jj] = (close[i-jj]-open[i-jj]);
       }    
      ExtACFBuffer[i]=GetAtCorrVal(oc,CorrLen,LagLen,0);
    }
   return(rates_total);
  }
  //----------------------------------------------------------------
  double GetAtCorrVal(double &ClsOpn[],int CorrPer, int LagPer,int joff )
  {
   double corr;
   double AIn[],BIn[];
   double XMean,XNum,XDen;
   int jj;
   ArrayResize(AIn,CorrPer);
   ArrayResize(BIn,CorrPer);
   XMean = 0.;
   XNum = 0.;
   XDen = 0.;
   corr = 0.;
   if(CorrPer<2)
    {
     Print("No AutoCorr Processing Allowed ");
     corr=1.;
     return(corr);
    }
   // mean
   for(jj=0;jj<CorrPer;jj++)
    {
     XMean +=ClsOpn[jj+joff];
    }
   XMean = XMean/CorrPer;
  // variances 
   for(jj=0;jj<CorrPer;jj++)
    {
     if(jj<(CorrPer-LagPer)) 
       XNum  += (ClsOpn[jj+joff]-XMean)*(ClsOpn[jj+LagPer+joff]-XMean);
     XDen += (ClsOpn[jj+joff]-XMean)*(ClsOpn[jj+joff]-XMean);
    }  
    if(XDen==0.) 
      corr = 0.; 
    else
     corr = XNum/XDen;
   return(corr); 
  }
//----------------------------------------------------------------
//+------------------------------------------------------------------+
