//+------------------------------------------------------------------+
//|                                               SampleTrailing.mqh |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
//+------------------------------------------------------------------+
//| include files                                                    |
//+------------------------------------------------------------------+
#include <Expert\ExpertTrailing.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Moving position to lossless level                          |
//| Type=Trailing                                                    |
//| Name=BreakEven                                                   |
//| Class=CSampleTrailing                                            |
//| Page=                                                            |
//| Parameter=Profit,int,20                                          |
//| Parameter=StopLevel,int,0                                        |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSampleTrailing.                                           |
//| Purpose: Class of trailing open positions                        |
//|             by moving Stop order to a lossless level.            |
//|             Is derived from the CExpertTrailing class.           |
//+------------------------------------------------------------------+
class CSampleTrailing : public CExpertTrailing
  {
protected:
   int                m_profit;             // threshold level of profit
   int                m_stop_level;         // lossless level

public:
                      CSampleTrailing();
   //--- methods of setting adjustable parameters
   void               Profit(int value)       { m_profit=value;     }
   void               StopLevel(int value)    { m_stop_level=value; }
   //--- method of validation of adjustable parameters
   virtual bool       ValidationSettings();
   //--- methods of generation of position modification symbols
   virtual bool       CheckTrailingStopLong(CPositionInfo* position,double& sl,double& tp);
   virtual bool       CheckTrailingStopShort(CPositionInfo* position,double& sl,double& tp);
  };
//+------------------------------------------------------------------+
//| Constructor CSampleTrailing.                                     |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CSampleTrailing::CSampleTrailing()
  {
//--- setting default parameters
   m_profit    =20;
   m_stop_level=0;
  }
//+------------------------------------------------------------------+
//| Checking adjustable parameters                                   |
//| INPUT:  no.                                                      |
//| OUTPUT: true if the settings are valid, false - if not.          |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CSampleTrailing::ValidationSettings()
  {
//--- what if the Init method has not been called
   if(m_symbol==NULL) return(false);
//--- check of parameters
   if((m_profit-m_stop_level)*m_adjusted_point<=m_symbol.StopsLevel()*m_symbol.Point() && m_profit!=0.0)
     {
      printf(__FUNCTION__+": threshold level of profit must be greater than the level of setting orders");
      return(false);
     }
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Check for modification of stop orders of a long position.        |
//| INPUT:  position - pointer to a position object,                 |
//|         sl       - link for a new price of stop loss order,      |
//|         tp       - link for a new price of take profit order.    |
//| OUTPUT: true if condition is satisfied, false - if not.          |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CSampleTrailing::CheckTrailingStopLong(CPositionInfo* position,double& sl,double& tp)
  {
//--- check of pointer
   if(position==NULL) return(false);
//--- check of parameter
   if(m_profit==0.0)  return(false);
//--- already in a lossless zone?
   double open=position.PriceOpen();
   if(position.StopLoss()>=open) return(false);
//--- check of profit
   sl=EMPTY_VALUE;
   tp=EMPTY_VALUE;
   if(m_symbol.Bid()-open>m_profit*m_adjusted_point)
      sl=m_symbol.NormalizePrice(open+m_stop_level*m_adjusted_point);
//---
   return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//| Check for modification of stop orders of a short position.       |
//| INPUT:  position - pointer to a position object,                 |
//|         sl       - link for a new price of stop loss order,      |
//|         tp       - link for a new price of take profit order.    |
//| OUTPUT: true if condition is satisfied, false - if not.          |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CSampleTrailing::CheckTrailingStopShort(CPositionInfo* position,double& sl,double& tp)
  {
//--- check of pointer
   if(position==NULL) return(false);
//--- check of parameter
   if(m_profit==0.0)  return(false);
//--- already in a lossless zone?
   double open=position.PriceOpen();
   if(position.StopLoss()<=open) return(false);
//--- check of profit
   sl=EMPTY_VALUE;
   tp=EMPTY_VALUE;
   if(open-m_symbol.Ask()>m_profit*m_adjusted_point)
      sl=m_symbol.NormalizePrice(open-m_stop_level*m_adjusted_point);
//---
   return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+