//+------------------------------------------------------------------+
//|                                                     PropertyView |
//|                             Copyright 2006-2011, www.FXmaster.de |
//|                                                  www.FXmaster.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2006-2011, www.FXmaster.de"
#property link      "www.FXmaster.de"
#property version   "1.00"

#include "TreeView.mqh"

#import "shell32.dll"
   int ShellExecuteW(int hwnd, string &lpOperation, string &lpFile, string &lpParameters, string &lpDirectory, int nShowCmd);
#import

#define SW_SHOWNORMAL           1
#define SW_SHOWMINIMIZED        2

#define ERROR_BAD_FORMAT        11
#define ERROR_FILE_NOT_FOUND    2 
#define ERROR_PATH_NOT_FOUND    3

//------------------------------------------------------------------	class CPropertyView
class CPropertyView: public CTreeView
{
//--- basic functions
public:
	CPropertyView(); // constructor
	~CPropertyView(); // destructor
	virtual void Create(long chart, string name, int wnd, color clr, color bgclr, color selclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Arial");
	
//--- function of processing of state
public:
	virtual int OnClick(string name); // processing the event of clicking on the object
	
//--- functions of displaying
public:
	virtual void Draw(); // refresh the view
	virtual void DrawTree(CNode *root, int xpos, int &ypos, int &up, int &dn);
	virtual void DrawNode(CNode *node, int x, int y); // draw node
	virtual void DeleteView(CNode *root=NULL, bool delparent=true); // delete the view
};
//------------------------------------------------------------------	CPropertyView
void CPropertyView::CPropertyView() { }
//------------------------------------------------------------------	~CPropertyView
void CPropertyView::~CPropertyView() 
{
	ObjectDelete(m_chart, m_name+".open");
	DeleteView();
}
//------------------------------------------------------------------	Create
void CPropertyView::Create(long achart, string name, int wnd, color clr, color bgclr, color selclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Arial")
{
	CTreeView::Create(achart, name,  wnd, clr, bgclr, selclr, x, y, dx, dy, corn, fontsize, font);
}
//------------------------------------------------------------------	OnClick
int CPropertyView::OnClick(string name) // name of object that has been clicked
{
	int start=StringLen(m_name); int len=StringFind(name, ".")-start;
	int id=(int)StringToInteger(StringSubstr(name, start, len));
	if (StringFind(name, ".open")>=0) 
	{
		ObjectSetInteger(m_chart, name, OBJPROP_STATE, false);
		string path=m_tree.m_root.m_path;
		string cmd="open"; string nil="";
		int hWnd=(int)ChartGetInteger(m_chart, CHART_WINDOW_HANDLE);
		int rez=ShellExecuteW(hWnd, cmd, path, nil, nil, SW_SHOWNORMAL);
		if (rez==0) MessageBox("Not enough resources to open \n"+path);
		else if (rez==ERROR_BAD_FORMAT) MessageBox("Not an \'exe\' file ");
		else if (rez==ERROR_FILE_NOT_FOUND) MessageBox("File not found \n"+path);
		else if (rez==ERROR_PATH_NOT_FOUND) MessageBox("Path not found \n"+path);
		else if (rez<=31) MessageBox("Error of starting \n"+path);
		return(BTN_OPEN);
	}
	else return(CTreeView::OnClick(name));
}
//------------------------------------------------------------------	Draw
void CPropertyView::Draw()
{
	if (!IsOpenView()) return; // if a view is not created, exit

	SetRectLbl(m_chart, m_name+".rect", m_wnd, "", m_clr, m_bgclr, m_x, m_y, m_dx, m_dy, m_corn, m_fontsize, m_font, true);
	int ax=int(m_x+m_dx-1.5*m_bdx); int adx=int(1.2*m_bdx); int i=-1;

	i++; SetButton(m_chart, m_name+".collaps", 0, "-", m_bgclr, m_selclr, ax-i*adx, int(m_y+0.5*m_bdy), m_bdx, m_bdy, 0, 7, "Tahoma", false);
	i++; SetButton(m_chart, m_name+".expand", 0, "+", m_bgclr, m_selclr, ax-i*adx, int(m_y+0.5*m_bdy), m_bdx, m_bdy, 0, 7, "Tahoma", false);
	i++; SetButton(m_chart, m_name+".open", 0, "...", m_bgclr, clrDarkOliveGreen, ax-i*adx, int(m_y+0.5*m_bdy), m_bdx, m_bdy, 0, 7, "Tahoma", false);

	int show=0, up=0, dn=0; 
	DrawTree(m_tree.m_root, 1, show, up, dn); // drew tree
	
	if (up<=0 && dn<=0) m_scroll.DeleteView(); // removed the scrollbar for redrawing
	else
	{
		m_scroll.m_max=up+dn; m_scroll.m_value=up;
		m_scroll.m_x=m_x+m_dx-20; m_scroll.m_dx=16; 
		m_scroll.m_y=m_y+2*m_bdy; m_scroll.m_dy=m_dy-3*m_bdy+8;
		m_scroll.Draw(); // drew the scrollbar
	}
}
//------------------------------------------------------------------	DrawTree
void CPropertyView::DrawTree(CNode *root, int xpos, int &ypos, int &up, int &dn)
{
	if (xpos==1) { root=m_tree.m_root; ypos=0; } // if we start from the first element, take the root and the left position
	if (root==NULL) { root=m_tree.m_root; xpos=1; } // if the specified node is not the first one, take the root and upper position
	if (NIL(root)) return; // validity of pointer
	string name=m_name+string(root.m_id);

	if (!IsOpenView()) return; // if a view is not created, exit

	int x=m_x0+m_x+5+(xpos-1)*m_bdx;
	int y=m_y0+m_y+5+ypos*m_ndy;
	
	bool ishide=(y<=m_y || y>=m_y+m_dy-m_ndy);
	if (root.m_break && ishide)
	{
		while (y<m_y) { m_y0+=m_ndy; y=m_y0+m_y+5+ypos*m_ndy; }// moved down
		while (y>m_y+m_dy-m_ndy) { m_y0-=m_ndy; y=m_y0+m_y+5+ypos*m_ndy; }// moved up
		up=0; dn=0;
		DrawTree(m_tree.m_root, 1, ypos, up, dn); // drew the entire tree again
	}
	
	if (!ishide) DrawNode(root, x, y); // if it doesn't go out of visible area
	else 
	{
		ObjectDelete(m_chart, name+".lbl"); ObjectDelete(m_chart, name+".btn"); 
		ObjectDelete(m_chart, name+".prop"); 
		if (y<m_y) up++; else dn++;
	}
	
	if (!root.m_expand) return; // skip if not expanded
	for (int i=0; i<ArraySize(root.m_next); i++)
	{
		if (NIL(root.m_next[i])) continue;
		ypos++; // increased position
		DrawTree(root.m_next[i], xpos+1, ypos, up, dn); // drew the next branch
	}
}
//------------------------------------------------------------------	DrawNode
void CPropertyView::DrawNode(CNode *node, int x, int y)
{
	if (NIL(node)) return;
	int ndx=m_ndx-m_bdx;
	string name=m_name+string(node.m_id);
	string txt=node.m_text; 
	// determine color
	bool bgroup=false;
	if (!NIL(node.m_prev)) if (node.m_prev.m_id==0) bgroup=true;
	
	color clr=bgroup ? m_selclr : m_clr;
	clr=node.m_id==0 ? clrDarkOliveGreen : clr;
	
	// display text for a node
	SetLabel(m_chart, name+".lbl", m_wnd, txt, clr, x+ndx, y-1, m_corn, m_fontsize, m_font);
	
	if (node.m_desc=="" || node.m_id==0 || !node.m_expand) 
		ObjectDelete(m_chart, name+".prop");
	else 
	{
		if (node.m_edit) SetEdit(m_chart, name+".prop", m_wnd, node.m_desc, clr, m_bgclr, int(m_x+150), y, m_ndx*2, m_ndy+1, m_corn, m_fontsize, m_font, false);
		else SetLabel(m_chart, name+".prop", m_wnd, node.m_desc, clr, int(m_x+150), y, m_corn, m_fontsize, m_font);
	}
	
	// button of node expanding
	string state=node.m_expand ? "-" : "+";
	if (ArraySize(node.m_next)>0) // if there is a sub-array, set expanding
		SetButton(m_chart, name+".btn", m_wnd, state, m_clr, m_bgclr, x, y, m_bdx, m_bdy, m_corn, m_fontsize, m_font, node.m_expand);
	else ObjectDelete(m_chart, name+".btn");
}
//------------------------------------------------------------------	DeleteView
void CPropertyView::DeleteView(CNode *root=NULL, bool delparent=true)
{
	CTreeView::DeleteView(root, delparent); // method of base class
	
	if (root==NULL) root=m_tree.m_root; if (NIL(root)) return;
	if(delparent) // delete node of the parent
		ObjectDelete(m_chart, m_name+string(root.m_id)+".prop");

	for (int i=0; i<ArraySize(root.m_next); i++)
		if (!NIL(root.m_next[i])) DeleteView(root.m_next[i], true);
}