//+------------------------------------------------------------------+
//|                                                        Panel.mqh |
//|                        Copyright 2013, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"

#define BEST_ASK 1
#define BEST_BID 2

struct PrintQuote
{
   int index;           // Index of price line.
   double ask;          // Ask price.
   double bid;          // Bid price.
   double delta_ask;    // Delta ask.
   double delta_bid;    // Delta bid.
   int price_flags;     // Best prices flags.
   string broker_name;  // Broker name;
};

enum ELEMENT_TYPE
{
   ELEMENT_TYPE_ACCESS,
   ELEMENT_TYPE_BROKER
};

class CPanel
{
   private:
      enum ENUM_NAMES
      {
         NAME_BGROUND,
         NAME_ACCESS,
         NAME_BROKER,
         NAME_ASK,
         NAME_BID,
         NAME_SASK,
         NAME_SBID
      };
      struct CPrevCount
      {
         uint PrevTickCount;
         int AccessCount;
         CPrevCount()
         {
            PrevTickCount = GetTickCount();
            AccessCount = 0;
         }
      };
      PrintQuote quotes[];    // Include prev quote.
      CPrevCount prevCount;
      CPrevCount firstCount;
      string GetObjectName(ENUM_NAMES name, int index = 0);
      void CreateAccess();
      void CreateBackground();
      void CreateBroker(int index);
      void CreateField(ENUM_NAMES name, int index);
      void SetBgColor(string name, color clr);
   public:
      void DeleteObjects();
      void DrawAccess(int count);
      void DrawBroker(PrintQuote& quote);
      void Init();
};


string CPanel::GetObjectName(ENUM_NAMES name, int index = 0)
{
   string sname = "mt_";
   switch(name)
   {
      case NAME_BGROUND:
         sname += "bground";
         break;
      case NAME_ACCESS:
         sname += "access";
         break;
      case NAME_BROKER:
         sname += "broker";
         break;
      case NAME_ASK:
         sname += "ask";
         break;
      case NAME_BID:
         sname += "bid";
         break;
      case NAME_SASK:
         sname += "sask";
         break;
      case NAME_SBID:
         sname += "sbid";
         break;
   }
   sname += (string)index;
   return sname;
}

void CPanel::CreateAccess(void)
{
   string access = GetObjectName(NAME_ACCESS);
   ObjectCreate(0, access, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, access, OBJPROP_XDISTANCE, 5);
   ObjectSetInteger(0, access, OBJPROP_YDISTANCE, 10);
   ObjectSetInteger(0, access, OBJPROP_XSIZE, 100);
   ObjectSetInteger(0, access, OBJPROP_YSIZE, 10);
   ObjectSetInteger(0, access, OBJPROP_COLOR, clrBlack);
   //Create Symbol
   string smb = "mt_symbol";
   ObjectCreate(0, smb, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, smb, OBJPROP_XDISTANCE, 5);
   ObjectSetInteger(0, smb, OBJPROP_YDISTANCE, 30);
   ObjectSetInteger(0, smb, OBJPROP_XSIZE, 50);
   ObjectSetInteger(0, smb, OBJPROP_YSIZE, 10);
   ObjectSetString(0, smb, OBJPROP_TEXT, Symbol());
   ObjectSetInteger(0, smb, OBJPROP_COLOR, clrBlack);
   //Create ASK annotation
   string ask = "mt_ASK";
   string bid = "mt_BID"; 
   ObjectCreate(0, ask, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, ask, OBJPROP_XDISTANCE, 207);
   ObjectSetInteger(0, ask, OBJPROP_YDISTANCE, 30);
   ObjectSetInteger(0, ask, OBJPROP_XSIZE, 50);
   ObjectSetInteger(0, ask, OBJPROP_YSIZE, 10);
   ObjectSetString(0, ask, OBJPROP_TEXT, "ASK");
   ObjectSetInteger(0, ask, OBJPROP_COLOR, clrBlack);
   //Bid
   ObjectCreate(0, bid, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, bid, OBJPROP_XDISTANCE, 257);
   ObjectSetInteger(0, bid, OBJPROP_YDISTANCE, 30);
   ObjectSetInteger(0, bid, OBJPROP_XSIZE, 50);
   ObjectSetInteger(0, bid, OBJPROP_YSIZE, 10);
   ObjectSetString(0, bid, OBJPROP_TEXT, "BID");
   ObjectSetInteger(0, bid, OBJPROP_COLOR, clrBlack);
   //SASK
   string sask = "mt_SASK";
   ObjectCreate(0, sask, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, sask, OBJPROP_XDISTANCE, 312);
   ObjectSetInteger(0, sask, OBJPROP_YDISTANCE, 30);
   ObjectSetInteger(0, sask, OBJPROP_XSIZE, 50);
   ObjectSetInteger(0, sask, OBJPROP_YSIZE, 10);
   ObjectSetString(0, sask, OBJPROP_TEXT, "D-ASK");
   ObjectSetInteger(0, sask, OBJPROP_COLOR, clrBlack);
   //SBID
   string sbid = "mt_SBID";
   ObjectCreate(0, sbid, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, sbid, OBJPROP_XDISTANCE, 370);
   ObjectSetInteger(0, sbid, OBJPROP_YDISTANCE, 30);
   ObjectSetInteger(0, sbid, OBJPROP_XSIZE, 50);
   ObjectSetInteger(0, sbid, OBJPROP_YSIZE, 10);
   ObjectSetString(0, sbid, OBJPROP_TEXT, "D-BID");
   ObjectSetInteger(0, sbid, OBJPROP_COLOR, clrBlack);
}

void CPanel::CreateBroker(int index)
{
   string name = GetObjectName(NAME_BROKER, index);
   int step = 15*(index+1)+30;
   ObjectCreate(0, name, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, name, OBJPROP_XDISTANCE, 5);
   ObjectSetInteger(0, name, OBJPROP_YDISTANCE, step);
   ObjectSetInteger(0, name, OBJPROP_XSIZE, 100);
   ObjectSetInteger(0, name, OBJPROP_YSIZE, 10);
   ObjectSetInteger(0, name, OBJPROP_COLOR, clrBlack);  
}
void CPanel::CreateField(ENUM_NAMES ename, int index)
{
   string name = GetObjectName(ename, index);
   int step = 15*(index+1)+30;
   int x = 5;
   switch(ename)
   {
      case NAME_ASK:
         x += 200;
         break;
      case NAME_BID:
         x += 250;
         break;
      case NAME_SASK:
         x += 305;
         break;
      case NAME_SBID:
         x += 365;
         break;
   }
   ObjectCreate(0, name, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, name, OBJPROP_XDISTANCE, x);
   ObjectSetInteger(0, name, OBJPROP_YDISTANCE, step);
   ObjectSetInteger(0, name, OBJPROP_XSIZE, 100);
   ObjectSetInteger(0, name, OBJPROP_YSIZE, 10);
   ObjectSetInteger(0, name, OBJPROP_COLOR, clrBlack);
}

void CPanel::CreateBackground(void)
{
   string access = GetObjectName(NAME_BGROUND);
   ObjectCreate(0, access, OBJ_RECTANGLE_LABEL, 0, 0, 0);
   ObjectSetInteger(0, access, OBJPROP_XDISTANCE, 0);
   ObjectSetInteger(0, access, OBJPROP_YDISTANCE, 0);
   ObjectSetInteger(0, access, OBJPROP_XSIZE, 430);
   ObjectSetInteger(0, access, OBJPROP_YSIZE, 1000);
}

void CPanel::DrawAccess(int count)
{
   if(ObjectFind(0, GetObjectName(NAME_BGROUND))<0)
      CreateBackground();
   if(ObjectFind(0, GetObjectName(NAME_ACCESS))<0)
   {
      CreateAccess();
      firstCount.AccessCount = count;
   }
   uint t = GetTickCount();
   uint tiks = t - prevCount.PrevTickCount;
   int access = count - prevCount.AccessCount;
   double sec = (double)tiks/1000.0;
   double fps = sec != 0.0 ? access/sec: 0;
   uint all_tiks = t - firstCount.PrevTickCount;
   int all_access = count - firstCount.AccessCount;
   double all_sec = (double)all_tiks/1000.0;
   double avrg = all_sec != 0.0 ? all_access/all_sec : 0;
   string value = "I/O Rewrite: " + (string)count + " ("+
          DoubleToString(fps, 1) + " fps; Avrg: " + DoubleToString(avrg, 1) + "/sec.)";
   ObjectSetString(0, GetObjectName(NAME_ACCESS), OBJPROP_TEXT, value);
   ChartRedraw();
   prevCount.AccessCount = count;
   prevCount.PrevTickCount = GetTickCount();
}


void CPanel::DrawBroker(PrintQuote& quote)
{
   string name = GetObjectName(NAME_BROKER, quote.index);
   if(ObjectFind(0, name)<0)
      CreateBroker(quote.index);
   string sask = GetObjectName(NAME_ASK, quote.index);
   string sbid = GetObjectName(NAME_BID, quote.index);
   string dask = GetObjectName(NAME_SBID, quote.index);
   string dbid = GetObjectName(NAME_SBID, quote.index);
   if(ObjectFind(0, sask)<0)
      CreateField(NAME_ASK, quote.index);
   if(ObjectFind(0, sbid)<0)
      CreateField(NAME_BID, quote.index);
   if(ObjectFind(0, dask))
      CreateField(NAME_SASK, quote.index);
   if(ObjectFind(0, dbid))
      CreateField(NAME_SBID, quote.index);
   string value = quote.broker_name + ":  " + (string)quote.ask + "    " + string(quote.bid);
   color cFontAsk = clrBlack;
   color cFontBid = clrBlack;
   color cFontDeltaAsk = clrBlack;
   color cFontDeltaBid = clrBlack;
   if(ArraySize(quotes) <= quote.index)
   {
      int i = ArraySize(quotes);
      int limit = ArrayResize(quotes, quote.index+1);
      for(; i < limit; i++){
         quotes[i].ask = quote.ask;
         quotes[i].bid = quote.bid;
      }
   }
   else
   {
      if(quotes[quote.index].ask < quote.ask)
         cFontAsk = clrBlue;
      else
         cFontAsk = clrRed;
      if(quotes[quote.index].bid < quote.bid)
         cFontBid = clrBlue;
      else
         cFontBid = clrRed;
      if(quote.delta_ask < 0)
         cFontDeltaAsk = clrBlue;
      else
         cFontDeltaAsk = clrGreen;
      if(quote.delta_bid < 0)
         cFontDeltaBid = clrBlue;
      else
         cFontDeltaBid = clrGreen;
      quotes[quote.index].ask = quote.ask;
      quotes[quote.index].bid = quote.bid;
      //quotes[quote.index].delta_ask
   }
   color bgColor = quote.index %2 == 0 ? clrRed : clrBlack;
   int len = StringLen(quote.broker_name);
   if(StringLen(quote.broker_name) > 28)
      quote.broker_name = StringSubstr(quote.broker_name, 0, 28) + "...";
   ObjectSetString(0, GetObjectName(NAME_BROKER, quote.index), OBJPROP_TEXT, quote.broker_name);
   
   ObjectSetString(0, GetObjectName(NAME_ASK, quote.index), OBJPROP_TEXT, DoubleToString(quote.ask, 5));
   ObjectSetString(0, GetObjectName(NAME_BID, quote.index), OBJPROP_TEXT, DoubleToString(quote.bid, 5));
   
   string str_ask = DoubleToString(quote.delta_ask, 5);
   string str_bid = DoubleToString(quote.delta_bid, 5);
   if(quote.broker_name == AccountInfoString(ACCOUNT_COMPANY))
   {
      str_ask = "-";
      str_bid = "-";
   }
   ObjectSetString(0, GetObjectName(NAME_SASK, quote.index), OBJPROP_TEXT, str_ask);
   ObjectSetString(0, GetObjectName(NAME_SBID, quote.index), OBJPROP_TEXT, str_bid);
   
   ObjectSetInteger(0, GetObjectName(NAME_SASK, quote.index), OBJPROP_COLOR, cFontDeltaAsk);
   ObjectSetInteger(0, GetObjectName(NAME_SBID, quote.index), OBJPROP_COLOR, cFontDeltaBid);
   
   ObjectSetInteger(0, GetObjectName(NAME_ASK, quote.index), OBJPROP_COLOR, cFontAsk);
   ObjectSetInteger(0, GetObjectName(NAME_BID, quote.index), OBJPROP_COLOR, cFontBid);
   
   ChartRedraw();
}

void CPanel::SetBgColor(string name, color clr)
{
   ObjectSetInteger(0, name, OBJPROP_BORDER_COLOR, clr);
}

void CPanel::DeleteObjects()
{
   for(int i = ObjectsTotal(0)-1; i >= 0; i--)
   {
      string name = ObjectName(0, i);
      string prefix = StringSubstr(name, 0, 3);
      if(prefix != "mt_")
         continue;
      ObjectDelete(0, name);
   }
}