//+------------------------------------------------------------------+
//|                                          IncEnvelopesOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int               ENPeriod    =  14;
   input ENUM_MA_METHOD    ENMethod    =  MODE_SMA;
   input double            ENDeviation =  0.1;

   Declaration:
   #include <IncOnArray/IncEnvelopesOnArray.mqh>
   CEnvelopesOnArray en;

   In OnInit:
   en.Init(ENPeriod,ENMethod,ENDeviation);

   In OnCalculate:
   en.Solve(rates_total,prev_calculated,data,CBuffer,UBuffer,LBuffer);   
*/
#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CEnvelopesOnArray                                                |
//+------------------------------------------------------------------+
class CEnvelopesOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   double            m_Deviation;
   string            m_Name;
   CMAOnArray        m_ma;
   int               m_br;
public:
   void Init(int aPeriod=14,ENUM_MA_METHOD aMethod=MODE_SMA,double aDeviation=0.1)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_Deviation=aDeviation/100.0;
      m_ma.Init(m_Period,m_Method);
      m_Name="Envelopes("+IntegerToString(m_Period)+","+m_ma.NameMethod()+","+DoubleToString(m_Deviation,3)+")";
      m_br=m_ma.BarsRequired();
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aMA[],
              double  &aUpper[],
              double  &aLower[])
     {
      m_ma.Solve(aRatesTotal,aPrevCalc,aData,aMA);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aMA[i]!=0 && aMA[i]!=EMPTY_VALUE)
              {
               Start=i;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aUpper[i]=aMA[i]+aData[i]*m_Deviation;
         aLower[i]=aMA[i]-aData[i]*m_Deviation;
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's EnvelopesOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
