//+------------------------------------------------------------------+
//|                                             PlotManager_Demo.mq5 |
//|                         Copyright 2026, Paul Carissimo Paschini. |
//|                     https://www.mql5.com/en/users/carissimopaul/ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2026, Paul Carissimo Paschini."
#property link      "https://www.mql5.com/en/users/carissimopaul/"
#property version   "1.00"
#property indicator_chart_window

// 1. Include the Manager
#include <helper_plots.mqh> 

// 2. Define ONLY the totals
#property indicator_plots   4
#property indicator_buffers 5

// 3. Global Buffers (Standard Arrays)
double BufChannelTop[];
double BufChannelBot[];
double BufMidLine[];
double BufArrowUp[];
double BufArrowDown[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   // Instantiate the Manager
   CPlotManager pm;

   // --- A. Add a Channel (Filling) ---
   // Uses 2 Buffers, 1 Plot. 
   // Notice: We add this FIRST so it draws BEHIND everything else.
   pm.AddFilling(BufChannelTop, BufChannelBot, "High/Low Channel", clrLightSalmon);

   // --- B. Add a Center Line ---
   // Uses 1 Buffer, 1 Plot.
   pm.AddLine(BufMidLine, "Mid Line", clrDodgerBlue, 2, STYLE_SOLID);

   // --- C. Add Signals (Arrows) ---
   // Uses 1 Buffer, 1 Plot (each).
   // Notice: We don't need to manually calculate that this is Plot Index 2 and 3.
   pm.AddArrow(BufArrowUp,   "Buy Signal",  233, 20, clrLime, 2); // 233 = Up Arrow
   pm.AddArrow(BufArrowDown, "Sell Signal", 234, 20, clrRed,  2); // 234 = Down Arrow

   // --- D. Verification ---
   // We used: 2 (Fill) + 1 (Line) + 1 (Arr) + 1 (Arr) = 5 Buffers
   // We used: 1 (Fill) + 1 (Line) + 1 (Arr) + 1 (Arr) = 4 Plots
   pm.SanityCheck(5, 4);

   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start = (prev_calculated > 0) ? prev_calculated - 1 : 0;

   for(int i = start; i < rates_total; i++)
     {
      // 1. Calculate Channel (Simple High/Low offset)
      BufChannelTop[i] = high[i] + (10 * Point());
      BufChannelBot[i] = low[i]  - (10 * Point());

      // 2. Calculate Mid Line (Average)
      BufMidLine[i] = (high[i] + low[i]) / 2.0;

      // 3. Calculate Arrows (Simple Crossover Logic)
      BufArrowUp[i]   = EMPTY_VALUE;
      BufArrowDown[i] = EMPTY_VALUE;

      if(i > 0)
        {
         // If Price crosses above Mid Line
         if(close[i] > BufMidLine[i] && close[i-1] <= BufMidLine[i-1])
            BufArrowUp[i] = low[i] - (20 * Point());
         
         // If Price crosses below Mid Line
         if(close[i] < BufMidLine[i] && close[i-1] >= BufMidLine[i-1])
            BufArrowDown[i] = high[i] + (20 * Point());
        }
     }

   return(rates_total);
  }
//+------------------------------------------------------------------+