//+------------------------------------------------------------------+
//|                                            Test_VydyaOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int      VidCMOPeriod=9;
input int      VidMAPeriod=12;
//--- indicator buffers
double         VBuffer[];
double         data[];
//---
#include <IncOnArray/IncVidyaOnArray.mqh>
CVidyaOnArray vid;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   vid.Init(VidCMOPeriod,VidMAPeriod);

//--- indicator buffers mapping
   SetIndexBuffer(0,VBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,data,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,vid.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,vid.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      data[i]=price[i];
     }

   vid.Solve(rates_total,prev_calculated,data,VBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
