//+------------------------------------------------------------------+
//|                                               IncOsMAOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int               OsMAFastPeriod    =  12;
   input int               OsMASlowPeriod    =  26;
   input int               OsMASignalPeriod  =  9;
   input ENUM_MA_METHOD    OsMAFastMetod     =  MODE_EMA;
   input ENUM_MA_METHOD    OsMASlowMethod    =  MODE_EMA;
   input ENUM_MA_METHOD    OsMASignalMethod  =  MODE_SMA;

   Declaration:
   #include <IncOnArray/IncOsMAOnArray.mqh>
   COsMAOnArray osma;

   In OnInit: 
   osma.Init(OsMAFastPeriod,OsMASlowPeriod,OsMASignalPeriod,OsMAFastMetod,OsMASlowMethod,OsMASignalMethod);

   In OnCalculate:
   osma.Solve(rates_total,prev_calculated,data,FMABuffer,SMABuffer,MainBuffer,SignalBuffer,OsMABuffer);     
*/

#include <IncOnArray/IncMACDOnArray.mqh>
//+------------------------------------------------------------------+
//| COsMAOnArray                                                     |
//+------------------------------------------------------------------+
class COsMAOnArray
  {
private:
   int               m_FastPeriod;
   int               m_SlowPeriod;
   int               m_SignalPeriod;
   ENUM_MA_METHOD    m_FastMethod;
   ENUM_MA_METHOD    m_SlowMethod;
   ENUM_MA_METHOD    m_SignalMethod;
   string            m_Name;
   string            m_Names;
   CMACDOnArray      m_macd;
   int               m_br;
public:
   void Init(int aFastPeriod=12,int aSlowPeriod=26,int aSignalPeriod=9,ENUM_MA_METHOD aFastMethod=MODE_EMA,ENUM_MA_METHOD aSlowMetod=MODE_EMA,ENUM_MA_METHOD aSignalMethod=MODE_SMA)
     {
      m_FastPeriod=aFastPeriod;
      m_SlowPeriod=aSlowPeriod;
      m_SignalPeriod=aSignalPeriod;
      m_FastMethod=aFastMethod;
      m_SlowMethod=aSlowMetod;
      m_SignalMethod=aSignalMethod;
      m_macd.Init(m_FastPeriod,m_SlowPeriod,m_SignalPeriod,m_FastMethod,m_SlowMethod,m_SignalMethod);
      m_Names=m_macd.Names();
      m_Name="OsMA("+m_Names+")";
      m_br=m_macd.BarsRequiredSignal();
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aFastMA[],
              double  &aSlowMA[],
              double  &aMACDMain[],
              double  &aMACDSignal[],
              double  &aOsMA[]
              )
     {
      m_macd.Solve(aRatesTotal,aPrevCalc,aData,aFastMA,aSlowMA,aMACDMain,aMACDSignal);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aMACDMain[i]!=0 && aMACDMain[i]!=EMPTY_VALUE && aMACDSignal[i]!=0 && aMACDSignal[i]!=EMPTY_VALUE)
              {
               Start=i;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aOsMA[i]=aMACDMain[i]-aMACDSignal[i];
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string Names()
     {
      return(m_Names);
     }
   string About()
     {
      return("Integer's OsMAOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
