//+------------------------------------------------------------------+
//|                                               IncMACDOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int               MACDFastPeriod    =  12;
   input int               MACDSlowPeriod    =  26;
   input int               MACDSignalPeriod  =  9;
   input ENUM_MA_METHOD    MACDFastMetod     =  MODE_EMA;
   input ENUM_MA_METHOD    MACDSlowMethod    =  MODE_EMA;
   input ENUM_MA_METHOD    MACDSignalMethod  =  MODE_SMA;

   Declaration:
   #include <IncOnArray/IncMACDOnArray.mqh>
   CMACDOnArray macd;
   
   In OnInit:
   macd.Init(MACDFastPeriod,MACDSlowPeriod,MACDSignalPeriod,MACDFastMetod,MACDSlowMethod,MACDSignalMethod);

   In OnCalculate:
   macd.Solve(rates_total,prev_calculated,data,FMABuffer,SMABuffer,MainBuffer,SignalBuffer); 
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CMACDOnArray                                                     |
//+------------------------------------------------------------------+
class CMACDOnArray
  {
private:
   int               m_FastPeriod;
   int               m_SlowPeriod;
   int               m_SignalPeriod;
   ENUM_MA_METHOD    m_FastMethod;
   ENUM_MA_METHOD    m_SlowMethod;
   ENUM_MA_METHOD    m_SignalMethod;
   string            m_Name;
   string            m_NameMain;
   string            m_NameSignal;
   string            m_Names;
   CMAOnArray        m_FastMA;
   CMAOnArray        m_SlowMA;
   CMAOnArray        m_SignalMA;
   int               m_brm;
   int               m_brs;
public:
   void Init(int aFastPeriod=12,int aSlowPeriod=26,int aSignalPeriod=9,ENUM_MA_METHOD aFastMethod=MODE_EMA,ENUM_MA_METHOD aSlowMetod=MODE_EMA,ENUM_MA_METHOD aSignalMethod=MODE_SMA)
     {
      m_FastPeriod=aFastPeriod;
      m_SlowPeriod=aSlowPeriod;
      m_SignalPeriod=aSignalPeriod;
      m_FastMethod=aFastMethod;
      m_SlowMethod=aSlowMetod;
      m_SignalMethod=aSignalMethod;
      m_SignalMA.Init(m_SignalPeriod,m_SignalMethod);
      m_FastMA.Init(m_FastPeriod,m_FastMethod);
      m_SlowMA.Init(m_SlowPeriod,m_SlowMethod);
      m_Names=m_FastMA.Name()+","+m_SlowMA.Name()+","+m_SignalMA.Name();
      m_Name="MACD("+m_Names+")";
      m_NameMain="Main("+m_FastMA.Name()+","+m_SlowMA.Name()+")";
      m_NameSignal="Signal("+m_SignalMA.Name()+")";
      m_brm=MathMax(m_FastMA.BarsRequired(),m_SlowMA.BarsRequired());
      m_brs=m_brm+m_SignalMA.BarsRequired()-1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aFastMA[],
              double  &aSlowMA[],
              double  &aMain[],
              double  &aSignal[]
              )
     {
      m_FastMA.Solve(aRatesTotal,aPrevCalc,aData,aFastMA);
      m_SlowMA.Solve(aRatesTotal,aPrevCalc,aData,aSlowMA);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aFastMA[i]!=0 && aFastMA[i]!=EMPTY_VALUE && aSlowMA[i]!=0 && aSlowMA[i]!=EMPTY_VALUE)
              {
               Start=i;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aMain[i]=aFastMA[i]-aSlowMA[i];
        }
      m_SignalMA.Solve(aRatesTotal,aPrevCalc,aMain,aSignal);
     }
   int BarsRequiredSignal()
     {
      return(m_brs);
     }
   int BarsRequiredMain()
     {
      return(m_brm);
     }
   string Name()
     {
      return(m_Name);
     }
   string NameMain()
     {
      return(m_NameMain);
     }
   string NameSignal()
     {
      return(m_NameSignal);
     }
   string Names()
     {
      return(m_Names);
     }
   string About()
     {
      return("Integer's MACDOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
