//+------------------------------------------------------------------+
//|                                        LogifyCompleteExample.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Import                                                           |
//+------------------------------------------------------------------+
#include <Logify/Logify.mqh>
CLogify Logify;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Configure comment handler
   MqlLogifyHandleCommentConfig config_comment;
   config_comment.size = 10;
   config_comment.frame_style = LOG_FRAME_STYLE_SINGLE;
   config_comment.direction = LOG_DIRECTION_UP;
   config_comment.title = "My Expert";

//--- Create and configure comment handler
   CLogifyHandlerComment *handler_comment = new CLogifyHandlerComment();
   handler_comment.SetConfig(config_comment);
   handler_comment.SetLevel(LOG_LEVEL_DEBUG);
   handler_comment.SetFormatter(new CLogifyFormatter("{date_time} [{levelname}]: {msg}","hh:mm:ss"));

//--- Configure file handler
   MqlLogifyHandleFileConfig file_config;
   file_config.CreateDateRotationConfig("my_expert","logs",LOG_FILE_EXTENSION_LOG,10,100,CP_UTF8);

//--- Create and configure file handler
   CLogifyHandlerFile *handler_file = new CLogifyHandlerFile();
   handler_file.SetConfig(file_config);
   handler_file.SetLevel(LOG_LEVEL_DEBUG);
   handler_file.SetFormatter(new CLogifyFormatter("{date_time} [{levelname}]: {msg} ({filename} | {origin} | {function})","hh:mm:ss"));

//--- Attach handler
   Logify.AddHandler(handler_comment);
   Logify.AddHandler(handler_file);

//--- Example logs
   Logify.Debug("Initialization started");
   Logify.Info("Account balance is OK");
   Logify.Alert("Take profit reached");
   Logify.Error("Failed to send order", "Order", "Reason: No money");
   Logify.Fatal("Critical error: Invalid input parameters");

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

  }
//+------------------------------------------------------------------+
