//+------------------------------------------------------------------+
//|                                                    MyComment.mqh |
//|                              Copyright 2011, Alexander Piechotta |
//|                                        http://www.MetaTraders.de |
//|                                              Revision 2011.09.26 |
//+------------------------------------------------------------------+
//+-------------------------------------------------------------------+
//|Class MyComment.                                                   |
//|                                                                   |
//|This function outputs a comment in the top left corner of a chart. |
//|The comments are added on a new line.                              |
//|Without deleting existing comments.                                |
//|The comments also show the current time and the name of the script.|
//|This function can be issued.                                       |
//+-------------------------------------------------------------------+
class MyComment
  {
public:
                     MyComment();
                    ~MyComment(); // Delete all my comments
   bool              SHOW_MQL5ProgramName;
   bool              SHOW_CurrentLocalTime;
   long              chartID;
   void              Add_MyComment(string com="");
   void              Del_MyComments();
protected:
   string            info;
   string            s_Com[];
   int               dS;
  };
//+------------------------------------------------------------------+
//| MyComment class constructor                                      |
//+------------------------------------------------------------------+
MyComment :: MyComment(void)
  {
   SHOW_MQL5ProgramName=true;
   SHOW_CurrentLocalTime=true;
   chartID=ChartID();
  }
//+------------------------------------------------------------------+
//| MyComment class destructor                                       |
//+------------------------------------------------------------------+
MyComment :: ~MyComment(void)
  {
// Delete all my comments
   long p_handle=0;
   long handle=ChartNext(p_handle);

   while(handle!=-1)
     {
      p_handle=handle;

      string com=(string)ChartGetString(handle,CHART_COMMENT);
      for(int f=0;f<ArraySize(s_Com);f++)
        {
         StringReplace(com,s_Com[f],"");
        }
      ChartSetString(handle,CHART_COMMENT,com);
      ChartRedraw(handle);
      handle=ChartNext(p_handle);
     }
  }
//+------------------------------------------------------------------+
//| Add_MyComment                                                    |
//+------------------------------------------------------------------+
void MyComment :: Add_MyComment(string com)
  {
   info="";
   if(SHOW_CurrentLocalTime)info=(string)TimeLocal()+" ";
   if(SHOW_MQL5ProgramName)info=info+" ("+MQL5InfoString(MQL5_PROGRAM_NAME)+")"+": ";

   dS=dS+1;
   ArrayResize(s_Com,dS+1);
   s_Com[dS]="\n"+info+com;

   com=(string)ChartGetString(chartID,CHART_COMMENT)+"\n"+info+com;

   ChartSetString(chartID,CHART_COMMENT,com);
   ChartRedraw(chartID);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Del_MyComments                                                   |
//+------------------------------------------------------------------+
MyComment :: Del_MyComments()
  {
   string com=(string)ChartGetString(chartID,CHART_COMMENT);
   for(int f=0;f<ArraySize(s_Com);f++)
     {
      StringReplace(com,s_Com[f],"");
     }
   ChartSetString(chartID,CHART_COMMENT,com);
   ChartRedraw(chartID);

  }
//+------------------------------------------------------------------+
