//+------------------------------------------------------------------+
//|                                                     T3Signal.mqh |
//|                                                    2011, etrader |
//|                                             http://efftrading.ru |
//+------------------------------------------------------------------+
#property copyright "2011, etrader"
#property link      "http://efftrading.ru"
//+------------------------------------------------------------------+
//| include files                                                    |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#define INDICATOR_T3_FILENAME "T3.ex5"
#property tester_indicator INDICATOR_T3_FILENAME
#include <Expert\MySignals\BasedOnIndicatorExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signal based on T3 indicator                               |
//| Type=SignalAdvanced                                              |
//| Name=T3                                                          |
//| Class=CT3                                                        |
//| Page=                                                            |
//| Parameter=T3Period,int,14,period of T3                           |
//| Parameter=b_,double,70,coefficient x100                          |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| CT3 class                                                        |
//| Purpose: Class of trading signals module, based on T3 indicator  |
//|          http://www.mql5.com/en/code/424                         |
//+------------------------------------------------------------------+
class CT3: public CBasedOnIndicatorExpertSignal
  {
private:
   int               m_T3Period;            // Period of T3
   double            m_b_;                  // Coefficient x100                          

public:
   virtual int       ShortCondition();      // Check conditions to open short position
   virtual int       LongCondition();       // Check conditions to open long position
   virtual void      FillParameters();      // Fill m_parameters arrays
   //--- sets period of T3
   void              T3Period(int passedvalue){ m_T3Period=passedvalue;}
   //--- sets coefficient x100                          
   void              b_(double passedvalue) { m_b_=passedvalue;}
  };
//+------------------------------------------------------------------+
//| Setting parameters of custom indicator                           |
//| INPUT: none                                                      |
//| OUTPUT: none                                                     |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
void CT3::FillParameters(void)
  {
//--- array size=3, number of input parameters
   ArrayResize(m_parameters,3);
//--- indicator name
   m_parameters[0].type         = TYPE_STRING;
   m_parameters[0].string_value = INDICATOR_T3_FILENAME;
//--- period of T3
   m_parameters[1].type=TYPE_INT;
   m_parameters[1].integer_value=m_T3Period;
//--- coefficient x100                          
   m_parameters[2].type=TYPE_DOUBLE;
   m_parameters[2].double_value=m_b_;
  }
//+------------------------------------------------------------------+
//| Checks conditions to open short position                         |
//| INPUT:  None                                                     |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: None.                                                    |
//+------------------------------------------------------------------+
int CT3::ShortCondition()
  {
//--- the 0th buffer of T3 indicator is used
//--- checking of downward crossover
   if(Close(1)<m_indicator.GetData(0,1) && Close(2)>=m_indicator.GetData(0,2))   return(100);
//--- condition is not satisfied
   return(0);
     }
//+------------------------------------------------------------------+
//| Checks conditions to open long position                          |
//| INPUT:  None                                                     |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: None.                                                    |
//+------------------------------------------------------------------+
int CT3::LongCondition()
  {
//--- the 0th buffer of T3 indicator is used
//--- checking of upward crossover
   if(Close(1)>m_indicator.GetData(0,1) && Close(2)<=m_indicator.GetData(0,2))   return(100);
//--- condition is not satisfied
   return(0);
  }
//+------------------------------------------------------------------+