//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CMultipleLogisticRegression
  {
     private:
                           double  e; //Euler's number 
                           double  t_minus;
                           string  m_XColsArray[];
                           string  m_AllDataArray[];
                           double  m_yintercept; //universal all data constant
                           double  m_yPredicted[]; //all the predicted values will be stored here
                           
     protected:             
                           double  y_Array[]; //Array of all the dependent variables labeled as Y
                           bool    m_debug; 
                           int     m_handle;
                           string  m_delimiter;
                           string  m_filename;
                           int     rows_total;
                           int     x_columns_total; 
                           
                           bool    fileopen();
                           double  mean(double &data[]);
                           void    GetAllDataToArray(string& array[]);
                           void    GetColumnDatatoArray(int from_column_number, double &toArr[]);
                           
      public:
                           CMultipleLogisticRegression(void);
                          ~CMultipleLogisticRegression(void);
                           
                           void    MLRInit(string filename=NULL, string delimiter=",", int y_column=1, string x_columns="3,4,5,6,7,8", bool isdebug=true);
                           double  MultipleLogisticRegression(double& accuracy);
                           void    Each_CoeffiecientOfX(double& x[], double& y[], double& coeff);
                           void    mx_Intercept(double& x[], double& y[], double& mx);
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CMultipleLogisticRegression::CMultipleLogisticRegression(void)
 {
    e = 2.718281828; 
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CMultipleLogisticRegression::~CMultipleLogisticRegression(void)
 {
   FileClose(m_handle); 
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CMultipleLogisticRegression::MLRInit(string filename=NULL,string delimiter=",",int y_column=1,string x_columns="3,4,5,6,7,8",bool isdebug=true)
 {
   m_delimiter = delimiter;
   m_debug = isdebug;
   m_filename = filename;
//---
   ushort separator = StringGetCharacter(m_delimiter,0);
   StringSplit(x_columns,separator,m_XColsArray);
   x_columns_total = ArraySize(m_XColsArray);

   if (m_debug) 
     Print("Init, number of X columns chosen =",x_columns_total);
//---
   GetColumnDatatoArray(y_column,y_Array); //Get all data from this column The Library's Y values
   GetAllDataToArray(m_AllDataArray); //Get all the X data to this Array
   
   string EachXDataArray[];
   ArrayResize(EachXDataArray,rows_total);
//---

   int start = 0;
   if (m_debug) //if we are on debug mode print Each Array vs its row
      for (int i=0; i<x_columns_total; i++)
         {
            ArrayCopy(EachXDataArray,m_AllDataArray,0,start,rows_total);
            start += rows_total; 
            
            Print("Array Number =",i," From column number ",m_XColsArray[i]);
            ArrayPrint(EachXDataArray);     
         } 
//---
        
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CMultipleLogisticRegression::fileopen(void)
 { 
    m_handle  = FileOpen(m_filename,FILE_READ|FILE_CSV|FILE_ANSI,m_delimiter); 

    if (m_handle == INVALID_HANDLE)
      {
         return(false);
         Print(__FUNCTION__," Invalid csv handle err=",GetLastError());
      }
   return (true);
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CMultipleLogisticRegression::GetAllDataToArray(string &toArr[])
 {
    int counter=0; 
    
    for (int i=0; i<ArraySize(m_XColsArray); i++)
      {            
        if (fileopen())
         { 
          int column = 0, rows=0;
          while (!FileIsEnding(m_handle))
            {
              string data = FileReadString(m_handle);

              column++;
   //---      
              if (column==(int)m_XColsArray[i])
                 {                      
                     if (rows>=1) //Avoid the first column which contains the column's header
                       {   
                           counter++;
                           
                           ArrayResize(toArr,counter); //array size for all the columns 
                           toArr[counter-1]=data;
                       }   
                        
                 }
   //---
              if (FileIsLineEnding(m_handle))
                {                     
                   rows++;
                   column=0;
                }
            } 
          rows_total = rows-1; //since we are avoiding the first row we have to also remove it's number on the list here
        }
         FileClose(m_handle); 
     }
    
    if (m_debug)
     Print("All data Array Size ",ArraySize(m_AllDataArray)," consuming ", sizeof(toArr)," bytes of memory");
     
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CMultipleLogisticRegression::GetColumnDatatoArray(int from_column_number, double &toArr[])
 {
    int counter=0;
    
    if (fileopen())
     {
       int column = 0, rows=0;
       while (!FileIsEnding(m_handle))
         {
           string data = FileReadString(m_handle);
           
           column++;
//---      
           if (column==from_column_number)
              {
                  if (rows>=1) //Avoid the first column which contains the column's header
                    {   
                        counter++;
                        ArrayResize(toArr,counter); 
                        toArr[counter-1]=(double)data;
                    }   
                     
              }
//---
           if (FileIsLineEnding(m_handle))
             {                     
               rows++;
               column=0;
             }
         }
     }
   FileClose(m_handle);
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CMultipleLogisticRegression::mean(double &data[])
 {
   double x_y__bar=0;
   
   for (int i=0; i<ArraySize(data); i++)
     {
      x_y__bar += data[i]; // all values summation
     }
           
    x_y__bar = x_y__bar/ArraySize(data); //total value after summation divided by total number of elements
   
   return(x_y__bar); 
 }
//+------------------------------------------------------------------+
//|          From Linear Regression Model                            |
//+------------------------------------------------------------------+
void CMultipleLogisticRegression::Each_CoeffiecientOfX(double& x[], double& y[], double &coeff)
 {
   double x_mean = mean(x);
   double y_mean = mean(y);
   
   double m=0; 
    {
      double x__x=0, y__y=0;
      double numerator=0, denominator=0; 
      
      for (int i=0; i<ArraySize(x); i++)
       {
         x__x = x[i] - x_mean; //right side of the numerator (x-side)
         y__y = y[i] - y_mean; //left side of the numerator  (y-side)
        
         
         numerator += x__x * y__y;  //summation of the product two sides of the numerator
         denominator += MathPow(x__x,2); 
       }
      m = numerator/denominator;
    }
   coeff = m;
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CMultipleLogisticRegression::mx_Intercept(double &x[],double &y[],double &mx)
 {
   
   double x_mean = mean(x);
   double y_mean = mean(y);
   // c = y - mx
   double m=0;
   Each_CoeffiecientOfX(x,y,m); //call the coefficient of x and grab the m (slope)
   
    mx = m*x_mean; // just 
 }
//+------------------------------------------------------------------+
//|             The Main Multiple regression Function               |
//+------------------------------------------------------------------+ 
double CMultipleLogisticRegression::MultipleLogisticRegression(double &accuracy)
 {
   ArrayResize(m_yPredicted,rows_total);
//--- Let's find the intercept for all the data
   
   string EachXDataArray[];
   ArrayResize(EachXDataArray,rows_total);
   int start = 0; double mx=0; double y_mean = mean(y_Array), x_mean=0, sum_mx=0, slope=0;
   
   for (int i=0; i<x_columns_total; i++)
      {
         ArrayCopy(EachXDataArray,m_AllDataArray,0,start,rows_total);
         start += rows_total;     
         
         double EachXDataArrayDouble[];
         ArrayResize(EachXDataArrayDouble,ArraySize(EachXDataArray));
         for (int j=0; j<ArraySize(EachXDataArrayDouble); j++)
              EachXDataArrayDouble[j] = (double)EachXDataArray[j];  
              
// Now that we have each Value of X to Its array
               
         mx_Intercept(EachXDataArrayDouble,y_Array,mx);
         mx -= mx;
      }
      
//---
      
     m_yintercept = y_mean - mx; //Remember? that this is searched for all the data and then kept constant itself\
     
//--- All data summation of slope and intercept 

   for (int i=0; i<x_columns_total; i++)
      {
         ArrayCopy(EachXDataArray,m_AllDataArray,0,start,rows_total);
         start += rows_total;     
         
         double EachXDataArrayDouble[];
         ArrayResize(EachXDataArrayDouble,ArraySize(EachXDataArray));
         for (int j=0; j<ArraySize(EachXDataArrayDouble); j++)
              EachXDataArrayDouble[j] = (double)EachXDataArray[j];  
              
// Now that we have each Value of X to Its array
               
                  x_mean = mean(EachXDataArrayDouble); //the mean of all x values also termed as just x on y = mx+c
                  Each_CoeffiecientOfX(EachXDataArrayDouble,y_Array,slope);
                  sum_mx += slope*x_mean;
                 
         
               
      }
      
//---

   ArrayResize(EachXDataArray,rows_total);
   double EachXDataArrayDouble[];
   ArrayResize(EachXDataArrayDouble,ArraySize(EachXDataArray)); 
   
   
   for (int j=0; j<ArraySize(EachXDataArrayDouble); j++)
        EachXDataArrayDouble[j] = (double)EachXDataArray[j];  
   
    for (int i=0; i<ArraySize(EachXDataArrayDouble); i++)
       {
          double sigmoid = 1/(1+MathPow(e,-(sum_mx+m_yintercept))); 
          m_yPredicted[i] = (int) round(sigmoid); //round the values to give us the actual 0 or 1
          break;
       }
    
//---
       
     
/*     
   string EachXDataArray[];
   ArrayResize(EachXDataArray,rows_total);
   int start = 0; double mx=0; double y_mean = mean(y_Array), x_mean=0, sum_mx=0, slope=0;
   
   for (int i=0; i<x_columns_total; i++)
      {
         ArrayCopy(EachXDataArray,m_AllDataArray,0,start,rows_total);
         start += rows_total;     
         
         double EachXDataArrayDouble[];
         ArrayResize(EachXDataArrayDouble,ArraySize(EachXDataArray));
         for (int k=0; k<ArraySize(EachXDataArrayDouble); k++)
              EachXDataArrayDouble[k] = (double)EachXDataArray[k]; 
               
         
      }*/
     
    return (accuracy); 
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+   //+------------------------------------------------------------------+