//+------------------------------------------------------------------+
//|                                       FileUnlimitedConstants.mqh |
//+------------------------------------------------------------------+
#property copyright "TheXpert"
#property link      "theforexpert@gmail.com"

//====    "CreateFile()".
// ----  "dwDesiredAccess".
#define FU_GENERIC_WRITE                0x40000000 //     .
#define FU_GENERIC_READ                 0x80000000 //     .
// ----     "dwDesiredAccess".
#define FU_FILE_ADD_FILE                0x0002     //  ,     .
#define FU_FILE_ADD_SUBDIRECTORY        0x0004     //  ,   subdirectory.
#define FU_FILE_APPEND_DATA             0x0004     //   ,     .
#define FU_FILE_CREATE_PIPE_INSTANCE    0x0004     //   ,   .
#define FU_FILE_DELETE_CHILD            0x0040     //  ,      ,   ,     .
#define FU_FILE_EXECUTE                 0x0020     //    ,   .        ,   ,     .
#define FU_FILE_LIST_DIRECTORY          0x0001     //  ,    .
#define FU_FILE_READ_ATTRIBUTES         0x0080     //    .
#define FU_FILE_READ_DATA               0x0001     //   ,     .   ,     .
#define FU_FILE_READ_EA                 0x0008     //     .
#define FU_FILE_TRAVERSE                0x0020     //  ,   .  ,    BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
#define FU_FILE_WRITE_ATTRIBUTES        0x0100     //    .
#define FU_FILE_WRITE_DATA              0x0002     //   ,     .   ,      (FILE_ADD_FILE).
#define FU_FILE_WRITE_EA                0x0010     //     .
// ----  "dwShareMode".
#define FU_FILE_SHARE_NO                0x00000000 //    .
#define FU_FILE_SHARE_READ              0x00000001 //          .
#define FU_FILE_SHARE_WRITE             0x00000002 //          .
#define FU_FILE_SHARE_DELETE            0x00000004 //          . 
// ----  "dwCreationDisposition".
#define FU_CREATE_NEW                   1          //   ,    .
#define FU_CREATE_ALWAYS                2          //   , .
#define FU_OPEN_EXISTING                3          //    ,   .
#define FU_OPEN_ALWAYS                  4          //  , .
#define FU_TRUNCATE_EXISTING            5          //        -  ,    .
// ----  "dwFlagsAndAttributes".
// ---- .
#define FU_FILE_ATTRIBUTE_READONLY      0x1        //    (1)   .    ,        .
#define FU_FILE_ATTRIBUTE_HIDDEN        0x2        //    (2)  .       .
#define FU_FILE_ATTRIBUTE_SYSTEM        0x4        //    (4)        .
#define FU_FILE_ATTRIBUTE_ARCHIVE       0x20       //   (32)    .    ,       .
#define FU_FILE_ATTRIBUTE_NORMAL        0x80       //  (128)      .   -      .
#define FU_FILE_ATTRIBUTE_TEMPORARY     0x100      //  (256)     .
#define FU_FILE_ATTRIBUTE_OFFLINE       0x1000     // (4096)     .   ,       offline .
#define FU_FILE_ATTRIBUTE_ENCRYPTED     0x4000     //(16384)    .
// ---- .
#define FU_FILE_FLAG_BACKUP_SEMANTICS   0x02000000 //         .
#define FU_FILE_FLAG_DELETE_ON_CLOSE    0x04000000 //      .
#define FU_FILE_FLAG_NO_BUFFERING       0x20000000 //      ,      .
#define FU_FILE_FLAG_OPEN_NO_RECALL     0x00100000 //   ,        .
#define FU_FILE_FLAG_OPEN_REPARSE_POINT 0x00200000 //  reparse    ; CreateFile   reparse .
#define FU_FILE_FLAG_OVERLAPPED         0x40000000 //         /.
#define FU_FILE_FLAG_POSIX_SEMANTICS    0x0100000  //     POSIX.
#define FU_FILE_FLAG_RANDOM_ACCESS      0x10000000 //    .      ,    .
#define FU_FILE_FLAG_SEQUENTIAL_SCAN    0x08000000 //      ,  .      ,    .
#define FU_FILE_FLAG_WRITE_THROUGH      0x80000000 //        ,     .
//====    "OpenFile()".
// ----  "wStyle".
#define FU_OF_CANCEL                    0x00000800 // .  ,    ,   ,  OF_PROMPT.
#define FU_OF_CREATE                    0x00001000 //   .   ,     (0) .
#define FU_OF_DELETE                    0x00000200 //  .
#define FU_OF_EXIST                     0x00004000 //     .  ,     .
#define FU_OF_PARSE                     0x00000100 //   OFSTRUCT,    - .
#define FU_OF_PROMPT                    0x00002000 //        .
#define FU_OF_READ                      0x00000000 //     .
#define FU_OF_READWRITE                 0x00000002 //    / .
#define FU_OF_REOPEN                    0x00008000 //        .
#define FU_OF_SHARE_COMPAT              0x00000000 //    -DOS based,     ,      ,     .
#define FU_OF_SHARE_DENY_NONE           0x00000040 //           .
#define FU_OF_SHARE_DENY_READ           0x00000030 //         .
#define FU_OF_SHARE_DENY_WRITE          0x00000020 //         .
#define FU_OF_SHARE_EXCLUSIVE           0x00000010 //         /    .
#define FU_OF_WRITE                     0x00000001 //     .
//====    "SetFilePointer()".
#define FU_FILE_BEGIN                   0          //   .
#define FU_FILE_CURRENT                 1          //   .
#define FU_FILE_END                     2          //   .

#define INVALID_SET_FILE_POINTER (uint(-1))
#define INVALID_FILE_ATTRIBUTES (uint(-1))

enum DesiredAccess
{
	  DA_READ_WRITE = FU_GENERIC_READ | FU_GENERIC_WRITE
	, DA_WRITE = FU_GENERIC_WRITE
};

enum CreationDisposition
{
	  CD_CREATE_NEW = FU_CREATE_NEW                 // always create new file
	, CD_CREATE_ALWAYS = FU_CREATE_ALWAYS           // create if does not exist, or open without errors
	, CD_OPEN_EXISTING = FU_OPEN_EXISTING           // will fail if file does not exist
	, CD_OPEN_ALWAYS = FU_OPEN_ALWAYS               // create if does not exist, or open with error ERROR_ALREADY_EXISTS (80)
	, CD_TRUNCATE_EXISTING = FU_TRUNCATE_EXISTING   // will fail if file does not exist or truncate it if exists
};

enum MovePointerMethod
{
	  MPM_BEGIN = FU_FILE_BEGIN            // relative count from the beginning
	, MPM_CURRENT = FU_FILE_CURRENT        // relative count from current
	, MPM_END = FU_FILE_END                // relative count from the end
};

class ConstFile
{
public:
   ConstFile(const string& path) {}

   virtual bool Read(bool& Value, string separator = " \r\n\t"){return false;}
   virtual bool Read(long& Value, string separator = " \r\n\t"){return false;}
   virtual bool Read(double& Value, string separator = " \r\n\t"){return false;}
   virtual bool Read(string& Value, string separator = "\r\n"){return false;}
   virtual bool Read(datetime& Value, string separator = "\r\n\t"){return false;}
   virtual bool Read(color& Value, string separator = " \r\n\t"){return false;}

   virtual bool SetPos(long pos, MovePointerMethod from = MPM_BEGIN){return false;}
   
   virtual ulong Size() const {return 0;}
   virtual datetime CreationTime() const {return 0;}
   virtual datetime LastAccessTime() const {return 0;}
   virtual datetime LastModifyTime() const {return 0;}
   
   virtual string Path() const {return "";}
   virtual string ToString() {return "";}
};

class File
   : public ConstFile
{
public:
   File(const string& path, CreationDisposition options, DesiredAccess access)
      : ConstFile(path)
   {}

   virtual bool Write(bool Value, string separator = " "){return false;}
   virtual bool Write(long Value, string separator = " "){return false;}
   virtual bool Write(double Value, string separator = " "){return false;}
   virtual bool Write(string Value, string separator = "\n"){return false;}
   virtual bool Write(datetime Value, string separator = " "){return false;}
   virtual bool Write(color Value, string separator = " "){return false;}
};

