//+------------------------------------------------------------------+
//|                                              CompareFunction.mqh |
//|                                    2019-2021, dimitri pecheritsa |
//|                                         mql5.com/en/users/dmipec |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| overloads                                                        |
//|  (1) compare bool (x, y)                                         |
//|  (2) compare char (x, y)                                         |
//|  (3) compare uchar (x, y)                                        |
//|  (4) compare short (x, y)                                        |
//|  (5) compare ushort (x, y)                                       |
//|  (6) compare color  (x, y)                                       |
//|  (7) compare int (x, y)                                          |
//|  (8) compare uint (x, y)                                         |
//|  (9) compare datetime (x, y)                                     |
//|  (10) compare long (x, y)                                        |
//|  (11) compare ulong (x, y)                                       |
//|  (12) compare float (x, y)                                       |
//|  (13) compare double (x, y)                                      |
//|  (14) compare string (x, y)                                      |
//|  (15) compare custom (x, y)                                      |
//|  (16) compare custom (x, y, comparer)                            |
//| notes: a universal overloaded compare method for all standard    |
//|mql types. returns 1 if x greater than y, -1 if x less than y,    |
//|and 0 if x and y are equal. custom compare methods rely on two    |
//|interfaces: comparable and comparer                               |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| (1) compare bool                                                 |
//+------------------------------------------------------------------+
int Compare(const bool x,const bool y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (2) compare char                                                 |
//+------------------------------------------------------------------+
int Compare(const char x,const char y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (3) compare uchar                                                |
//+------------------------------------------------------------------+
int Compare(const uchar x,const uchar y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (4) compare short                                                |
//+------------------------------------------------------------------+
int Compare(const short x,const short y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (5) compare ushort                                               |
//+------------------------------------------------------------------+
int Compare(const ushort x,const ushort y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (6) compare color                                                |
//+------------------------------------------------------------------+
int Compare(const color x,const color y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (7) compare int                                                  |
//+------------------------------------------------------------------+
int Compare(const int x,const int y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (8) compare uint                                                 |
//+------------------------------------------------------------------+
int Compare(const uint x,const uint y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (9) compare datetime                                             |
//+------------------------------------------------------------------+
int Compare(const datetime x,const datetime y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (10) compare long                                                |
//+------------------------------------------------------------------+
int Compare(const long x,const long y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (11) compare ulong                                               |
//+------------------------------------------------------------------+
int Compare(const ulong x,const ulong y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| (12) compare float                                               |
//+------------------------------------------------------------------+
int Compare(const float x,const float y,int digits=13)
  {
   double min=pow(10,-fabs(digits));
   return (((fabs(x-y)<min))? 0 : ((x-y>=min))? 1 : -1);
  }
//+------------------------------------------------------------------+
//| (13) compare double                                              |
//+------------------------------------------------------------------+
int Compare(const double x,const double y,int digits=13)
  {
   double min=pow(10,-fabs(digits));
   return (((fabs(x-y)<min))? 0 : ((x-y>=min))? 1 : -1);
  }
//+------------------------------------------------------------------+
//| (14) compare string                                              |
//+------------------------------------------------------------------+
int Compare(const string x,const string y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| interface comparable                                             |
//+------------------------------------------------------------------+
template<typename T>
interface IComparable
  {
   int       Compare(T value);
  };
//+------------------------------------------------------------------+
//| (15) compare custom                                              |
//|  [in] x                                                          |
//|  [in] y                                                          |
//|  [ret] -1 / 0 / +1. compare custom objects x and y by casting    |
//|one of them to a comparable object                                |
//+------------------------------------------------------------------+
template<typename T>
int Compare(T x,T y)
  {
//--- try to convert to a comparable object
   IComparable<T>*comparable=dynamic_cast<IComparable<T>*>(x);
   return (comparable)?
//--- use the specified compare method
          comparable.Compare(y):
//--- unknown compare function
          int("nan");
  }
//+------------------------------------------------------------------+
//| interface comparer                                               |
//+------------------------------------------------------------------+
template<typename T>
interface IComparer
  {
   int       Compare(T x,T y);
  };
//+------------------------------------------------------------------+
//| (16) compare custom                                              |
//|  [in] x                                                          |
//|  [in] y                                                          |
//|  [in] comparer: an external compatible comparer                  |
//|  [ret] -1 / 0 / +1. compare custom objects x and y by using the  |
//|external 'comparer'. if comparer is invalid returns nan, which    |
//|means an error                                                    |
//+------------------------------------------------------------------+
template<typename T>
int Compare(T x,T y,IComparer* comparer)
  {
//--- avoid invalid pointer
   if(CheckPointer(comparer)==0)
      return int("nan");
//--- use the proposed comparer
   return comparer.Compare(x,y);
  }
//+------------------------------------------------------------------+
