//+------------------------------------------------------------------+
//|                                                    Functions.mqh |
//|                                    2019-2021, dimitri pecheritsa |
//|                                         mql5.com/en/users/dmipec |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| functions for the shell sort example script                      |
//|  (1) symbols load (out[])                                        |
//|  (2) symbols keys digit (in[], out[])                            |
//|  (3) symbols print (in[])                                        |
//|  (4) array sort (keys[], items[], algorithm, order)              |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| (1) symbols load                                                 |
//|  [out] symbols: destination array where symbols will be loaded   |
//|from the terminal                                                 |
//|  [ret] number of copied items                                    |
//+------------------------------------------------------------------+
int SymbolsLoad(string& dst_symbols[])
  {
   int total=SymbolsTotal(false);
   for(int i=0; i<total; i++)
     {
      int size=ArraySize(dst_symbols);
      ArrayResize(dst_symbols,size+1,size*2);
      dst_symbols[size]=SymbolName(i,false);
     }
   return total;
  }
//+------------------------------------------------------------------+
//| (2) symbols keys digits                                          |
//|  [in] symbols: source array with symbols                         |
//|  [out] keys: destination array for symbol digits                 |
//|  [ret] number of items copied. the destination 'keys' is filled  |
//|with the symbol digits values which are extracted from the        |
//|elements of the source 'symbols'                                  |
//+------------------------------------------------------------------+
void SymbolKeysDigit(string& symbols[],int& keys[])
  {
   int total=ArraySize(symbols);
   ArrayResize(keys,total);
   for(int i=0; i<total; i++)
      keys[i]=(int)SymbolInfoInteger(symbols[i],SYMBOL_DIGITS);
  }
//+------------------------------------------------------------------+
//| (3) symbols print                                                |
//|  [in] symbols: source array with the names of the symbols        |
//|  [ret] void. print a table of symbols consiting of three         |
//|columns: name, color, and digits                                  |
//+------------------------------------------------------------------+
void SymbolsPrint(string& symbols[])
  {
//--- create horizontal table line
   string line;
   StringInit(line,68,'-');
//--- header
   printf(line);
   printf("%13s | %34s | %8s","symbol","color name (id)","digits");
   printf(line);
//--- body
   int total=ArraySize(symbols);
   for(int i=0; i<total; i++)
     {
      //--- some data for the symbol 
      int clr_id=(int)SymbolInfoInteger(symbols[i],SYMBOL_BACKGROUND_COLOR);
      string clr=StringFormat("%s (%d)",ColorToString((color)clr_id,true),clr_id);
      int digits=(int)SymbolInfoInteger(symbols[i],SYMBOL_DIGITS);
      //--- out
      printf("%13s | %34s | %8d",symbols[i],clr,digits);
     }
  }
//+------------------------------------------------------------------+
//| (4) array sort                                                   |
//|  [in/out] keys: array which values are compared and sorted       |
//|  [in/out] items: main array which items are swapped, and thus    |
//|sorted the same way as the keys array. 'items' are ignored if its |
//|length does not match the length of the 'keys'                    |
//|  [in] algorithm: any compatible sorting algorithm                |
//|  [in] sorting order flag: accending true / descending false      |
//|  [ret] void. sorts 'items' by 'keys' with the specified concrete |
//|sorting algorithm, in accending or descending order               |
//+------------------------------------------------------------------+
#include <Mqh\Algorithms\ASorter.mqh>
template<typename TKey,typename TItem>
void ArraySort(TKey& keys[],TItem& items[],ASorter<TKey,TItem>* algorithm,bool accending_order=true)
  {
//--- prepare algorithm
   ArrayCopy(algorithm.keys,keys);
   ArrayCopy(algorithm.items,items);
//--- execute algorithm sorting
   algorithm.Sort();
//--- save sorted items
   ArrayCopy(keys,algorithm.keys);
   ArrayCopy(items,algorithm.items);
//--- keep sorting order
   if(!accending_order)
     {
      ArrayReverse(keys);
      ArrayReverse(items);
     }
//--- clear
   if(CheckPointer(algorithm)==POINTER_DYNAMIC)
      delete algorithm;
  }
//+------------------------------------------------------------------+
