//+------------------------------------------------------------------+
//|                                              ObjectStructure.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
#include "Element.mqh"
class ObjectStructure
  {
protected:
   Element*          m_elements[];
public:
                    ~ObjectStructure();
   void              Accept(Visitor*);
   void              Add(Element*);
   void              Remove(Element*);
  };


//+------------------------------------------------------------------+
//| destructor                                                       |
//+------------------------------------------------------------------+
ObjectStructure::~ObjectStructure(void)
  {
   int total=ArraySize(m_elements);
   for(int i=0; i<total; i++)
      if(CheckPointer(m_elements[i])==1)
         delete m_elements[i];
  }


//+------------------------------------------------------------------+
//| accept                                                           |
//+------------------------------------------------------------------+
void ObjectStructure::Accept(Visitor* visitor)
  {
   Print("object structure has accepted new visitor ",visitor);
   int total=ArraySize(m_elements);
   Print("object structure has ",total," elements");
   Print("object structure is requesting each element to accept the visitor");
   for(int i=0; i<total; i++)
      m_elements[i].Accept(visitor);
  }


//+------------------------------------------------------------------+
//| add                                                              |
//+------------------------------------------------------------------+
void ObjectStructure::Add(Element* element)
  {
   Print("element ",element," added to the object structure");
   int size=ArraySize(m_elements);
   ArrayResize(m_elements,size+1,size*B'10');
   m_elements[size]=element;
  }


//+------------------------------------------------------------------+
//| remove                                                           |
//+------------------------------------------------------------------+
void ObjectStructure::Remove(Element* element)
  {
   int total=ArraySize(m_elements);
   for(int i=0; i<total; i++)
     {
      if(m_elements[i]==element)
        {
         if(CheckPointer(m_elements[i])==1)
            delete element;
         ArrayRemove(m_elements,i,1);
         break;
        }
     }
  }


//+------------------------------------------------------------------+
