//+------------------------------------------------------------------+
//|                                             PatternOrganizer.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//| 23 design patterns                                               |
//+------------------------------------------------------------------+
//   design patterns: elements of reusable object-oriented software
//   gof > erich gamma, richard helm, ralph johnson, john vlissides 
//   published in 1994
//+------------------------------------------------------------------+
//| classification                                                   |
//+------------------------------------------------------------------+
//   purpose > creational > 5
//      abstract factory, builder, factory method, prototype, singleton
//   purpose > structural > 7
//      adapter, bridge, composite, decorator, facade, flyweight, proxy
//   purpose > behavioral > 11
//      chain of responsibility, command, interpreter, iterator, mediator
//      memento, observer, state, strategy, template method, visitor
//   scope > class > 3 > factory method, interpreter, template method
//   scope > object > 20 > all other
//+------------------------------------------------------------------+
//| relationships                                                    |
//+------------------------------------------------------------------+
//
//                       +-------------->|memento|      |proxy|
//                       |                   ^           |adapter|
//                  saving state             |            |bridge |
//                  of iteration          avoiding
//                       |               hysteresis
//    |builder|      |iterator|<---+         |        |   chain of   |
//        ^              ^         |     |command|    |responsibility|
//        |              |         |         |               |
//     creating     enumerating    |      composed        defining
//    composites      children     |       using         the chain
//        |              |         |         |               |
//        +---------|composite|<---|---------+---------------+
//        |              |         |                         |
//     adding            |     defining------------+      defining
// responsibilities      |    traversals           |      grammar
//   to objects          |                         |         |
//        |              +--------adding------>|visitor|     |
//        v              |      operations                   |
//   |decorator|      sharing       |                        |
//        ^          composites     +--------|interpreter|---+
//        |              |                         |
//        |              v             sharing     |
//  changing skin     |flyweight|<-----terminal----+
//    vs. guts               ^         symbols          |observer|
//        |       sharing    |                              |
//        |     strategies---+---sharing                    |
//        v          |           states                  complex
//   |strategy|------+             |     |mediator|<----dependency
//        ^                     |state|                 management
//        |
//     sharing
//   algorithm's----------|template method|----often uses---+
//      steps                                               |
//                                                          |
//   |prototype|<--+                                        |
//                 |                                        v
//         configure factory          implement---->|factory method|
//            dynamically               using
//                 |                      |
//         |abstract factory|---+---------+
//                              |
//                           single
//   |singleton|<-----------instance------------|facade|
//
//+------------------------------------------------------------------+
//| code refactoring                                                 |
//+------------------------------------------------------------------+
//   create objects < explicitly > create indirectly
//      abstract factory, factory method, prototype
//   dependence > specific operations > avoid > hard-coded requests
//      chain of responsibility, command
//   dependence > hardware and software > limit 
//      abstract factory, bridge
//   dependence > object representations/implementations
//      hide from clients > keep changes from cascading
//      abstract factory, bridge, memento, proxy
//   algorithmic dependencies > isolate > algorithms that may change
//      builder, iterator, strategy, template method, visitor
//   tight coupling > decouple < abstract coupling and layering
//      abstract factory, bridge, chain of responsibility,
//      command, facade, mediator, observer
//   extending functionality < subclassing 
//      composition/delegation > combine behavior
//      bridge, chain of responsibility, composite, decorator,
//      observer, strategy
//   inability to alter classes conveniently > adapter, decorator, visitor
//+------------------------------------------------------------------+
//| creational > abstract factory                                    |
//+------------------------------------------------------------------+
//   interface > families of related/dependent objects
//    without specifying concrete classes
//   variable aspect > families of product objects
//
//            | AbstractFactory|<-----------------------------------------|Client|
//            |----------------|                                              |
//            |CreateProductA()|                                              |
//            |CreateProductA()|                    |AbstractProductA|<-------+
//                     ^                                    ^                 |
//                     |                                    |                 |
//         +-----------+----------+                   +-----+-----+           |
//         |                      |                   |           |           |
//|ConcreteFactory1|- +  |ConcreteFactory2|- + ->|ProductA2| |ProductA1|<- +  |
//|----------------|  |  |----------------|  |                             |  |
//|CreateProductA()|     |CreateProductA()|                                   |
//|CreateProductB()|  |  |CreateProductB()|  |                             |  |
//                                                  |AbstractProductB|<----+--+
//                    |                      |              ^              |
//                                                          |
//                    |                      |        +-----+-----+        |
//                                                    |           |
//                    |                      + ->|ProductB2| |ProductB1|<- +
//                                                                         |
//                    +  - - - - - - - - - - - - - - - - - - - - - - - - - +
//
//+------------------------------------------------------------------+
//| creational > builder                                             |
//+------------------------------------------------------------------+
//   for a complex object > separate construction from representation
//   same construction process can create different representations
//   variable aspect > the way a composite object gets created
//
//                                  builder
//  |           Director          |o--------->|  Builder  |
//  |-----------------------------|           |-----------|
//  |Construct()                  |           |BuildPart()|
//  | for all objects in structure|                 ^
//  |  builder.BuildPart()        |                 |
//                                          |ConcreteBuilder|- - ->|Product|
//                                          |---------------|
//                                          |BuildPart()    |
//                                          |GetResult()    |
//
//+------------------------------------------------------------------+
//| creational > factory method                                      |
//+------------------------------------------------------------------+
//   interface for creating an object > defers instantiation to subclasses
//   subclasses decide which class to instantiate
//   variable aspect > subclass of object that is instantiated
//
//                                 |         Creator        |
//                                 |------------------------|
//                                 |FactoryMethod()         |
//                                 |AnOperation()           |
//                                 | ...                    |
//                                 | product=FactoryMethod()|
//        |Product|                | ...                    |
//            ^                                ^
//            |                                |
//    |ConcreteProduct|<- - - - -|      ConcreteCreator      |
//                               |---------------------------|
//                               |FactoryMethod()            |
//                               | return new ConcreteProduct|
//
//+------------------------------------------------------------------+
//| creational > prototype                                           |
//+------------------------------------------------------------------+
//   create objects > by copying a prototype
//   variable aspect > class of object that is instantiated
//
//                         prototype
//  |       Client       |------------>|Prototype|
//  |--------------------|             |---------|
//  |Operation()         |             |Clone()  |
//  | p=prototype.Clone()|                  ^
//                                          |
//                              +-----------+------------+
//                              |                        |
//                   | ConcretePrototype1 |   | ConcretePrototype2 |
//                   |--------------------|   |--------------------|
//                   |Clone()             |   |Clone()             |
//                   | return copy of self|   | return copy of self|
//
//+------------------------------------------------------------------+
//| creational > singleton                                           |
//+------------------------------------------------------------------+
//   ensure > one instance of a class with a global point of access
//   variable aspect > the sole instance of a class
//
//                       |       Singleton      |
//                       |----------------------|
//                       |static Instance()     |
//                       | return uniqueInstance|
//                       |SingletonOperation()  |
//                       |GetSingletonData()    |
//                       |----------------------|
//                       |static uniqueInstance |
//                       |singletonData         |
//
//+------------------------------------------------------------------+
//| interface for patterns                                           |
//+------------------------------------------------------------------+
interface ClientExample //pattern client
  {
   string Output(void); //returns header
   void Run(void); //execute the pattern client
  };
//+------------------------------------------------------------------+
//| interface for patterns                                           |
//+------------------------------------------------------------------+
void Run(ClientExample* client) //launches a pattern
  {
   printf("---\n%s",client.Output()); //print pattern header
   client.Run(); //execute client collaborations
   delete client; //exit
  }
//+------------------------------------------------------------------+
//| include > patterns                                               |
//+------------------------------------------------------------------+
namespace Creational
{
#include "Creational\AbstractFactory.mqh"
#include "Creational\Builder.mqh"
#include "Creational\FactoryMethod.mqh"
#include "Creational\Prototype.mqh"
#include "Creational\Singleton.mqh"
}
//+------------------------------------------------------------------+
