/**/
#include "FloatingPoint.mqh"
/****************************************************************
Example of FloatingPoint class usage.
/****************************************************************/
void OnStart()
  {
   FloatingPoint<double>fp;
   double a=1.15,b=1.14999999999;
   for(int i=15; i>5; i--)
     {
      fp.Precision(i);
      int compare=fp.Compare(a,b);
      string res=(compare==0)?"=":(compare==1)?">":"<";
      PrintFormat("%g %s %g at %d digit precision",a,res,b,i);
     }
  }
/****************************************************************
Output:
/**
   you do not expect this:
      1.15 > 1.15 at 15 digit precision
      1.15 > 1.15 at 14 digit precision
      1.15 > 1.15 at 13 digit precision
      1.15 > 1.15 at 12 digit precision
      1.15 > 1.15 at 11 digit precision
   
   you expect this:
      1.15 = 1.15 at 10 digit precision
      1.15 = 1.15 at 9 digit precision
      1.15 = 1.15 at 8 digit precision
      1.15 = 1.15 at 7 digit precision
      1.15 = 1.15 at 6 digit precision
/**/
