/****************************************************************
Binary Flags
Minimize bool parameters in a function signature.
You can use binary flags to minimize bool parameters in a function signature.
For example, MQL int size is 32 bits, so you can pack 32 1/0 parameters in a single int flag variable.
BinFlags can be initialized with any integer data type:char, bool, short, int, color, long, datetime.
Your maximum flag length will vary: 1 byte = 8 bits, 2 bytes = 16 bits, etc.
A flag represents a number which has only one '1' bit in any position.
Such numbers are 1, 2, 4, 8, 16, 32, etc. You get it.
Large numbers of this kind look better in hex: 0x1, 0x2, 0x4, 0x8, 0x10, 0x20, etc.
This class works with flags, which follow the rule.
BinFlags must be initialized first. You can overwrite later the internal flags with Write.
You can check, set, reset any number of flags.
Multiple flags should be separated by '|'.
/****************************************************************/
template<typename T>class BinFlags
  {
public:
                     BinFlags():mflags(NULL) {} BinFlags(T flags):mflags(flags) {}
   void              Write(T flags) {mflags=flags;}
   T                 Read() {return mflags;}
   bool              Chk(T flags) {return (mflags&(flags))==flags;}
   void              Set(T flags) {mflags|=(flags);}
   void              Rst(T flags) {mflags&=~(flags);}
   string            Format();
protected:
   int               Bits() {int i=0; for(i; i<sizeof(T)*8; i+=4) {if(mflags<(int)pow(2,i)) {break;}} return (i)?i:1;}
   T                 mflags;
  };
/****************************************************************/
template<typename T>string BinFlags::Format()
  {
   string format="BinFlags:";
   int bits=Bits();
   for(int i=bits; i>0; i--)
     {
      string prefix=(i%4==0&&i!=bits)?" ":"";
      format+=((mflags&(1<<(i-1)))!=0)?prefix+"1":prefix+"0";
     }
   return format;
  }
/**/
