//+------------------------------------------------+
//|                                NLD_Medians.mq5 |
//|                          http://www.nelodi.com |
//|                  Copyright (c) 2019 NELODI.com |
//+------------------------------------------------+

void MyMedCalc(const double rv,double &sh,double &sl)
  {
   if(sh<rv) sh=rv;
   if(sl>rv) sl=rv; else if(sl<0) sl=rv;
  }
//+------------------------------------------------------------------+
void MyMedCalc2(const double rv,
              int &sn,double &sv,double &sh,double &sl,
              int &xn,double &xv,double &xh,double &xl)
  {
   sn++; xn++; sv+=rv;  xv+=rv;
   if(sh<rv) sh=rv; if(sl<0) sl=rv; else if(sl>rv) sl=rv;
   if(xh<rv) xh=rv; if(xl<0) xl=rv; else if(xl>rv) xl=rv;
  }
//+------------------------------------------------------------------+
double MyStdDev(int position,const double &price[],const double MAprice,const int lastPos,double EBands)
  {
   double StdDev_dTmp=0.0;
   if(position>lastPos) {EBands-=position-lastPos; position=lastPos;}
   if(EBands<1) EBands=1;
   if(position<EBands) return(StdDev_dTmp);
   for(int i=0;i<EBands;i++) StdDev_dTmp+=MathPow(price[position-i]-MAprice,2);
   StdDev_dTmp=MathSqrt(StdDev_dTmp/EBands);
   return(StdDev_dTmp);
  }
//+------------------------------------------------------------------+
double MyMid(double hv,double hc,double lv,double lc,const double p)
  {
   if(hv>=0 && lv>=0)
     {
      if(hv<lv)
        { // swap hi/lo
         double t;
         t=hv;hv=lv;lv=t;
         t=hc;hc=lc;lc=t;
        }
      if(p>=hv && p>lv) return(hc);
      else if(p<=lv && p<hv) return(lc);
      else if(hv==lv) return((hc+lc)/2);
      else
        {
         double xl=(hv-p)/(hv-lv),xh=1.0-xl;
         return(hc*xh+lc*xl);
        }
     }
   return(0);
  }
//+------------------------------------------------------------------+
void MyFwdBckMedians4(const int position,
                      const int period,
                      const double &price[],
                      const double &volume[],
                      double &res_fwd,
                      double &res_bck)
  {
   int r=period,pos=position;
   int i,j;
   double p;
   if(r>pos+1) r=pos+1;
   
   double vol_fwd=0, vol_bck=0;
   for(i=r-1,j=0,p=1;i>0;p=((p*i)+r)/i,i--,j++)
     {
     vol_fwd+=volume[pos-i]/r*p;
     vol_bck+=volume[pos-j]/r*p; 
     }
   vol_fwd=(vol_fwd+volume[pos-i]/r*p)/r;
   vol_bck=(vol_bck+volume[pos-j]/r*p)/r;

   res_fwd=0; res_bck=0;
   for(i=r-1,j=0,p=1;i>0;p=((p*i)+r)/i,i--,j++)
     {
     res_fwd+=(price[pos-i]*volume[pos-i])/r*p;
     res_bck+=(price[pos-j]*volume[pos-j])/r*p; 
     }
   res_fwd=(res_fwd+(price[pos-i]*volume[pos-i])/r*p)/r;
   res_bck=(res_bck+(price[pos-j]*volume[pos-j])/r*p)/r;
   
   res_fwd/=vol_fwd;
   res_bck/=vol_bck;
  }

void MyFwdBckMedians3(const int position,
                      const int period,
                      const double &price[],
                      double &res_fwd,
                      double &res_bck)
  {
   int r=period,pos=position;
   int i,j;
   double p;
   if(r>pos+1) r=pos+1;   
   res_fwd=0; res_bck=0;   
   for(i=r-1,j=0,p=1;i>0;p=((p*i)+r)/i,i--,j++)
     {
     res_fwd+=price[pos-i]/r*p;
     res_bck+=price[pos-j]/r*p;            
     }
   res_fwd=(res_fwd+price[pos-i]/r*p)/r;
   res_bck=(res_bck+price[pos-j]/r*p)/r;
  }

bool MyMedians(const int position,
               const int period,
               const double &price[],
               double &res_fwd,
               double &res_bck,
               double &res_boil,
               const int lastPos,
               const double fwdPrice=-1,
               const double bckPrice=-1,
               const double boilPrice=-1)
  {
   res_fwd=-1;
   res_bck=-1;
   res_boil=-1;
   int r=period,pos=position;
   if(r>pos+1) r=pos+1;
   if(pos>lastPos && fwdPrice<0) { r-=pos-lastPos; pos=lastPos; }
   if(r>0 && pos<lastPos+r)
     {
      res_fwd=0;
      res_bck=0;
      res_boil=0;
      if(pos>lastPos)
        {
         int i=r-1,x=pos-i,y=pos;
         double pfw,pbc,pbo,p=1;
         double pl_fw=(fwdPrice>0?fwdPrice:price[lastPos]);
         double pl_bc=(bckPrice>0?bckPrice:price[lastPos]);
         double pl_bo=(boilPrice>0?boilPrice:price[lastPos]);
         while(i>0)
           {
            if(x>lastPos) {pfw=pl_fw;pbo=pl_bo;} else {pfw=price[x];pbo=pfw;} x++;
            if(y>lastPos) {pbc=pl_bc;} else {pbc=price[y];}; y--;
            res_boil+=pbo;
            res_fwd+=pfw/r*p;
            res_bck+=pbc/r*p;
            p*=i;p+=r;p/=i;i--;
           }
         if(x>lastPos) {pfw=pl_fw;pbo=pl_bo;} else {pfw=price[x];pbo=pfw;} x++;
         if(y>lastPos) {pbc=pl_bc;} else {pbc=price[y];}; y--;
         res_boil+=pbo; res_boil/=r;
         res_fwd+=pfw/r*p; res_fwd/=r;
         res_bck+=pbc/r*p; res_bck/=r;
        }
      else
        {
         int i=r-1,j=0;
         double p=1;
         while(i>0)
           {
            res_boil+=price[pos-i];
            res_fwd+=price[pos-i]/r*p;
            res_bck+=price[pos-j]/r*p;
            p*=i;p+=r;p/=i;i--;j++;
           }
         res_boil+=price[pos-i]; res_boil/=r;
         res_fwd+=price[pos-i]/r*p; res_fwd/=r;
         res_bck+=price[pos-j]/r*p; res_bck/=r;
        }
      return(position>lastPos);
     }
   return(false);
  }
//+------------------------------------------------------------------+
bool MyFwdBckMedians(const int position,
                     const int period,
                     const double &price[],
                     double &res_fwd,
                     double &res_bck,
                     const int lastPos,
                     const double fwdPrice=-1,
                     const double bckPrice=-1)
  {
   res_fwd=-1;
   res_bck=-1;
   int r=period,pos=position;
   if(r>pos+1) r=pos+1;
   if(pos>lastPos && fwdPrice<0) { r-=pos-lastPos; pos=lastPos; }
   if(r>0 && pos<lastPos+r)
     {
      res_fwd=0;
      res_bck=0;
      if(pos>lastPos)
        {
         int i=r-1,x=pos-i,y=pos;
         double pfw,pbc,p=1;
         double pl_fw=(fwdPrice>0?fwdPrice:price[lastPos]);
         double pl_bc=(bckPrice>0?bckPrice:price[lastPos]);
         while(i>0)
           {
            if(x>lastPos) {pfw=pl_fw;} else {pfw=price[x];} x++;
            if(y>lastPos) {pbc=pl_bc;} else {pbc=price[y];}; y--;
            res_fwd+=pfw/r*p;
            res_bck+=pbc/r*p;
            p*=i;p+=r;p/=i;i--;
           }
         if(x>lastPos) {pfw=pl_fw;} else {pfw=price[x];} x++;
         if(y>lastPos) {pbc=pl_bc;} else {pbc=price[y];}; y--;
         res_fwd+=pfw/r*p; res_fwd/=r;
         res_bck+=pbc/r*p; res_bck/=r;
        }
      else
        {
         int i=r-1,j=0;
         double p=1;
         while(i>0)
           {
            res_fwd+=price[pos-i]/r*p;
            res_bck+=price[pos-j]/r*p;
            p*=i;p+=r;p/=i;i--;j++;
           }
         res_fwd+=price[pos-i]/r*p; res_fwd/=r;
         res_bck+=price[pos-j]/r*p; res_bck/=r;
        }
      return(position>lastPos);
     }
   return(false);
  }
//+------------------------------------------------------------------+
bool MyFwdMedian(const int position,
                 const int period,
                 const double &price[],
                 double &res_fwd,
                 const int lastPos,
                 const double fwdPrice=-1)
  {
   res_fwd=-1;
   int r=period,pos=position;
   if(r>pos+1) r=pos+1;
   if(pos>lastPos && fwdPrice<0) { r-=pos-lastPos; pos=lastPos; }
   if(r>0 && pos<lastPos+r)
     {
      res_fwd=0;
      if(pos>lastPos)
        {
         int i=r-1,x=pos-i,y=pos;
         double pfw,p=1;
         double pl_fw=(fwdPrice>0?fwdPrice:price[lastPos]);
         while(i>0)
           {
            if(x>lastPos) {pfw=pl_fw;} else {pfw=price[x];} x++;
            res_fwd+=pfw/r*p;
            p*=i;p+=r;p/=i;i--;
           }
         if(x>lastPos) {pfw=pl_fw;} else {pfw=price[x];} x++;
         res_fwd+=pfw/r*p; res_fwd/=r;
        }
      else
        {
         int i=r-1,j=0;
         double p=1;
         while(i>0)
           {
            res_fwd+=price[pos-i]/r*p;
            p*=i;p+=r;p/=i;i--;j++;
           }
         res_fwd+=price[pos-i]/r*p; res_fwd/=r;
        }
      return(position>lastPos);
     }
   return(false);
  }
//+------------------------------------------------------------------+
bool MyBckMedian(const int position,
                 const int period,
                 const double &price[],
                 double &res_bck,
                 const int lastPos,
                 const double bckPrice=-1)
  {
   res_bck=-1;
   int r=period,pos=position;
   if(r>pos+1) r=pos+1;
   if(pos>lastPos && bckPrice<0) { r-=pos-lastPos; pos=lastPos; }
   if(r>0 && pos<lastPos+r)
     {
      res_bck=0;
      if(pos>lastPos)
        {
         int i=r-1,x=pos-i,y=pos;
         double pbc,p=1;
         double pl_bc=(bckPrice>0?bckPrice:price[lastPos]);
         while(i>0)
           {
            if(y>lastPos) {pbc=pl_bc;} else {pbc=price[y];}; y--;
            res_bck+=pbc/r*p;
            p*=i;p+=r;p/=i;i--;
           }
         if(y>lastPos) {pbc=pl_bc;} else {pbc=price[y];}; y--;
         res_bck+=pbc/r*p; res_bck/=r;
        }
      else
        {
         int i=r-1,j=0;
         double p=1;
         while(i>0)
           {
            res_bck+=price[pos-j]/r*p;
            p*=i;p+=r;p/=i;i--;j++;
           }
         res_bck+=price[pos-j]/r*p; res_bck/=r;
        }
      return(position>lastPos);
     }
   return(false);
  }
//+------------------------------------------------------------------+
bool MyBoilMedian(const int position,
                  int period,
                  const double &price[],
                  double &res_boil,
                  const int lastPos,
                  const double boilPrice=-1)
  {
   res_boil=-1;
   int r=period,pos=position;
   if(r>pos+1) r=pos+1;
   if(pos>lastPos && boilPrice<0) { r-=pos-lastPos; pos=lastPos; }
   if(r>0 && pos<lastPos+r)
     {
      res_boil=0;
      if(pos>lastPos)
        {
         int i=r-1,x=pos-i,y=pos;
         double pbo,p=1;
         double pl_bo=(boilPrice>0?boilPrice:price[lastPos]);
         while(i>0)
           {
            if(x>lastPos) {pbo=pl_bo;} else {pbo=price[x];}; x++;
            res_boil+=pbo;
            p*=i;p+=r;p/=i;i--;
           }
         if(x>lastPos) {pbo=pl_bo;} else {pbo=price[x];} x++;
         res_boil+=pbo; res_boil/=r;
        }
      else
        {
         int i=r-1,j=0;
         double p=1;
         while(i>0)
           {
            res_boil+=price[pos-i];
            p*=i;p+=r;p/=i;i--;j++;
           }
         res_boil+=price[pos-i]; res_boil/=r;
        }
      return(position>lastPos);
     }
   return(false);
  }
//+------------------------------------------------------------------+

double ExtMedPerc,ExtMedC,ExtMedP,ExtMedF,ExtMedShift,ExtMedStart;
//+------------------------------------------------------------------+
void MyMedians2Init(int iCalcC,int iCalcP,int iCalcF,int iRange,int iShift,int iStart)
  {
   ExtMedPerc=(double)iRange/100.0; if(ExtMedPerc>1) ExtMedPerc=1; if(ExtMedPerc<0) ExtMedPerc=0;
   ExtMedC=(double)iCalcC/100.0; if(ExtMedC<0) ExtMedC=0;
   ExtMedP=(double)iCalcP/100.0; if(ExtMedP<0) ExtMedP=0;
   ExtMedF=(double)iCalcF/100.0; if(ExtMedF<0) ExtMedF=0;
   ExtMedShift=(double)iShift/100.0; if(ExtMedShift<0) ExtMedShift=0;
   ExtMedStart=iStart; if(ExtMedStart<0) ExtMedStart=0;
  }
//+------------------------------------------------------------------+
void MyMedians2(int position,
                const int period,
                const double &price[],
                double &res_fwd,
                double &res_bck,
                double &res_boil,
                int lastPos)
  {
   if(lastPos>(int)MathRound(position-ExtMedStart))
      lastPos=(int)MathRound(position-ExtMedStart);
   if(lastPos<0) lastPos=0;

   position=(int)MathRound(position-period*ExtMedShift);

   if(position<=lastPos) // Data
      MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos);
   else if(position-lastPos>=ExtMedPerc*period) // Out of Range
     { res_fwd=-1;res_bck=-1;res_boil=-1; }
   else if(ExtMedF==0 && ExtMedC==0 && ExtMedP>0) // Past
     { MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos); }
   else if(ExtMedF==0 && ExtMedP==0) // Present & Parabol
     {
      if(ExtMedC==0)
        {
         res_boil=-1;
         if(MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0))
            MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos,res_bck,res_fwd,(res_fwd+res_bck)/2);
        }
      else if(ExtMedC<1)
        {
         res_boil=-1;
         if(MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0))
            MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos,res_fwd,res_bck,(res_fwd+res_bck)/2);
        }
      else MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos,0);
     }
   else // Future Mix
     {
      double avgF=(position-lastPos)*ExtMedF;
      double tmp_fwd=0,tmp_bck=0,tmp_boil=0,tmp_cnt=0;

      if(ExtMedF>0) if(MyMedians((int)MathRound(position+avgF),period,price,res_fwd,res_bck,res_boil,lastPos))
        { tmp_cnt++; tmp_fwd+=res_fwd; tmp_bck+=res_bck; tmp_boil+=res_boil; }

      if(ExtMedP>0) if(MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos))
        { tmp_cnt+=ExtMedP; tmp_fwd+=res_fwd*ExtMedP; tmp_bck+=res_bck*ExtMedP; tmp_boil+=res_boil*ExtMedP; }

      if(ExtMedC>0) MyMedians(position,period,price,res_fwd,res_bck,res_boil,lastPos,0);
        { tmp_cnt+=ExtMedC; tmp_fwd+=res_fwd*ExtMedC; tmp_bck+=res_bck*ExtMedC; tmp_boil+=res_boil*ExtMedC; }

      if(tmp_cnt>0)
        {
         res_fwd=tmp_fwd/tmp_cnt;
         res_bck=tmp_bck/tmp_cnt;
         res_boil=tmp_boil/tmp_cnt;
        }
      else
        {
         res_fwd=-1;
         res_bck=-1;
         res_boil=-1;
        }
     }
  }
//+------------------------------------------------------------------+
void MyFwdBckMedians2(int position,
                      const int period,
                      const double &price[],
                      double &res_fwd,
                      double &res_bck,
                      int lastPos)
  {
   if(lastPos>(int)MathRound(position-ExtMedStart*period))
      lastPos=(int)MathRound(position-ExtMedStart*period);
   if(lastPos<0) lastPos=0;

   if(position<=lastPos) // Data
     {
      MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos);
      return;
     }

   position=(int)MathRound(position-period*ExtMedShift);

   if(position<=lastPos) // Data
      MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos);
   else if(position-lastPos>=ExtMedPerc*period) // Out of Range
     { res_fwd=-1;res_bck=-1; }
   else if(ExtMedF==0 && ExtMedC==0 && ExtMedP>0) // Past
     { MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos); }
   else if(ExtMedF==0 && ExtMedP==0) // Present & Parabol
     {
      if(ExtMedC==0)
        {
         if(MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0))
            MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,res_bck,res_fwd);
        }
      else if(ExtMedC<1)
        {
         if(MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0))
            MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,res_fwd,res_bck);
        }
      else
         MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0);
     }
   else // Future Mix
     {
      double avgF=(position-lastPos)*ExtMedF;
      double tmp_fwd=0,tmp_bck=0,tmp_cnt=0;

      if(ExtMedF>0) if(MyFwdBckMedians((int)MathRound(position+avgF),period,price,res_fwd,res_bck,lastPos))
        { tmp_cnt++; tmp_fwd+=res_fwd; tmp_bck+=res_bck; }

      if(ExtMedP>0) if(MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos))
        { tmp_cnt+=ExtMedP; tmp_fwd+=res_fwd*ExtMedP; tmp_bck+=res_bck*ExtMedP; }

      if(ExtMedC>0) MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0);
        { tmp_cnt+=ExtMedC; tmp_fwd+=res_fwd*ExtMedC; tmp_bck+=res_bck*ExtMedC; }

      if(tmp_cnt>0)
        {
         res_fwd=tmp_fwd/tmp_cnt;
         res_bck=tmp_bck/tmp_cnt;
        }
      else
        {
         res_fwd=-1;
         res_bck=-1;
        }
     }
  }
//+------------------------------------------------------------------+
void MyFwdMedian2(int position,
                  const int period,
                  const double &price[],
                  double &res_fwd,
                  int lastPos)
  {
   if(lastPos>(int)MathRound(position-ExtMedStart*period))
      lastPos=(int)MathRound(position-ExtMedStart*period);
   if(lastPos<0) lastPos=0;

   if(position<=lastPos) // Data
     {
      MyFwdMedian(position,period,price,res_fwd,lastPos);
      return;
     }

   position=(int)MathRound(position-period*ExtMedShift);

   if(position<=lastPos) // Data
      MyFwdMedian(position,period,price,res_fwd,lastPos);
   else if(position-lastPos>=ExtMedPerc*period) // Out of Range
     { res_fwd=-1; }
   else if(ExtMedF==0 && ExtMedC==0 && ExtMedP>0) // Past
     { MyFwdMedian(position,period,price,res_fwd,lastPos); }
   else if(ExtMedF==0 && ExtMedP==0) // Present & Parabol
     {
      if(ExtMedC==0)
        {
         if(MyBckMedian(position,period,price,res_fwd,lastPos,0))
            MyFwdMedian(position,period,price,res_fwd,lastPos,res_fwd);
        }
      else if(ExtMedC<1)
        {
         if(MyFwdMedian(position,period,price,res_fwd,lastPos,0))
            MyFwdMedian(position,period,price,res_fwd,lastPos,res_fwd);
        }
      else
         MyFwdMedian(position,period,price,res_fwd,lastPos,0);
     }
   else // Future Mix
     {
      double avgF=(position-lastPos)*ExtMedF;
      double tmp_fwd=0,tmp_cnt=0;

      if(ExtMedF>0) if(MyFwdMedian((int)MathRound(position+avgF),period,price,res_fwd,lastPos))
        { tmp_cnt++; tmp_fwd+=res_fwd; }

      if(ExtMedP>0) if(MyFwdMedian(position,period,price,res_fwd,lastPos))
        { tmp_cnt+=ExtMedP; tmp_fwd+=res_fwd*ExtMedP; }

      if(ExtMedC>0) MyFwdMedian(position,period,price,res_fwd,lastPos,0);
        { tmp_cnt+=ExtMedC; tmp_fwd+=res_fwd*ExtMedC; }

      if(tmp_cnt>0)
        {
         res_fwd=tmp_fwd/tmp_cnt;
        }
      else
        {
         res_fwd=-1;
        }
     }
  }
//+------------------------------------------------------------------+
void MyBckMedian2(int position,
                  const int period,
                  const double &price[],
                  double &res_bck,
                  int lastPos)
  {
   if(lastPos>(int)MathRound(position-ExtMedStart*period))
      lastPos=(int)MathRound(position-ExtMedStart*period);
   if(lastPos<0) lastPos=0;

   if(position<=lastPos) // Data
     {
      MyBckMedian(position,period,price,res_bck,lastPos);
      return;
     }

   position=(int)MathRound(position-period*ExtMedShift);

   if(position<=lastPos) // Data
      MyBckMedian(position,period,price,res_bck,lastPos);
   else if(position-lastPos>=ExtMedPerc*period) // Out of Range
     { res_bck=-1; }
   else if(ExtMedF==0 && ExtMedC==0 && ExtMedP>0) // Past
     { MyBckMedian(position,period,price,res_bck,lastPos); }
   else if(ExtMedF==0 && ExtMedP==0) // Present & Parabol
     {
      if(ExtMedC==0)
        {
         if(MyFwdMedian(position,period,price,res_bck,lastPos,0))
            MyBckMedian(position,period,price,res_bck,lastPos,res_bck);
        }
      else if(ExtMedC<1)
        {
         if(MyBckMedian(position,period,price,res_bck,lastPos,0))
            MyBckMedian(position,period,price,res_bck,lastPos,res_bck);
        }
      else
         MyBckMedian(position,period,price,res_bck,lastPos,0);
     }
   else // Future Mix
     {
      double avgF=(position-lastPos)*ExtMedF;
      double tmp_bck=0,tmp_cnt=0;

      if(ExtMedF>0) if(MyBckMedian((int)MathRound(position+avgF),period,price,res_bck,lastPos))
        { tmp_cnt++; tmp_bck+=res_bck; }

      if(ExtMedP>0) if(MyBckMedian(position,period,price,res_bck,lastPos))
        { tmp_cnt+=ExtMedP; tmp_bck+=res_bck*ExtMedP; }

      if(ExtMedC>0) MyBckMedian(position,period,price,res_bck,lastPos,0);
        { tmp_cnt+=ExtMedC; tmp_bck+=res_bck*ExtMedC; }

      if(tmp_cnt>0)
        {
         res_bck=tmp_bck/tmp_cnt;
        }
      else
        {
         res_bck=-1;
        }
     }
  }
//+------------------------------------------------------------------+
void MyBoilMedian2(int position,
                   const int period,
                   const double &price[],
                   double &res_boil,
                   int lastPos)
  {
   if(lastPos>(int)MathRound(position-ExtMedStart*period))
      lastPos=(int)MathRound(position-ExtMedStart*period);
   if(lastPos<0) lastPos=0;

   if(position<=lastPos) // Data
     {
      MyBoilMedian(position,period,price,res_boil,lastPos);
      return;
     }

   position=(int)MathRound(position-period*ExtMedShift);

   if(position<=lastPos) // Data
      MyBoilMedian(position,period,price,res_boil,lastPos);
   else if(position-lastPos>=ExtMedPerc*period) // Out of Range
     { res_boil=-1; }
   else if(ExtMedF==0 && ExtMedC==0 && ExtMedP>0) // Past
     { MyBoilMedian(position,period,price,res_boil,lastPos); }
   else if(ExtMedF==0 && ExtMedP==0) // Parabol & Present
     {
      if(ExtMedC<1)
        {
         res_boil=-1;
         double res_fwd=-1,res_bck=-1;
         if(MyFwdBckMedians(position,period,price,res_fwd,res_bck,lastPos,0))
            MyBoilMedian(position,period,price,res_boil,lastPos,(res_fwd+res_bck)/2);
        }
      else
         MyBoilMedian(position,period,price,res_boil,lastPos,0);
     }
   else
     {
      double avgF=(position-lastPos)*ExtMedF;
      double tmp_boil=0,tmp_cnt=0;

      if(ExtMedF>0) if(MyBoilMedian((int)MathRound(position+avgF),period,price,res_boil,lastPos))
        { tmp_cnt++; tmp_boil+=res_boil; }

      if(ExtMedP>0) if(MyBoilMedian(position,period,price,res_boil,lastPos))
        { tmp_cnt+=ExtMedP; tmp_boil+=res_boil*ExtMedP; }

      if(ExtMedC>0) MyBoilMedian(position,period,price,res_boil,lastPos,0);
        { tmp_cnt+=ExtMedC; tmp_boil+=res_boil*ExtMedC; }

      if(tmp_cnt>0)
        {
         res_boil=tmp_boil/tmp_cnt;
        }
      else
        {
         res_boil=-1;
        }
     }
  }
//+------------------------------------------------------------------+