//+-----------------------------------------------+
//|                                NLD_Colors.mq5 |
//|                         http://www.nelodi.com |
//|                 Copyright (c) 2019 NELODI.com |
//+-----------------------------------------------+

#define NO_COLOR 0

void MyColorsPrepare(const int i,const int colors)
  {
   switch(colors)
     {
      case 6:
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'0,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'0,250,150');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'0,250,100');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'0,250,50');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'0,200,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'0,150,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'250,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'150,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'200,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'250,0,50');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'250,0,100');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'250,0,150');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'250,0,250');
         break;
      case 5:
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'150,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'50,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'90,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'130,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'170,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'210,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'250,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'250,210,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'250,170,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'250,130,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'250,90,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'250,50,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'250,150,250');
         break;
      case 4:
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'0,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'0,250,50');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'0,250,100');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'0,250,150');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'0,250,200');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'0,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'250,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'250,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'250,200,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'250,150,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'250,100,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'250,50,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'250,0,0');
         break;
      case 3:
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'0,250,250');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'0,250,200');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'0,250,150');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'0,250,100');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'0,200,50');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'0,175,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'150,150,150');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'175,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'200,0,50');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'250,0,100');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'250,0,150');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'250,0,200');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'250,0,250');
         break;
      case 2:
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'0,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'40,230,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'60,210,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'80,190,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'100,180,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'120,160,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'140,140,140');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'160,120,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'180,80,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'190,50,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'210,20,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'230,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'250,0,0');
         break;
      case 1:
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'0,250,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'0,210,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'0,170,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'0,130,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'0,90,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'0,50,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'40,40,40');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'50,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'90,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'130,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'170,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'210,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'250,0,0');
         break;
      default: // case 0
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,1,C'0,150,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,2,C'0,125,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,3,C'0,100,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,4,C'0,75,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,5,C'0,50,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,6,C'0,25,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,7,C'20,20,20');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,8,C'25,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,9,C'50,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,10,C'75,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,11,C'100,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,12,C'125,0,0');
         PlotIndexSetInteger(i,PLOT_LINE_COLOR,13,C'150,0,0');
         break;
     }
   PlotIndexSetInteger(i,PLOT_LINE_COLOR,14,clrNONE);
   PlotIndexSetInteger(i,PLOT_LINE_COLOR,0,clrNONE);
  }
//+------------------------------------------------------------------+
void MyDir(const double n,
           const double p,
           const double o,
           double &d)
  {
   double old=d; d=0;
   if(n>p) d++; else if(n<p) d--;
   if(n>o) d++; else if(n<o) d--;
   if(p>o) d++; else if(p<o) d--;
   if(n>p && p>o && n-p>=p-o) d++; else if(n<p && p<o && n-p<=p-o) d--;
   if(n>p && p>o && old>0) d++; else if(n<p && p<o && old<0) d--;
  }
//+------------------------------------------------------------------+
void MyDirP(const double n,
            const double p,
            const double o,
            double &d)
  {
   if(n>=0 && p>=0 && o>=0)
      MyDir(n,p,o,d);
   else
      d=0;
  }
//+------------------------------------------------------------------+
void MyDirX(const int n,
            const int p,
            const int o,
            double &d)
  {
   double old=d; d=0;
   if(n>p) d++; else if(n<p) d--;
   if(n>o) d++; else if(n<o) d--;
   if(p>o) d++; else if(p<o) d--;
   if(n>p && p>o && n-p>=p-o) d++; else if(n<p && p<o && n-p<=p-o) d--;
   if(n>p && p>o && old>0) d++; else if(n<p && p<o && old<0) d--;
  }
//+------------------------------------------------------------------+
double MySetColor(const double d)
  {
   if(d>=0.5)
     {
      if(d>=5) return(1);
      else if(d>=4.5) return(2);
      else if(d>=3.5) return(3);
      else if(d>=2.5) return(4);
      else if(d>=1.5) return(5);
      else return(6);
     }
   else if(d<=-0.5)
     {
      if(d<=-5) return(13);
      else if(d<=-4.5) return(12);
      else if(d<=-3.5) return(11);
      else if(d<=-2.5) return(10);
      else if(d<=-1.5) return(9);
      else return(8);
     }
   else
      return(7);
  }
//+------------------------------------------------------------------+
double MyGetColor(const double c)
  {
   switch((int)MathRound(c))
     {
      case 1: return(5);
      case 2: return(4.5);
      case 3: return(3.5);
      case 4: return(2.5);
      case 5: return(1.5);
      case 6: return(0.5);
      case 7: return(0);
      case 8: return(-0.5);
      case 9: return(-1.5);
      case 10: return(-2.5);
      case 11: return(-3.5);
      case 12: return(-4.5);
      case 13: return(-5);
      default: return(0);
     }
  }
//+------------------------------------------------------------------+
