struct DEAL
{
  double Profit;
  datetime OpenTime;
  int Index;

#define MACROS_SET_MT4                                                                     \
                                                                                           \
  double FullProfit = 0;                                                                   \
  const bool Res = ((OrderType() <= OP_SELL) &&                                            \
                    (bool)(FullProfit = OrderProfit() + OrderCommission() + OrderSwap())); \
                                                                                           \
  if (Res)                                                                                 \
  {                                                                                        \
    this.Profit = FullProfit;                                                              \
                                                                                           \
    this.OpenTime = OrderOpenTime();                                                       \
  }                                                                                        \
                                                                                           \
  return(Res);

#define MACROS_SET_MT5 return(false);

  bool Set( void )
  {
    #ifdef __MQL5__
      #ifdef __MT4ORDERS__
        MACROS_SET_MT4
      #else // __MT4ORDERS__
        #ifdef __VIRTUAL__
          MACROS_SET_MT4
        #else // VIRTUAL__
          MACROS_SET_MT5
        #endif // VIRTUAL__
      #endif // __MT4ORDERS__
    #else // __MQL5__
      MACROS_SET_MT4
    #endif //__MQL5__
  }
#undef MACROS_SET_MT5
#undef MACROS_SET_MT4

  void ToNull( void )
  {
    this.Profit = 0;

    return;
  }

  void ToNull( DEAL &Deals[] ) const
  {
    Deals[this.Index].ToNull();

    return;
  }

  bool IsNull( void ) const
  {
    return(!this.Profit);
  }

  bool operator >( const DEAL &Deal ) const
  {
    return(this.OpenTime > Deal.OpenTime);
  }

  bool operator <( const DEAL &Deal ) const
  {
    return(this.OpenTime < Deal.OpenTime);
  }

  string ToString( void ) const
  {
    return((string)this.OpenTime + " " + ::DoubleToString(this.Profit, 2));
  }
};