// #define BESTINTERVAL_ONTESTER_FORMULA BestInterval.GetProfit() * BestInterval.GetRecoveryFactor()
// #define BESTINTERVAL_ONTESTER //   -   .
// #define BESTINTERVAL_LIMITSYNC_NETTING //       -   

#property strict

#include "Interval.mqh"
#include "Files.mqh"

#define DAY (24 * 3600)

class BESTINTERVAL
{
private:
  DEAL Deals[];
  DEAL OriginalDeals[];

  int AmountDeleteIntervals;

  INTERVAL FullInterval;

  INTERVAL Intervals[];
  bool IsCalculated;

// http://algolist.manual.ru/sort/quick_sort.php
#define MAXSTACK 2048		//   
  template <typename T>
  static void QuickSort( T &Array[] )
  {
    int i, j;   // ,   
    int lb, ub; //     

    int lbStack[MAXSTACK], ubStack[MAXSTACK]; //  
                          //     ,
                          //  : (lbstack)  (ubstack)

                          //  
    int StackPos = 1;   	//   
    int PPos;             //  
    T Pivot;              //  
    T Temp;

    lbStack[1] = 0;
    ubStack[1] = ::ArraySize(Array) - 1;

    do
    {
      //   lb  ub    .
      lb = lbStack[StackPos];
      ub = ubStack[StackPos];
      StackPos--;

      do
      {
        //  1.    Pivot

        PPos = (lb + ub) >> 1;
        i = lb;
        j = ub;
        Pivot = Array[PPos];

        do
        {
          while (Array[i] < Pivot)
            i++;

          while (Pivot < Array[j])
            j--;

          if ( i <= j )
          {
            Temp = Array[i];
            Array[i] = Array[j];
            Array[j] = Temp;

            i++;
            j--;
          }
        } while ( i <= j );

        //   i     ,
        // j -    (.  ), lb ? j ? i ? ub.
        //  ,   i  j    

        //  2, 3.         lb,ub

        if (i < PPos) //   
        {

          if (i < ub) //      1  - 
          {
            StackPos++;       //  ,   

            lbStack[StackPos] = i;
            ubStack[StackPos] = ub;
          }

          ub = j;             //    
                              //      
        }
        else //   
        {
          if (j > lb)
          {
            StackPos++;

            lbStack[StackPos] = lb;
            ubStack[StackPos] = j;
          }

          lb = i;
        }
      } while (lb < ub);        //      1 
    } while ( StackPos != 0 );  //     

    return;
  }
#undef MAXSTACK

  //     
  static double GetBestInterval( DEAL &dDeals[], int &Left, int &Right )
  {
    double SumMin = 0;
    double AnsMin = 0;
    int	LeftMin = 0;
    int RightMin = 0;
    int	MinusPos = -1;

    double SumMax = 0;
    double AnsMax = 0;
    int	LeftMax = 0;
    int RightMax = 0;
    int PositivePos = -1;

    double SumArray = 0;

    const int Size = ::ArraySize(dDeals);

    for (int i = 0; i < Size; i++)
    {
    	const double Profit = dDeals[i].Profit;

    	SumArray += Profit;
    	SumMax += Profit;
    	SumMin += Profit;

    	if (SumMax > AnsMax)
    	{
    		AnsMax = SumMax;

    		LeftMax = MinusPos + 1;
    		RightMax = i;
    	}
    	else if (SumMax < 0)
    	{
    		SumMax = 0;

    		MinusPos = i;
    	}

    	if (SumMin < AnsMin)
    	{
    		AnsMin = SumMin;

    		LeftMin = PositivePos + 1;
    		RightMin = i;
    	}
    	else if (SumMin > 0)
    	{
    		SumMin = 0;

    		PositivePos = i;
    	}
    }

    const double AnsMax2 = SumArray - AnsMin;
    const bool Reverse = (AnsMax2 > AnsMax);

    Left = AnsMin ? (Reverse ? (RightMin + 1) % Size : LeftMax) : 0;
    Right = AnsMin ? (Reverse ? (LeftMin + Size - 1) % Size : RightMax) : Size - 1;

    return(Reverse ? AnsMax2 : AnsMax);
  }

  bool Calculate( void )
  {
    this.FullInterval.Calculate(this.Deals, 1, ::ArraySize(this.Deals) - 1);
    this.FullInterval.CalculateDD(this.OriginalDeals);

    this.IsCalculated = false;

    return(true);
  }

  bool DeleteInterval( const int Left, const int Right )
  {
    if (Left <= Right)
      for (int i = Left; i <= Right; i++)
      {
        this.Deals[i].ToNull();
        this.Deals[i].ToNull(this.OriginalDeals);
      }
    else
    {
      for (int i = 0; i <= Right; i++)
      {
        this.Deals[i].ToNull();
        this.Deals[i].ToNull(this.OriginalDeals);
      }

      for (int i = ::ArraySize(this.Deals) - 1; i >= Left; i--)
      {
        this.Deals[i].ToNull();
        this.Deals[i].ToNull(this.OriginalDeals);
      }
    }

    return(true);
  }

  int GetNextPos( int Pos = 0, const bool FlagNull = false ) const
  {
    const int Size = ::ArraySize(this.Deals);

    while (Pos < Size)
      if (FlagNull ? this.Deals[Pos].IsNull() : !this.Deals[Pos].IsNull())
        break;
      else
        Pos++;

    return(Pos);
  }

  static int DeleteNullDeals( DEAL &dDeals[], const int PosNull = 1 )
  {
    const int Size = ::ArraySize(dDeals) - 1;
    int Amount = PosNull;

    for (int i = Amount; i < Size; i++)
      if (!dDeals[i].IsNull())
        dDeals[Amount++] = dDeals[i];

    dDeals[Amount++] = dDeals[Size];

    return(::ArrayResize(dDeals, Amount));
  }

  static int CorrectDeals( DEAL &dDeals[])
  {
    DEAL Deal = {0};
    int Pos = 1;
    int PosNull = 0;

    const int Size = ::ArraySize(dDeals);

    for (int i = Pos; i < Size; i++)
      if (dDeals[i] > Deal)
      {
        if (i > Pos + 1)
        {
//          const double NewProfit = ::NormalizeDouble(Deal.Profit / (i - Pos), 2);
          const double NewProfit = Deal.Profit / (i - Pos);

          if (!NewProfit && !PosNull)
            PosNull = Pos;

          for (int j = Pos; j < i; j++)
            dDeals[j].Profit = NewProfit;
        }

        Deal = dDeals[i];
        Pos = i;
      }
      else
        Deal.Profit += dDeals[i].Profit;

    return(PosNull ? BESTINTERVAL::DeleteNullDeals(dDeals, PosNull) : Size);
  }

public:
  BESTINTERVAL( void ) : AmountDeleteIntervals(0)
  {
    DEAL dDeals[];

    this.Set(dDeals);
    this.Calculate();

    this.FullInterval.Begin = 0;
    this.FullInterval.End = 0;
  }
#ifndef BESTINTERVAL_LIMITSYNC_NETTING

#define MACROS_SET_MT4                                             \
  const int Size = ::ArrayResize(dDeals, OrdersHistoryTotal());    \
                                                                   \
  for (int i = 0; i < Size; i++)                                   \
    if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) && Deal.Set()) \
      dDeals[Amount++] = Deal;                                     \
                                                                   \
  if (Size)                                                        \
  {                                                                \
    if (OrderSelect(0, SELECT_BY_POS, MODE_HISTORY))               \
      this.FullInterval.Begin = OrderOpenTime();                   \
                                                                   \
    if (OrderSelect(Size - 1, SELECT_BY_POS, MODE_HISTORY))        \
      this.FullInterval.End = OrderCloseTime();                    \
  }

  int Set( void )
  {
    int Amount = 0;
    DEAL dDeals[];

    DEAL Deal;

    #ifdef __MQL5__
      #ifdef __MT4ORDERS__
        MACROS_SET_MT4
      #else // __MT4ORDERS__
        #ifdef __VIRTUAL__
          MACROS_SET_MT4
        #endif // VIRTUAL__
      #endif // __MT4ORDERS__
    #else // __MQL5__
      MACROS_SET_MT4
    #endif //__MQL5__

    ::ArrayResize(dDeals, Amount);

//    FileSave("Deals.bin", dDeals, FILE_COMMON);

    return(this.Set(dDeals));
  }
#undef  MACROS_SET_MT4

#else // BESTINTERVAL_LIMITSYNC_NETTING

#ifdef __MQL5__
  int Set( void )
  {
    int Amount = 0;
    DEAL dDeals[];

    if (::HistorySelect(0, LONG_MAX))
    {
      DEAL Deal;

      const int Size = ::ArrayResize(dDeals, ::HistoryDealsTotal());
      ulong Ticket;

      for (int i = 1; i < Size; i++)
        if ((bool)(Ticket = ::HistoryDealGetTicket(i)))
        {
          if ((bool)(Deal.Profit = ::HistoryDealGetDouble(Ticket, DEAL_PROFIT)))
            dDeals[Amount++] = Deal;

          Deal.OpenTime = (datetime)::HistoryDealGetInteger(Ticket, DEAL_TIME);
        }

      if (Size)
      {
        this.FullInterval.Begin = (datetime)::HistoryDealGetInteger(::HistoryDealGetTicket(0), DEAL_TIME);
        this.FullInterval.End = (datetime)::HistoryDealGetInteger(::HistoryDealGetTicket(Size - 1), DEAL_TIME);
      }
    }

    ::ArrayResize(dDeals, Amount);

//    FileSave("Deals.bin", dDeals, FILE_COMMON);

    return(this.Set(dDeals));
  }

#endif // __MQL5__

#endif // BESTINTERVAL_LIMITSYNC_NETTING

  int Set( const DEAL &dDeals[] )
  {
    const int Size = ::ArraySize(dDeals);
    ::ArrayResize(this.Deals, Size + 2);

    int Amount = 0;

    this.Deals[Amount].OpenTime = -1;
    this.Deals[Amount].ToNull();
    this.Deals[Amount].Index = Amount;

    Amount++;

    for (int i = 0; i < Size; i++)
      if (!dDeals[i].IsNull())
      {
        this.Deals[Amount] = dDeals[i];
        this.Deals[Amount].Index = Amount;

        this.Deals[Amount++].OpenTime %= DAY;
      }

    this.Deals[Amount].OpenTime = DAY/* + 1*/;
    this.Deals[Amount].ToNull();
    this.Deals[Amount].Index = Amount;

    ::ArrayResize(this.Deals, ++Amount);
    ::ArrayCopy(this.OriginalDeals, this.Deals);

    BESTINTERVAL::QuickSort(this.Deals);
    Amount = BESTINTERVAL::CorrectDeals(this.Deals);

    this.Calculate();

    this.AmountDeleteIntervals = 0;

    if (Size)
    {
      if (!this.FullInterval.Begin)
        this.FullInterval.Begin = dDeals[0].OpenTime;

      if (!this.FullInterval.End)
        this.FullInterval.End = dDeals[Size - 1].OpenTime;
    }

    return(Amount);
  }

  bool DeleteWorseInterval( void )
  {
    const int Size = ::ArraySize(this.Deals);
    int Left, Right;

    return(BESTINTERVAL::GetBestInterval(this.Deals, Left, Right) && (Left || (Right != Size - 1)) && //    
           this.DeleteInterval((Right + 1) % Size, (Left - 1 + Size) % Size) && this.Calculate() && (bool)(++this.AmountDeleteIntervals));
  }

  const DEAL operator []( const int Pos ) const
  {
    return(this.Deals[Pos + 1]);
  }

  int GetAmount( void ) const
  {
    return(::ArraySize(this.Deals) - 2);
  }

  int GetIntervals( INTERVAL &iIntervals[] )
  {
    if (!this.IsCalculated)
    {
      ::ArrayResize(this.Intervals, this.AmountDeleteIntervals + 1);

      const int Size = ::ArraySize(this.Deals);
      int Amount = 0;

      int Left = this.GetNextPos();
      int Right = this.GetNextPos(Left + 1, true);;

      while (Right < Size)
      {
        this.Intervals[Amount].Begin = this.FullInterval.Begin;
        this.Intervals[Amount].End = this.FullInterval.End;

        this.Intervals[Amount].Calculate(this.Deals, Left, Right);
        this.Intervals[Amount++].CalculateDD(this.OriginalDeals);

        Left = this.GetNextPos(Right + 1);
        Right = this.GetNextPos(Left + 1, true);
      } ;

      this.IsCalculated = true;
      ::ArrayResize(this.Intervals, Amount);
    }

    return(::ArrayCopy(iIntervals, this.Intervals));
  }

  int GetAmountDeleteIntervals( void ) const
  {
    return(this.AmountDeleteIntervals);
  }

#define MACROS_GET(A, B)         \
  B Get##A( void ) const         \
  {                              \
    return(this.FullInterval.A); \
  }

  MACROS_GET(Profit, double)
  MACROS_GET(ProfitPlus, double)
  MACROS_GET(ProfitMinus, double)

  MACROS_GET(Total, int)
  MACROS_GET(TotalPlus, int)
  MACROS_GET(TotalMinus, int)

  MACROS_GET(ProfitFactor, double)
  MACROS_GET(Mean, double)

  MACROS_GET(MaxDrawDown, double)
  MACROS_GET(RecoveryFactor, double)

#undef MACROS_GET

#define HOUR 3600

  string ToString( void )
  {
    const int Size = this.IsCalculated ? ::ArraySize(this.Intervals) : this.GetIntervals(this.Intervals);

    string Str = "Amount of Delete Intervals = " + (string)this.AmountDeleteIntervals +
                 (Size ? " (" + ::TimeToString(this.Intervals[0].Begin, TIME_DATE) + " - " + ::TimeToString(this.Intervals[0].End + DAY, TIME_DATE) + ")" : NULL);

    if (Size && (this.AmountDeleteIntervals == 1))
    {
      const datetime StartDate = (Size == 1) ? this.Intervals[0].OpenTime : this.Intervals[1].OpenTime;
      const datetime EndDate = (Size == 1) ? this.Intervals[0].CloseTime : this.Intervals[0].CloseTime;

      const int iStartHour = (int)((StartDate / HOUR) + ((StartDate % HOUR < HOUR / 3) ? 0 : 1));
      const int iEndHour = (int)((EndDate / HOUR) + ((EndDate % HOUR < 2 * HOUR / 3) ? 0 : 1));
      const int iCountHours = (iEndHour - iStartHour + 24) % 24 - 1;

      Str += ", " + ::TimeToString(iStartHour * HOUR, TIME_MINUTES) + " - " + ::TimeToString(iEndHour * HOUR, TIME_MINUTES) + ", CountHours = " + (string)iCountHours;
    }


    for (int i = 0; i < Size; i++)
      Str += "\n" + this.Intervals[i].ToString(this.FullInterval.Profit);

    return(Str + "\nSUMMARY: " + this.FullInterval.ToString(this.FullInterval.Profit));
  }

#undef HOUR

  bool ToFile( const string FileName = __FILE__, const int CommonFlag = 0 )
  {
    const bool Res = (this.IsCalculated || this.GetIntervals(this.Intervals)) && ::FileSave(FileName, this.Intervals, CommonFlag);

    if (!Res)
      ::Print("ERROR: Can not save the File " + FileName + "!");

    return(Res);
  }

  int FromFile( const string FileName = __FILE__, const int CommonFlag = 0 )
  {
    const bool Res = (::FileLoad(FileName, this.Intervals, CommonFlag) > 0) && (this.IsCalculated = true);

    if (Res)
    {
      this.AmountDeleteIntervals = ::ArraySize(this.Intervals) - (this.Intervals[0].OpenTime ? 0 : 1);

      this.FullInterval.Calculate(this.Intervals);
    }
    else
      ::Print("ERROR: Can not load the File " + FileName + "!");

    return(Res);
  }

  bool IsTime( const datetime time )
  {
    bool Res = false;
    const int Size = this.IsCalculated ? ::ArraySize(this.Intervals) : this.GetIntervals(this.Intervals);

    for (int i = 0; (i < Size) && !Res; i++)
      Res = this.Intervals[i].IsTime(time % DAY);

    return(Res);
  }
};

#ifdef BESTINTERVAL_ONTESTER

input uint inAmountDeleteIntervals = 0; // Amount of Delete Intervals

#ifndef VIRTUAL_TESTER
  sinput
#endif

bool inBestInterval_Action = false; // BestInterval Action(true - single pass & MT4-style is required)

#ifdef OnTester
  #undef OnTester
#endif // OnTester

BESTINTERVAL* BestInterval = NULL;
const double InitBalance = AccountInfoDouble(ACCOUNT_BALANCE);

//  TimeLocal   
datetime GetTimeLocal( void )
{
  static const bool IsTester = MQLInfoInteger(MQL_TESTER);
  static uint TickCount = 0;
  static datetime InitTimeLocal = 0;

  datetime Res = 0;

  if (IsTester)
  {
    if (InitTimeLocal)
      Res = InitTimeLocal + (GetTickCount() - TickCount) / 1000;
    else
    {
      int Array[];
      const string FileName = __FUNCTION__;

      if (FileSave(FileName, Array))
      {
        TickCount = GetTickCount();

        Res = InitTimeLocal = (datetime)FileGetInteger(FileName, FILE_MODIFY_DATE);
      }
    }
  }
  else
    Res = TimeLocal();

  return(Res);
}

void Print2( const string Str )
{
#ifdef __MQL5__
  Print(Str);
#else // __MQL5__
  string Array[];

  const int Amount = StringSplit(Str, '\n', Array);

  for (int i = 0; i < Amount; i++)
    Print(Array[i]);
#endif // __MQL5__

  return;
}

int GetFileCommon( void )
{
#ifdef __MQL5__
  return(FILE_COMMON);
#else //  __MQL5__
  return(0);
#endif // __MQL5__
}

double OnTester( void )
{
  const bool IsOptimization = MQLInfoInteger(MQL_OPTIMIZATION);

  double Res = AccountInfoDouble(ACCOUNT_EQUITY);

  if (!IsOptimization)
    Print2("\nBestInterval Action(true - single pass & MT4-style & Virtual is required) = " + (string)inBestInterval_Action);

  if (!inBestInterval_Action && inAmountDeleteIntervals)
  {
    BestInterval = new BESTINTERVAL;
    BestInterval.Set();

    double PrevProfit = BestInterval.GetProfit();
    uint i = 0;

    do
    {
      if (!IsOptimization)
      {
        const double Profit = BestInterval.GetProfit();

        Print2("\nProfit = " + DoubleToString(Profit, 2) +
               " = " + DoubleToString(PrevProfit, 2) +
               " + " + DoubleToString(Profit - PrevProfit, 2) +
               (PrevProfit ? " (" + ::DoubleToString(100 * (Profit / PrevProfit - 1), 2) + "%)" : NULL) +
               " - " + BestInterval.ToString());

        PrevProfit = Profit;
      }
    } while (i++ < inAmountDeleteIntervals && BestInterval.DeleteWorseInterval());

    if (!IsOptimization)
    {
      if (BestInterval.ToFile(MQLInfoString(MQL_PROGRAM_NAME), GetFileCommon()))
        Print2("BestInterval is saved in \"" + MQLInfoString(MQL_PROGRAM_NAME) + "\"-file in common(MT5)/base(MT4) folder.");

      Print2("\nfinal balance - InitBalance (" + DoubleToString(InitBalance, 2) +
             ") + Profit (" + DoubleToString(Res - InitBalance, 2) + ") without BestInterval.");
      Print2("OnTester - Profit (" + DoubleToString(BestInterval.GetProfit(), 2) + ") with BestInterval.");
    }

    Res =
    #ifdef BESTINTERVAL_ONTESTER_FORMULA
          NormalizeDouble(BESTINTERVAL_ONTESTER_FORMULA, 2);
    #else // BESTINTERVAL_ONTESTER_FORMULA
          NormalizeDouble(BestInterval.GetProfit(), 2);
    #endif // BESTINTERVAL_ONTESTER_FORMULA
  }
  else if (!IsOptimization && inBestInterval_Action)
  {
  #ifdef __VIRTUAL__
    VIRTUAL::SelectByIndex();

    const string FileName = MQLInfoString(MQL_PROGRAM_NAME);
    const datetime FileModifyTime = (datetime)FileGetInteger(FileName, FILE_MODIFY_DATE, GetFileCommon());
    const datetime TimeAgo = GetTimeLocal() - FileModifyTime;

    Print2("Calculation time activated intervals is " +
           ((FileModifyTime == -1) ? "UNKNOWN" : (string)FileModifyTime) +
           " - " + FileName + " (common folder) " +
           ((TimeAgo >= 24 * 3600) ? "few days" : TimeToString(TimeAgo, TIME_SECONDS)) + " ago.");
    Print2("\n" + BestInterval.ToString());
    Print2("\nfinal balance - InitBalance (" + DoubleToString(InitBalance, 2) +
           ") + Profit (" + DoubleToString(AccountInfoDouble(ACCOUNT_EQUITY) - InitBalance, 2) + ") with BestInterval.");
    Print2("OnTester - Virtual InitBalance (" + DoubleToString(InitBalance, 2) +
           ") + Profit (" + DoubleToString(Res - InitBalance, 2) +
           ") without BestInterval. Profit is calculated with TickValue=1 and w/o Commission+Swap.");
  #else // __VIRTUAL__
    ::Print2("BestInterval Action is OFF: #include <fxsaber\\Virtual\\Virtual.mqh> - is required!");
  #endif // __VIRTUAL__
  }

  if (BestInterval)
    delete BestInterval;

  return(Res);
}

#define OnTester OldOnTester3

#ifndef VIRTUAL_TESTER
#ifdef __VIRTUAL__

#include <fxsaber\Virtual\Sync.mqh> // https://www.mql5.com/ru/code/22577

bool InitBestIntervalAction( void )
{
  if (inBestInterval_Action)
  {
    if (MQLInfoInteger(MQL_OPTIMIZATION))
      ExpertRemove(); // https://www.mql5.com/ru/forum/1111/page2310#comment_9017409
    else
    {
      BestInterval = new BESTINTERVAL;
      BestInterval.FromFile(MQLInfoString(MQL_PROGRAM_NAME), GetFileCommon());

      VIRTUAL::SelectByHandle(VIRTUAL::Create());
    }
  }

  return(true);
}

const bool Init =
  #ifndef BESTINTERVAL_LIMITSYNC_NETTING
    InitBestIntervalAction();
  #else // BESTINTERVAL_LIMITSYNC_NETTING
    InitBestIntervalAction() && (!inBestInterval_Action || EventSetTimer(1)); // https://www.mql5.com/ru/forum/1111/page2320#comment_9284480
  #endif // BESTINTERVAL_LIMITSYNC_NETTING

class BEST_TIME : ISTIME
{
public:
  static bool IsTime( const datetime time )
  {
    return(::BestInterval.IsTime(time));
  }
};

#ifdef BESTINTERVAL_LIMITSYNC_NETTING

int DayOfWeek( const datetime time )
{
  MqlDateTime TimeStruct;

  TimeToStruct(time, TimeStruct);

  return(TimeStruct.day_of_week);
}

datetime GetNextTime( const datetime &Times[] )
{
  datetime Res = TimeTradeServer();

  const int Size = ArraySize(Times);

  const int TimeFilter = (int)(Res % DAY);

  int i = 0;

  while ((i < Size) && (TimeFilter >= Times[i]))
    i++;

  Res += Times[i % Size] - TimeFilter + ((i == Size) ? DAY : 0);

  const int Day = DayOfWeek(Res);

  if ((Day == 6) || !Day)
  {
    Res += Times[0] - (Res % DAY) + DAY;

    if (Day)
      Res += DAY;
  }

  return(Res);
}

int GetTimes( datetime &Times[] )
{
  INTERVAL Intervals[];

  const int Size = BestInterval ? BestInterval.GetIntervals(Intervals) : 0;
  int Amount = ArrayResize(Times, Size << 1);

  for (int i = 0, j = 0; i < Size; i++)
  {
    Times[j++] = Intervals[i].OpenTime ? Intervals[i].OpenTime/* - 1 */: 0;
    Times[j++] = (Intervals[i].CloseTime + 1) % DAY;
  }

  if (Amount && !Times[Amount - 1])
  {
    if (Times[0])
    {
      for (int i = Amount - 1; i > 0; i--)
        Times[i] = Times[i - 1];

      Times[0] = 0;
    }
    else
    {
      for (int i = 1; i < Amount - 1; i++)
        Times[i - 1] = Times[i];

      Amount = ArrayResize(Times, Amount - 2);
    }
  }

  return(Amount);
}

void OnTimer()
{
  static const bool IsVisual = MQLInfoInteger(MQL_VISUAL_MODE);
  static datetime Times[];
  static const bool InitTimes = GetTimes(Times);

#define TOSTRING(A) (#A + " = " + (string)(A) + "\n")
  if (IsVisual)
    Comment(__FUNCTION__ + ": " + TOSTRING(TimeTradeServer()) + VIRTUAL::ToString(5));
#undef TOSTRING

  const datetime time = TimeTradeServer();
  const int Day = DayOfWeek(time);

  if (Day && (Day < 6))
    SYNC::Limits<BEST_TIME>(time);

  EventSetTimer((int)(GetNextTime(Times) - time));
}

#define OnTimer OnTimer2

#endif // BESTINTERVAL_LIMITSYNC_NETTING

void OnTick( void )
{
  if (BestInterval)
  {
    VIRTUAL::NewTick();
    ::OldOnTick2();

  #ifndef BESTINTERVAL_LIMITSYNC_NETTING
    SYNC::Positions<BEST_TIME>();
  #else // BESTINTERVAL_LIMITSYNC_NETTING
    SYNC::Limits<BEST_TIME>(TimeCurrent());
  #endif // BESTINTERVAL_LIMITSYNC_NETTING
  }
  else
    ::OldOnTick2();

  return;
}

#define OnTick OldOnTick2

#endif // __VIRTUAL__
#endif // VIRTUAL_TESTER

#endif // BESTINTERVAL_ONTESTER

#undef DAY