//+------------------------------------------------------------------+
//|                                              C_Trade_Pending.mqh |
//|                        Copyright 2017, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <C_Trade.mqh>

#property copyright "Copyright 2017, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class C_Trade_Pending
  {
public:
   //Constructors
                     C_Trade_Pending();
                     C_Trade_Pending(const double dblLowerLimit,const double dblUpperLimit,const datetime dtExpiry);
   //Destructor
                    ~C_Trade_Pending();
   //Public Functions
   bool              ScanForTrade(C_Trade &objTrade);
   //Public function to determin if pending order has expired.
   bool HasExpired(){bool boolRet=False;   if(TimeCurrent()>this.m_dtExpiry) boolRet=True;   return boolRet;};
protected:
   //Protected Variables.
   double            m_dblLowerLimit;
   double            m_dblUpperLimit;
   datetime          m_dtExpiry;
   datetime          m_dtInitiate;
private:
   bool              DeleteLines();
   bool              AddLines();
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
C_Trade_Pending::C_Trade_Pending()
  {
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
C_Trade_Pending::C_Trade_Pending(const double dblLowerLimit,const double dblUpperLimit,const datetime dtExpiry)
  {
#ifdef D_TEST_PRINT_FUNCTION_START
   Print(__FUNCTION__," Start");
#endif

   this.m_dblLowerLimit=dblLowerLimit;
   this.m_dblUpperLimit=dblUpperLimit;
   this.m_dtExpiry=dtExpiry;
   this.m_dtInitiate=TimeLocal();

   this.AddLines();

#ifdef D_TEST_PRINT_FUNCTION_END
   Print(__FUNCTION__," End");
#endif
  };
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
C_Trade_Pending::~C_Trade_Pending()
  {
#ifdef D_TEST_PRINT_FUNCTION_START
   Print(__FUNCTION__," Start");
#endif

   this.DeleteLines();

#ifdef D_TEST_PRINT_FUNCTION_END
   Print(__FUNCTION__," End");
#endif
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| Public Functions                                                 |
//+------------------------------------------------------------------+  
bool C_Trade_Pending::ScanForTrade(C_Trade &objTrade)
  {
   bool boolRet=False;

   if(!this.HasExpired())
     {
      double dblSpot;
      if(objTrade.GetType()==BUY)
        {
         dblSpot=MarketInfo(objTrade.GetSymbol(),MODE_BID);
        }
      else
        {
         dblSpot=MarketInfo(objTrade.GetSymbol(),MODE_ASK);
        }
      if(dblSpot>=this.m_dblLowerLimit && dblSpot<=this.m_dblUpperLimit)
        {
         boolRet=True;
        }
     }

   return boolRet;
  };
//+------------------------------------------------------------------+
//| Private Functions                                                 |
//+------------------------------------------------------------------+ 
bool C_Trade_Pending::DeleteLines()
  {
#ifdef D_TEST_PRINT_FUNCTION_START
   Print(__FUNCTION__," Start");
#endif

//Use the initiation time as the unique identifier for this pending order
   long lngTime=(long)this.m_dtInitiate;

   string strNameUpper="PEND_UPPER_"+IntegerToString(lngTime);
   string strNameLower="PEND_LOWER_"+IntegerToString(lngTime);

//Delete the lines if they already exist.
   DeleteLine(0,strNameUpper,True);
   DeleteLine(0,strNameLower,True);

   ChartRedraw();

#ifdef D_TEST_PRINT_FUNCTION_END
   Print(__FUNCTION__," End");
#endif

   return True;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool C_Trade_Pending::AddLines()
  {
#ifdef D_TEST_PRINT_FUNCTION_START
   Print(__FUNCTION__," Start");
#endif

   bool boolUpper=True,boolLower=True;

//Use the initiation time as the unique identifier for this pending order
   long lngTime=(long)this.m_dtInitiate;

//Get the colour of the lines
   long lngCol=clrNONE;
   ChartGetInteger(0,CHART_COLOR_STOP_LEVEL,0,lngCol);
   color colSTP=(color)lngCol;

//Get the names of the lines.
   string strNameUpper="PEND_UPPER_"+IntegerToString(lngTime);
   string strNameLower="PEND_LOWER_"+IntegerToString(lngTime);

//Delete the lines if they already exist.
   this.DeleteLines();

//Create hidden stoploss line
   if(this.m_dblLowerLimit>0) boolLower=CreateHorizontalLine(0,strNameLower,0,this.m_dblLowerLimit,colSTP,STYLE_DASHDOT,1,True,True);

//Create hidden takeprofit line
   if(this.m_dblUpperLimit>0) boolUpper=CreateHorizontalLine(0,strNameUpper,0,this.m_dblUpperLimit,colSTP,STYLE_DASHDOT,1,True,True);

//Redraw the chart.
   ChartRedraw();

#ifdef D_TEST_PRINT_FUNCTION_END
   Print(__FUNCTION__," End");
#endif

   return (boolLower && boolUpper);
  }
//+------------------------------------------------------------------+
