//+------------------------------------------------------------------+
//|                                   C_Trade_TrailingStopLoss_2.mq4 |
//|                                     Copyright 2017, Mark Wilson. |
//|                          https://www.mql5.com/en/users/balrog100 |
//+------------------------------------------------------------------+
#include <C_Trade_TrailingStopLoss.mqh>

#property copyright "Copyright 2017, Mark Wilson"
#property link      "https://www.mql5.com/en/users/balrog100"
#property version   "1.00"
#property strict


//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
input E_BS  I_BuyOrSell=BUY;                                               //Buy or Sell
input int I_TrailAmountInPoints=20;                                        //TrailAmount in points
input int I_HiddenTakeProfitInPoints=100;                                  //TakeProfit (points)
input int I_LiveSpreadInPoints=40;                                         //Extra spread on top of hidden sl/tp for live trade.
input double I_Volume=0.1;                                                 //Volume/Lots
input int I_Slippage=5;                                                    //Slippage
input bool I_DrawLines=True;                                               //Draw Hidden SL/TP on chart

//+------------------------------------------------------------------+
//| Global Variables                                                 |
//+------------------------------------------------------------------+
C_Trade_TrailingStopLoss *g_objTrade;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+


int OnInit()
  {

//This system is very similar to the C_Trade object, except it adds a trailing stoploss onto the trade.

   Print(__FILE__,"   START-------------------------------------------------");

//Get the actual live spread.
   double dblLiveSpread=I_LiveSpreadInPoints*Point();
   double dblTrailAmount=I_TrailAmountInPoints*Point();

//Get a suitable spot, sl and tp
   RefreshRates();
   double dblSpot,dblHiddenTakeProfit;
   if(I_BuyOrSell==BUY)
     {
      dblSpot=Ask;
      dblHiddenTakeProfit=dblSpot+I_HiddenTakeProfitInPoints*Point();
     }
   else
     {
      dblSpot=Bid;
      dblHiddenTakeProfit=dblSpot-I_HiddenTakeProfitInPoints*Point();
     }

//Create a new trade
   g_objTrade=NULL;
   g_objTrade= new C_Trade_TrailingStopLoss(Symbol(),I_BuyOrSell,I_Volume,dblSpot,dblTrailAmount,dblHiddenTakeProfit,"",0,dblLiveSpread,I_DrawLines);
   if(!g_objTrade.OrderSend(dblSpot,I_Slippage))
     {
      //Trade Entry Error Processing could be added here.

      //Trade has not initiated properly, destroy the class
      delete g_objTrade;
      g_objTrade=NULL;
     }

//Print out the details
   string strPrint=g_objTrade.Description();
   Comment(strPrint);
   Print(__FILE__+" "+__FUNCTION__," ",strPrint);

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {

//If the EA has been shut down, destroy g_objTrade.
   if(g_objTrade!=NULL)
     {
      //Annoying, I wanted to destroy the trade in the destructor, but it kept making MetaTrader hang.
      if(g_objTrade.TradeIsLive())
        {
         RefreshRates();
         double dblSpot=Bid;
         if(g_objTrade.GetType()==SELL) dblSpot=Ask;
         g_objTrade.OrderClose(dblSpot,I_Slippage,clrRed);

         //Trade Close Error Processing could be added here.
        }
      delete g_objTrade;
     }

   Print(__FILE__+" "+__FUNCTION__,"   END-------------------------------------------------");

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//Run this with every tick to see if the trade has been closed.
   if(g_objTrade!=NULL)
     {
      if(g_objTrade.TradeIsLive())
        {
         if(g_objTrade.ScanWithEveryTick(I_Slippage))
           {  //Ensure trade is closed.
            delete g_objTrade;
            g_objTrade=NULL;
           }
        }
     }

  }
//+------------------------------------------------------------------+
