//   

#include <fxsaber\SubWindow.mqh>

class MOUSE
{
private:
  const long Event;

public:
  static bool IsLeftDown( const string &sparam )
  {
    return(((uint)sparam) & 1);
  }

  static bool IsShiftDown( const string &sparam )
  {
    return(((uint)sparam) & (1 << 2));
  }

  static bool IsCtrlDown( const string &sparam )
  {
    return(((uint)sparam) & (1 << 3));
  }

  MOUSE( void ) : Event(::ChartGetInteger(0, CHART_EVENT_MOUSE_MOVE))
  {
    ::ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, true);
  }

  ~MOUSE( void )
  {
    ::ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, this.Event);

    ::Comment("");
  }
};

#define KEY_ESCAPE   27
#define KEY_DELETE 46

void OnChartEvent( const int id, const long &lparam, const double &dparam, const string &sparam )
{
  static const MOUSE Mouse;

  static bool ButtonCtrl = false;

  static long Button = false;
  static int SubWindow = 0;

  static int X = 0;
  static int Y = 0;

  if (id == CHARTEVENT_KEYDOWN)
  {
    if (lparam == KEY_ESCAPE)
      ExpertRemove();
    else if (lparam == KEY_DELETE)
      SUBWINDOW::DeleteAll();
  }
  else if (id == CHARTEVENT_CLICK)
  {
    if ((Button) && (!MOUSE::IsLeftDown(sparam)))
    {
      Button = false;

      const int SubWindow2 = SUBWINDOW::Get(0, (int)lparam, (int)dparam);

      if (ButtonCtrl)
      {
        ButtonCtrl = false;

        SUBWINDOW::Copy(0, SubWindow, SubWindow2);
      }
      else
        SUBWINDOW::Swap(0, SubWindow, SubWindow2);
    }
  }
  else if (id == CHARTEVENT_MOUSE_MOVE)
  {
    X = (int)lparam;
    Y = (int)dparam;

    ButtonCtrl = MOUSE::IsCtrlDown(sparam);

    if ((!Button) && MOUSE::IsLeftDown(sparam))
    {
      SubWindow = SUBWINDOW::Get(0, X, Y);

      if (MOUSE::IsShiftDown(sparam))
        SUBWINDOW::Delete(0, SubWindow);
      else
        Button = true;
    }
  }

  //    
  Comment((string)X + " x " + (string)Y +
          "\n\nHelp:\n" +
          "Drag&Drop - Swap SubWindows\n" +
          "Drag&Drop+CTRL - Copy SubWindows\n" +
          "SHIFT+Click - Delete SubWindow\n" +
          "\nDELETE - Delete All SubWindows\n" +
          "\nESCAPE - Exit");
}