//+------------------------------------------------------------------+
//|                                            TrailingWPRwStops.mqh |
//|                                                      version 1.2 |
//|                                     Copyright 2013, Murikov Egor |
//|                                               gogen777@gmail.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertTrailing.mqh>
// wizard description start
//+---------------------------------------------------------------------------+
//| Description of the class                                                  |
//| Title=Trailing Stop based on WPR with long ang short stops                |
//| Type=Trailing                                                             |
//| Name=WPR_Trailing                                                         |
//| Class=CTrailingWPRLongShortStps                                           |
//| Page=                                                                     |
//| Parameter=TimeframeWPR,ENUM_TIMEFRAMES, PERIOD_CURRENT,Timeframe of WPR   |
//| Parameter=PeriodWPR,int,14, Period of WPR                                 |
//| Parameter=StopLevelsWPR,int,30, Stop levels of WPR-trailing (-50StpLvl)  |
//| Parameter=ShortStop,int,100, Short stop                                   |
//| Parameter=LongStop,int,500, Long stop                                     |
//+---------------------------------------------------------------------------+
// wizard description end
//+---------------------------------------------------------------------------+
//| Class CTrailingWPRLongShortStps.                                          |
//| Purpose: Class of trailing stops based on WPR with Long and Short stop.   |
//|              Derives from class CExpertTrailing.                          |
//+---------------------------------------------------------------------------+
class CTrailingWPRLongShortStps : public CExpertTrailing
  {
protected:
   CiWPR            *m_WPR;
   //--- input parameters
   ENUM_TIMEFRAMES   m_wpr_timeframe;                    // WPR: timeframe
   int               m_wpr_period;                       // WPR: period of calculation
   int               m_wpr_stoplevel;                    // WPR: signal level (-50  m_wpr_stoplevel)
   int               m_long_stop;                        // Long stop value
   int               m_short_stop;                       // Short stop value
   int               m_symbol_stplvl;                    // Stop-level for the current symbol

public:
                     CTrailingWPRLongShortStps();
                    ~CTrailingWPRLongShortStps();
   //--- methods of initialization of protected data
   void              TimeframeWPR(ENUM_TIMEFRAMES tf)       { m_wpr_timeframe = tf;       }
   void              PeriodWPR(int period)                  { m_wpr_period = period;      }
   void              StopLevelsWPR(int stplvl)              { m_wpr_stoplevel = stplvl;   }
   void              LongStop(int stp)                      { m_long_stop = stp;          }
   void              ShortStop(int stp)                     { m_short_stop = stp;         }

   virtual bool      InitIndicators(CIndicators *indicators);
   virtual bool      ValidationSettings();
   //---
   virtual bool      CheckTrailingStopLong(CPositionInfo *position,double &sl,double &tp);
   virtual bool      CheckTrailingStopShort(CPositionInfo *position,double &sl,double &tp);
  };
//+------------------------------------------------------------------+
//| Constructor CTrailingWPRLongShortStps.                                         |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CTrailingWPRLongShortStps::CTrailingWPRLongShortStps()
  {
//--- initialize protected data
   m_WPR=NULL;
//--- set default inputs
   m_wpr_timeframe=PERIOD_CURRENT;
   m_wpr_period=14;
   m_wpr_stoplevel=30;
   m_long_stop=500;
   m_short_stop=100;
  }
//+------------------------------------------------------------------+
//| Destructor CTrailingWPRLongShortStps.                                          |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CTrailingWPRLongShortStps::~CTrailingWPRLongShortStps()
  {
   delete(m_WPR);
//---
  }
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//| INPUT:  no.                                                      |
//| OUTPUT: true-if settings are correct, false otherwise.           |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CTrailingWPRLongShortStps::ValidationSettings()
  {
   if(!CExpertTrailing::ValidationSettings()) return(false);
//--- initial data checks

   m_symbol_stplvl=m_symbol.StopsLevel();

   if(m_wpr_period<=3)
     {
      printf(__FUNCTION__+": period WPR must be greater than 3");
      return(false);
     }
   if((m_wpr_stoplevel<=1) || (m_wpr_stoplevel>=49))
     {
      printf(__FUNCTION__+": Stop levels of WPR must be between 1 and 49");
      return(false);
     }
   if(m_short_stop<m_symbol_stplvl)
     {
      printf(__FUNCTION__+": Short Stop level must be greater than or equal Symbol StopsLevel. Overridden");
      m_short_stop=m_symbol_stplvl;
     }

//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking for input parameters and setting protected data.        |
//| INPUT:  symbol         -pointer to the CSymbolInfo,              |
//|         period         -working period,                          |
//|         adjusted_point -adjusted point value.                    |
//| OUTPUT: true-if successful, false otherwise.                     |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CTrailingWPRLongShortStps::InitIndicators(CIndicators *indicators)
  {
//--- check
   if(indicators==NULL) return(false);
//--- create WPR indicator
   if(m_WPR==NULL)
      if(( m_WPR=new CiWPR)==NULL)
        {
         printf(__FUNCTION__+": error creating object");
         return(false);
        }
//--- add WPR indicator to collection
   if(!indicators.Add(m_WPR))
     {
      printf(__FUNCTION__+": error adding object");
      delete m_WPR;
      return(false);
     }
//--- initialize WPR indicator
   if(!m_WPR.Create(m_symbol.Name(),m_wpr_timeframe,m_wpr_period))
     {
      printf(__FUNCTION__+": error initializing object");
      return(false);
     }
//m_WPR.BufferResize(3+m_wpr_shift);
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking trailing stop and/or profit for long position.          |
//| INPUT:  position - pointer for position object,                  |
//|         sl       - refernce for new stop loss,                   |
//|         tp       - refernce for new take profit.                 |
//| OUTPUT: true-if successful, false otherwise.                     |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CTrailingWPRLongShortStps::CheckTrailingStopLong(CPositionInfo *position,double &sl,double &tp)
  {
//--- check
   if(position==NULL) return(false);

   sl=EMPTY_VALUE;
   tp=EMPTY_VALUE;

   double price=m_symbol.Bid();
   double ppo = position.PriceOpen();
   double psl = position.StopLoss();
   double ptp = position.TakeProfit();
   double ssl = 0.;
   //--- calculating long stop
   double lsl = (price > ppo) ? price : ppo;
   lsl = NormalizeDouble(lsl - m_long_stop*m_symbol.Point(),m_symbol.Digits());
   ssl = lsl;

   //--- calculating short stop
   if(price>ppo)
     {
      if((m_WPR.Main(1)>(-50+m_wpr_stoplevel)) && (m_WPR.Main(0)<(-50+m_wpr_stoplevel)))
        {
         ssl=NormalizeDouble(price-m_short_stop*m_symbol.Point(),m_symbol.Digits());;
        }
     }

   sl=(ssl>lsl) ? ssl : lsl;

   if(sl<=psl) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking trailing stop and/or profit for short position.         |
//| INPUT:  position - pointer for position object,                  |
//|         sl       - refernce for new stop loss,                   |
//|         tp       - refernce for new take profit.                 |
//| OUTPUT: true-if successful, false otherwise.                     |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CTrailingWPRLongShortStps::CheckTrailingStopShort(CPositionInfo *position,double &sl,double &tp)
  {
//--- check
   if(position==NULL) return(false);
//---
   sl=EMPTY_VALUE;
   tp=EMPTY_VALUE;

   double price=m_symbol.Ask();
   double ppo = position.PriceOpen();
   double psl = position.StopLoss();
   double ptp = position.TakeProfit();
   double ssl = 0.;
   //--- calculating long stop
   double lsl = (price < ppo) ? price : ppo;
   lsl = NormalizeDouble(lsl + m_long_stop*m_symbol.Point(), m_symbol.Digits());
   ssl = lsl;
   //--- calculating short stop
   if(price<ppo)
     {
      if((m_WPR.Main(1)<(-50-m_wpr_stoplevel)) && (m_WPR.Main(0)>(-50-m_wpr_stoplevel)))
        {
         ssl=NormalizeDouble(price+m_short_stop*m_symbol.Point(),m_symbol.Digits());;
        }
     }

   sl=(ssl<lsl) ? ssl : lsl;
   if(sl>=psl) return(false);
//---
   return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
