// MQL4&5-Code

#include <Price_Compare.mqh>

#define COMPARE(OPERATOR)         \
  if (CP(Price1) OPERATOR Price2) \
    Str += " " + #OPERATOR;

string CompareToString( const double Price1, const double Price2 )
{
  string Str = "";

  COMPARE(==)
  COMPARE(!=)
  COMPARE(>=)
  COMPARE(<=)
  COMPARE(>)
  COMPARE(<)

  return((string)Price1 + "\t" + Str + "\t" + (string)Price2);
}

string ExampleCompare( const double Price )
{
  string Str = "Price1\tResults\tPrice2\tNormalize(Price2)\tMyNormalize(Price2)";

  for (double Price2 = Price - 2 * ::Point(); Price2 < Price + 2 * ::Point(); Price2 += ::Point() / 10)
  {
    Price2 = ::NormalizeDouble(Price2, ::Digits() + 1);

    Str += "\n" + CompareToString(Price, Price2) + "\t" +
           (string)::NormalizeDouble(Price2, ::Digits()) + "\t" + (string)PRICE_COMPARE::MyNormalizeDouble(Price2, ::Digits());
  }

  return(Str);
}

void OnStart( void )
{
  ::MessageBox(ExampleCompare(::SymbolInfoDouble(::Symbol(), SYMBOL_BID)));

  return;
}