//+---------------------------------------------------------------------+
//|                                                    XTrendlessOS.mq5 | 
//|                                       Copyright  2010,   LenIFCHIK | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2010, LenIFCHIK"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrBlue,clrLime,clrGray,clrGreen,clrMediumVioletRed,clrRed,clrMagenta
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "XTrendlessOS"

//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_WIDTH // 
  {
   w_1 = 1,   //1
   w_2,       //2
   w_3,       //3
   w_4,       //4
   w_5        //5
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method TMA_Method=MODE_JurX; // 
input int TLength=7; //        
input int TPhase=100; // ,
input Applied_price_ IPC=PRICE_CLOSE_;// 
input double OBLevel=0.00473;   //  
input double OSLevel=-0.00473; //   
input color LevelsColor=Red; // 
input ENUM_LINE_STYLE LevelsStyle=STYLE_DASHDOTDOT; // 
input ENUM_WIDTH LevelsWidth=w_1; //  
input int Shift=0; //      
//+----------------------------------------------+

//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
//----      
int min_rates_total;
//----
double OBLevel06,OBLevel08,OSLevel06,OSLevel08;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   min_rates_total=XMA.GetStartBars(TMA_Method,TLength,TPhase);

//----       
   XMA.XMALengthCheck("TLength", TLength);
   XMA.XMAPhaseCheck("TPhase", TPhase, TMA_Method);

//----    
   OBLevel06=0.6*OBLevel;
   OBLevel08=0.8*OBLevel;
   OSLevel06=0.6*OSLevel;
   OSLevel08=0.8*OSLevel;

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   string shortname;
   string Smooth=XMA.GetString_MA_Method(TMA_Method);
   StringConcatenate(shortname,"XTrendlessOS(",TLength,", ",TLength,", ",Smooth,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);

//----   
   IndicatorSetInteger(INDICATOR_LEVELS,6);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,3,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,3,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,3,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,4,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,4,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,4,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,5,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,5,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,5,LevelsWidth);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,OBLevel06);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,OBLevel08);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,OSLevel06);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,3,OSLevel08);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,4,OSLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,5,OBLevel);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price_,xma,current;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA.XMASeries(0,prev_calculated,rates_total,TMA_Method,TPhase,TLength,price_,bar,false);
      IndBuffer[bar]=price_-xma;
     }

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total;

//----     IndBuffer
   for(bar=first; bar<rates_total; bar++)
     {
      ColorIndBuffer[bar]=0;
      current=IndBuffer[bar];

      if(current>OBLevel) ColorIndBuffer[bar]=6; else if(current>OBLevel08) ColorIndBuffer[bar]=5; else if(current>OBLevel06) ColorIndBuffer[bar]=4;
      if(current<OSLevel) ColorIndBuffer[bar]=1; else if(current<OSLevel08) ColorIndBuffer[bar]=2; else if(current<OSLevel06) ColorIndBuffer[bar]=3;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
