//+------------------------------------------------------------------+
//|                                        RJTX_Matches_Smoothed.mq5 |
//|                            Copyright 2015, Rafael Jimenez Tocino |
//|               http://www.tradingrafa.com/indicadores/rjt_matches |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright 2015, Rafael Jimenez Tocino"
//---    
#property link      "http://www.tradingrafa.com/indicadores/rjt_matches"
#property description "We recommend adjust the body and head size of the matches for better visualization."
//---   
#property version   "4.00"
//----     
#property indicator_separate_window
//---        
#property indicator_buffers 5
//---     
#property indicator_plots   5
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrDarkViolet
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  2
#property indicator_width1  2
//----   
#property indicator_label1  "match 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2  clrDarkViolet
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  "match 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3  clrDarkViolet
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "match 3"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_ARROW
//---        
#property indicator_color4  clrDeepPink
//---    4  2
#property indicator_width4  2
//---    
#property indicator_label4  "RJTX_Matches_Smoothed Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   5   
#property indicator_type5   DRAW_ARROW
//---        
#property indicator_color5  clrDodgerBlue
//---    5  2
#property indicator_width5  2
//---    
#property indicator_label5 "RJTX_Matches_Smoothed Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMAO,XMAC;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA    //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iPeriod=10;  //   
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint XLength=12;                   //  
input int XPhase=15;                     //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
//+----------------------------------------------+
//---   ,   
//---      
double LineBuffer0[];
double LineBuffer1[];
double LineBuffer2[];
double SellBuffer[];
double BuyBuffer[];
//---
int min_rates_total;
//----   
int Count[];
double xOpen[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max2=Size;
   Max1=Max2-1;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=GetStartBars(XMA_Method,XLength,XPhase);
   min_rates_total=int(MathMax(iPeriod,min_rates_total));
//----       
   ArrayResize(Count,iPeriod+1);
   ArrayResize(xOpen,iPeriod+1);
//----   
   IndInit(0,LineBuffer0,0,min_rates_total,0);
   IndInit(1,LineBuffer1,0,min_rates_total,0);
   IndInit(2,LineBuffer2,0,min_rates_total,0);
   IndInit(3,SellBuffer,0,min_rates_total,0);
   IndInit(4,BuyBuffer,0,min_rates_total,0);
//---   
   PlotIndexSetInteger(3,PLOT_ARROW,174);
   PlotIndexSetInteger(4,PLOT_ARROW,174);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="RJTX_Matches_Smoothed";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int first,bar;
   static uint p=0;
   double xclose;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      ArrayInitialize(Count,0);
      ArrayInitialize(xOpen,open[first]);
     }
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      xOpen[Count[0]]=XMAO.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,open[bar],bar,false);
      xclose=XMAC.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,close[bar],bar,false);
      //--- the color of matchstick heads
      if(xclose>xOpen[Count[iPeriod]])
        {
         SellBuffer[bar]=0.0;
         BuyBuffer[bar]=xclose;
        }
      else
        {
         SellBuffer[bar]=xclose;
         BuyBuffer[bar]=0.0;
        }
      //---
      switch(p)
        {
         case 0:
           {
            LineBuffer0[bar]=xOpen[Count[iPeriod-1]];
            LineBuffer1[bar]=0.0;
            LineBuffer2[bar]=xclose;
            break;
           }
         case 1:
           {
            LineBuffer0[bar]=xclose;
            LineBuffer1[bar]=xOpen[Count[iPeriod-1]];
            LineBuffer2[bar]=0.0;
            break;
           }
         case 2:
           {
            LineBuffer0[bar]=0.0;
            LineBuffer1[bar]=xclose;
            LineBuffer2[bar]=xOpen[Count[iPeriod-1]];
           }
        }
      if(bar<rates_total-1)
        {
         Recount_ArrayZeroPos(Count,iPeriod+1);
         p++;
        }
      if(p>2) p=0;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
