//+---------------------------------------------------------------------+
//|                                                       RealValue.mq5 | 
//|                                  Copyright  2015, rzegorz Szczerba | 
//|                                         grzegorz.szczerba@gmail.com | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, rzegorz Szczerba"
#property link "grzegorz.szczerba@gmail.com"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "RealValue"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Alpha=1;
input double Variation=3.0;
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint XLength=20;                   //                      
input int XPhase=15;                     //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0;                       //      
input int PriceShift=0;                  //      
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[];
//----      
double dPriceShift;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| RealValue indicator initialization function                      | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=GetStartBars(XMA_Method,XLength,XPhase);
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----    
   dPriceShift=_Point*PriceShift;
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"RealValue");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| RealValue iteration function                                     | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double var,xvar,val,diffB,diff,res;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=2; //      
      IndBuffer[first-1]=(high[first-1]+low[first-1])/2.0;
      IndBuffer[first-2]=(high[first-2]+low[first-2])/2.0;
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      var=MathAbs((high[bar]-low[bar])-(high[bar-1]-low[bar-1]));
      xvar=XMA1.XMASeries(2,prev_calculated,rates_total,XMA_Method,XPhase,XLength,var,bar,false);
      val=(high[bar]+low[bar])/2.0;
      diffB=IndBuffer[bar-1]-IndBuffer[bar-2];
      diff=val-(high[bar-1]+low[bar-1])/2.0;
      res=Alpha*var;
      if(diffB>res) diffB=res;
      if(diffB<-res) diffB=-res;
      //---
      double c=var/Variation;
      if(val>IndBuffer[bar-1])
        {
         if(diff<0)
           {
            c=0;
            diffB=0;
           }
         IndBuffer[bar]=IndBuffer[bar-1]+diffB+c;
        }
      else
        {
         if(diff>0)
           {
            c=0;
            diffB=0;
           }
         IndBuffer[bar]=IndBuffer[bar-1]+diffB-c;
        }
      IndBuffer[bar]=(IndBuffer[bar]+IndBuffer[bar-1])/2.0;
      IndBuffer[bar]+=dPriceShift;
     }
//----
   return(rates_total);
  }
//+------------------------------------------------------------------+
