//+------------------------------------------------------------------+ 
//|                                        XMA_Range_Channel_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "arria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "XMA_Range_Channel       "
//----     
#property indicator_chart_window
//----    9
#property indicator_buffers 9 
//----    
#property indicator_plots   4
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                             //        
#define INDICATOR_NAME "XMA_Range_Channel"  //    
#define SIZE 1                              //      CountIndicator  
//+--------------------------------------------+
//|                    |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
//----        Lavender
#property indicator_color1 clrLavender
//----   
#property indicator_label1  "XMA Range Channel"
//+--------------------------------------------+
//|                   |
//+--------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//----   
#property indicator_color2  clrMediumSeaGreen
#property indicator_color3  clrRed
//----  -  
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
//----    1
#property indicator_width2  1
#property indicator_width3  1
//----   
#property indicator_label2  "Up Line"
#property indicator_label3  "Down Line"
//+--------------------------------------------+
//|                    |
//+--------------------------------------------+
//----      
#property indicator_type4   DRAW_COLOR_CANDLES
#property indicator_color4   clrMagenta,clrPurple,clrGreen,clrLime
//----   
#property indicator_label4  "Open;High;Low;Close"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;          //    ()
input Smooth_Method XMA_Method=MODE_SMA;            //  
input int XLength=7;                                //  
input int XPhase=100;                               //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0;                                  //      
input int PriceShift=0;                             //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtOpenBuffer[],ExtHighBuffer[],ExtLowBuffer[],ExtCloseBuffer[],ExtColorBuffer[];
double UpIndBuffer[],DnIndBuffer[],UpLineBuffer[],DnLineBuffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    XMA_Range_Channel
   Ind_Handle=iCustom(Symbol(),TimeFrame,"XMA_Range_Channel",XMA_Method,XLength,XPhase,0,PriceShift);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      XMA_Range_Channel");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,UpIndBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,DnIndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(2,UpLineBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,DnLineBuffer,INDICATOR_DATA);
//----  ,     
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   SetIndexBuffer(4,ExtOpenBuffer,INDICATOR_DATA);
   SetIndexBuffer(5,ExtHighBuffer,INDICATOR_DATA);
   SetIndexBuffer(6,ExtLowBuffer,INDICATOR_DATA);
   SetIndexBuffer(7,ExtCloseBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(8,ExtColorBuffer,INDICATOR_COLOR_INDEX);
//----  ,     
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(UpIndBuffer,true);
   ArraySetAsSeries(DnIndBuffer,true);
   ArraySetAsSeries(UpLineBuffer,true);
   ArraySetAsSeries(DnLineBuffer,true);
   ArraySetAsSeries(ExtOpenBuffer,true);
   ArraySetAsSeries(ExtHighBuffer,true);
   ArraySetAsSeries(ExtLowBuffer,true);
   ArraySetAsSeries(ExtCloseBuffer,true);
   ArraySetAsSeries(ExtColorBuffer,true);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//---
   if(!CountLines(0,NULL,TimeFrame,Ind_Handle,0,UpIndBuffer,1,DnIndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountLines(0,NULL,TimeFrame,Ind_Handle,2,UpLineBuffer,3,DnLineBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountCandels(0,NULL,TimeFrame,Ind_Handle,ExtOpenBuffer,ExtHighBuffer,ExtLowBuffer,ExtCloseBuffer,ExtColorBuffer,
      8,time,open,high,low,close,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLines                                                       |
//+------------------------------------------------------------------+
bool CountLines(uint     Numb,            //   CountLine      (  - 0)
                string   Symb,            //  
                ENUM_TIMEFRAMES TFrame,   //  
                int      IndHandle,       //   
                uint     UpBuffNumb,      //       
                double&  UpIndBuf[],      //      
                uint     DnBuffNumb,      //       
                double&  DnIndBuf[],      //      
                const datetime& iTime[],  //  
                const int Rates_Total,    //       
                const int Prev_Calculated,//       
                const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpArr[1],DnArr[1];
         //---      
         if(CopyBuffer(IndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);
         //---
         UpIndBuf[bar]=UpArr[0];
         DnIndBuf[bar]=DnArr[0];
        }
      else
        {
         UpIndBuf[bar]=UpIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| CountCandels                                                     |
//+------------------------------------------------------------------+
bool CountCandels(uint     Numb,            //   CountLine      (  - 0)
                  string   Symb,            //  
                  ENUM_TIMEFRAMES TFrame,   //  
                  int      IndHandle,       //   
                  double&  O_IndBuf[],      //  Open    
                  double&  H_IndBuf[],      //  High  
                  double&  L_IndBuf[],      //  Low  
                  double&  C_IndBuf[],      //  Close  
                  double&  Clr_IndBuf[],    //     
                  uint     Clr_BuffNumb,    //      
                  const datetime& iTime[],  //  
                  const double&  Open[],    //  Open
                  const double&  High[],    //  High
                  const double&  Low[],     //  Low
                  const double&  Close[],   //  Close
                  const int Rates_Total,    //       
                  const int Prev_Calculated,//       
                  const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      Clr_IndBuf[bar]=EMPTY_VALUE;
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Clr_Arr[1];
         //---      
         if(CopyBuffer(IndHandle,Clr_BuffNumb,iTime[bar],1,Clr_Arr)<=0) return(RESET);
         //---
         O_IndBuf[bar]=Open[bar];
         H_IndBuf[bar]=High[bar];
         L_IndBuf[bar]=Low[bar];
         C_IndBuf[bar]=Close[bar];
         Clr_IndBuf[bar]=Clr_Arr[0];
        }
      else
        {
         O_IndBuf[bar]=Open[bar];
         H_IndBuf[bar]=High[bar];
         L_IndBuf[bar]=Low[bar];
         C_IndBuf[bar]=Close[bar];
         Clr_IndBuf[bar]=Clr_IndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
