//+------------------------------------------------------------------+
//|                                                ColorStepXCCX.mq5 | 
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//|      SmoothAlgorithms.mqh                 |
//|    : __\\MQL5\Include |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.02"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|    StepXCCX      |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----       Teal,Magenta
#property indicator_color1  clrTeal,clrMagenta
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "Step XCCX"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1       -50.0
#property indicator_level2        50.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMAD,XMAH,XMAL;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_      //  
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price 
  };
//---
/*enum Smooth_Method -    SmoothAlgorithms.mqh
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method DSmoothMethod=MODE_JJMA;  //   
input uint DPeriod=30;                        //  
input int DPhase=100;                         //  
input Smooth_Method MSmoothMethod=MODE_T3;    //   
input uint MPeriod=7;                         //   
input int MPhase=15;                          //   
input Applied_price_ IPC=PRICE_TYPICAL;       //  
input uint StepSizeFast=5;                    //  
input uint StepSizeSlow=30;                   //  
input int Shift=0;                            //      
//+-----------------------------------+
//----   ,    
//----      
double Line2Buffer[];
double Line3Buffer[];
//----      
int RSI_Handle;
//----      
int min_rates_total,min_rates_total_D,min_rates_total_M;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total_D=XMAD.GetStartBars(DSmoothMethod,DPeriod,DPhase);
   min_rates_total_M=XMAD.GetStartBars(MSmoothMethod,MPeriod,MPhase);
   min_rates_total=min_rates_total_D+min_rates_total_M;
//----       
   XMAD.XMALengthCheck("DPeriod", DPeriod);
   XMAD.XMALengthCheck("MPeriod", MPeriod);
//----       
   XMAD.XMAPhaseCheck("DPhase",DPhase,DSmoothMethod);
//----    Line2Buffer[]   
   SetIndexBuffer(0,Line2Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   SetIndexBuffer(1,Line3Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   string shortname,SmoothD,SmoothM;
   SmoothD=XMAD.GetString_MA_Method(DSmoothMethod);
   SmoothM=XMAD.GetString_MA_Method(MSmoothMethod);
   StringConcatenate(shortname,"StepXCCX(",
                     string(DPeriod),",",string(MPeriod),",",SmoothD,",",SmoothM,
                     StepSizeFast,", ",StepSizeSlow,", ",Shift,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,     //       
                const int prev_calculated, //       
                const datetime &time[],
                const double &open[],
                const double& high[],      //       
                const double& low[],       //       
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar,ftrend,strend,recbar;
   double fmin0,fmax0,smin0,smax0;
   double price_,xma,upccx,dnccx,xupccx,xdnccx,xccx;
   static double fmax1,fmin1,smin1,smax1;
   static int ftrend_,strend_;
//----   
   ftrend = ftrend_;
   strend = strend_;
//----    first       
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      //----
      fmin1=+999999;
      fmax1=-999999;
      smin1=+999999;
      smax1=-999999;
      ftrend_=0;
      strend_=0;
     }
   else first=prev_calculated-1; //      
//----
   recbar=rates_total-1;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      if(rates_total!=prev_calculated && bar==recbar)
        {
         ftrend_=ftrend;
         strend_=strend;
        }
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      //----    XMASeries 
      xma=XMAD.XMASeries(0,prev_calculated,rates_total,DSmoothMethod,DPhase,DPeriod,price_,bar,false);
      //----       ,   
      if(bar<min_rates_total_D) continue;
      //----
      upccx=price_-xma;
      dnccx=MathAbs(upccx);
      //----    XMASeries  
      xupccx=XMAH.XMASeries(min_rates_total_D,prev_calculated,rates_total,MSmoothMethod,MPhase,MPeriod,upccx,bar,false);
      xdnccx=XMAL.XMASeries(min_rates_total_D,prev_calculated,rates_total,MSmoothMethod,MPhase,MPeriod,dnccx,bar,false);
      //----   
      if(xupccx!=0.0) //    !
         xccx=100*xupccx/xdnccx;
      else xccx=0.0;
      //----
      fmax0=xccx+2*StepSizeFast;
      fmin0=xccx-2*StepSizeFast;
      //----
      if(xccx>fmax1)  ftrend=+1;
      if(xccx<fmin1)  ftrend=-1;
      //----
      if(ftrend>0 && fmin0<fmin1) fmin0=fmin1;
      if(ftrend<0 && fmax0>fmax1) fmax0=fmax1;
      //----
      smax0=xccx+2*StepSizeSlow;
      smin0=xccx-2*StepSizeSlow;
      //----
      if(xccx>smax1)  strend=+1;
      if(xccx<smin1)  strend=-1;
      //----
      if(strend>0 && smin0<smin1) smin0=smin1;
      if(strend<0 && smax0>smax1) smax0=smax1;
      //----
      if(ftrend>0) Line2Buffer[bar]=fmin0+StepSizeFast;
      if(ftrend<0) Line2Buffer[bar]=fmax0-StepSizeFast;
      if(strend>0) Line3Buffer[bar]=smin0+StepSizeSlow;
      if(strend<0) Line3Buffer[bar]=smax0-StepSizeSlow;
      //----
      if(bar<recbar)
        {
         fmin1=fmin0;
         fmax1=fmax0;
         smin1=smin0;
         smax1=smax0;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
