//+------------------------------------------------------------------+
//|                                                          CMO.mq5 | 
//|                           Copyright  2006, TrendLaboratory Ltd. |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"
#property description "CMO"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|    CMO           |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrLightSeaGreen,clrDarkOrange
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "CMO"
//+----------------------------------------------+
//|      |
//+----------------------------------------------+
#property indicator_level1  +50
#property indicator_level2    0
#property indicator_level3  -50
#property indicator_levelcolor clrSlateGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Length=14;                        //  
input ENUM_MA_METHOD Method=MODE_SMA;        //  
input ENUM_APPLIED_PRICE Price=PRICE_CLOSE;  // 
input int Shift=0;                           //       
//+----------------------------------------------+
//----   ,   
//----      
double Line1Buffer[];
double Line2Buffer[];
//----      
int min_rates_total;
//----      
int MA_Handle;
//----   ,   
//----      
int Count[];
double Bulls[],Bears[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CountArray[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CountArray[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(Length);
//----    iMA
   MA_Handle=iMA(NULL,0,Length,0,Method,Price);
   if(MA_Handle==INVALID_HANDLE) Print("      iMA");
//----     
   int size=int(Length);
   if(ArrayResize(Count,size)<size) Print("      Count[]");
   if(ArrayResize(Bulls,size)<size) Print("      Bulls[]");
   if(ArrayResize(Bears,size)<size) Print("      Bears[]");
//---
   ArrayInitialize(Count,0);
   ArrayInitialize(Bulls,0);
   ArrayInitialize(Bears,0);
//----      
   SetIndexBuffer(0,Line1Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----          
   ArraySetAsSeries(Line1Buffer,true);
//----      
   SetIndexBuffer(1,Line2Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----          
   ArraySetAsSeries(Line2Buffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"CMO(",Length,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(MA_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int limit,to_copy,bar;
   double MA[],dPrice,Sum;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-2-min_rates_total; //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+2;
//----      
   if(CopyBuffer(MA_Handle,0,0,to_copy,MA)<=0) return(RESET);
//----         
   ArraySetAsSeries(MA,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      dPrice=MA[bar]-MA[bar+1];
      Bulls[Count[0]]=0.5*(MathAbs(dPrice)+dPrice);
      Bears[Count[0]]=0.5*(MathAbs(dPrice)-dPrice);
//---
      double SumBulls=0,SumBears=0;
      for(int iii=0; iii<int(Length); iii++)
        {
         SumBulls+=Bulls[Count[iii]];
         SumBears+=Bears[Count[iii]];
        }
//---
      Sum=SumBulls+SumBears;
      if(Sum) Line1Buffer[bar]=(SumBulls-SumBears)/(SumBulls+SumBears)*100;
      else Line1Buffer[bar]=0.0;
      Line2Buffer[bar]=0.0;
      if(bar) Recount_ArrayZeroPos(Count,Length);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
