//+------------------------------------------------------------------+ 
//|                                                      TrailCD.mq5 | 
//|                                     Copyright  2007, John Smith | 
//|                                https://www.mql5.com/ru/code/7383 | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2007, John Smith"
#property link "https://www.mql5.com/ru/code/7383" 
#property description "/    "
//---   
#property version   "1.01"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---      
#property indicator_color1 clrMagenta,clrMaroon,clrDeepPink,clrGray,clrDodgerBlue,clrGreen,clrAqua
//---   - 
#property indicator_style1 STYLE_SOLID
//---     2
#property indicator_width1 2
//---   
#property indicator_label1 "TrailCD"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint TrailFast=25;     //  
input uint TrailSlow=65;     //  
//+-----------------------------------+
//---      
int min_rates_total;
//---   ,   
//---      
double IndBuffer[],ColorIndBuffer[];
//+------------------------------------------------------------------+    
//| TrailCD indicator initialization function                        | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//---     
   min_rates_total=2;
//---    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"TrailCD");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+  
//| TrailCD iteration function                                       | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,     //       
                const int prev_calculated, //       
                const int begin,           //     
                const double &price[])     //     
  {
//---       
   if(rates_total<min_rates_total+begin) return(0);
///---    
   int first,bar,nprice,clr;
   int value_fast,value_slow;
   int value_fast_,value_slow_;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1+begin;  //      
      //---      begin ,      
      if(begin>0) PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+begin);
      value_fast_=value_slow_=int(MathRound(price[first-1]/_Point));
     }
   else first=prev_calculated-1; //      
//---
   value_fast=value_fast_;
   value_slow=value_slow_;
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      nprice=int(MathRound(price[bar]/_Point));
      if(value_fast<nprice-int(TrailFast)) value_fast=nprice-int(TrailFast);
      if(value_fast>nprice+int(TrailFast)) value_fast=nprice+int(TrailFast);
      if(value_slow<nprice-int(TrailSlow)) value_slow=nprice-int(TrailSlow);
      if(value_slow>nprice+int(TrailSlow)) value_slow=nprice+int(TrailSlow);
      IndBuffer[bar]=(value_fast-value_slow);
      //---
      if(bar<=rates_total-2)
        {
         value_fast_=value_fast;
         value_slow_=value_slow;
        }
     }
//---
   if(prev_calculated>rates_total || prev_calculated<=0) first++;
//---     Ind
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      clr=3;
      //---
      if(IndBuffer[bar]>0)
        {
         if(IndBuffer[bar]>IndBuffer[bar-1]) clr=6;
         if(IndBuffer[bar]==IndBuffer[bar-1]) clr=5;
         if(IndBuffer[bar]<IndBuffer[bar-1]) clr=4;
        }
      //---
      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar-1]) clr=0;
         if(IndBuffer[bar]==IndBuffer[bar-1]) clr=1;
         if(IndBuffer[bar]>IndBuffer[bar-1]) clr=2;
        }
      ColorIndBuffer[bar]=clr;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
