//+---------------------------------------------------------------------+ 
//|                                              XXRSX_StDev_Signal.mq5 | 
//|                                          Copyright  2015, olegok83 | 
//|                              https://www.mql5.com/ru/users/olegok83 | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
//---  
#property copyright "Copyright  2015, olegok83"
//---    
#property link      "https://www.mql5.com/ru/users/olegok83"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "XXRSX_StDev Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrDeepSkyBlue
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2 "XXRSX_StDev Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0      //        
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -    SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_Mode // 
  {
   Mode_OnlyLevels = 1,     // 
   Mode_OnlyStDev,          // 
   Mode_LevelsStDev,        //  
   Mode_LevelsStDev_On,     //    
   Mode_LevelsStDev_Out     //    
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Applied_Mode Mode=Mode_LevelsStDev_On; //  
input Smooth_Method DSmoothMethod=MODE_JJMA; //   
input int DPeriod=15;                        //  
input int DPhase=100;                        //  
//--- DPhase:  JJMA    -100 ... +100,     ;
//--- DPhase:  VIDIA   CMO,  AMA    
input Smooth_Method SSmoothMethod=MODE_JurX; //    
input int SPeriod=7;                         //   
input int SPhase=100;                        //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Applied_price IPC=PRICE_CLOSE;         //  
input double dK=1.5;                         //    
input uint std_period=9;                     //   
input int Shift=0;                           //      
input int UpLevel=+50;                       //  
input int DnLevel=-50;                       //  
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---      
int ATR_Handle,Ind_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int StartBarsD=GetStartBars(DSmoothMethod,DPeriod,DPhase)+1;
   int StartBarsS=StartBarsD+GetStartBars(SSmoothMethod,SPeriod,SPhase);
   min_rates_total=StartBarsS+1+int(std_period);
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,min_rates_total));
//---    ATR
   ATR_Handle=iATR(Symbol(),PERIOD_CURRENT,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---    XXRSX_StDev
   Ind_Handle=iCustom(Symbol(),PERIOD_CURRENT,"XXRSX_StDev",DSmoothMethod,DPeriod,DPhase,SSmoothMethod,SPeriod,SPhase,IPC,dK,std_period,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      XXRSX_StDev");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,159);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="XXRSX_StDev_Signal";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(Ind_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//---    
   int to_copy,limit,bar;
   double Ind[],Up[],Dn[],ATR[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---       Ind[]  ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---
   switch(Mode)
     {
      case  Mode_OnlyLevels:// 
        {
         if(CopyBuffer(Ind_Handle,0,0,to_copy,Ind)<=0) return(RESET);
         ArraySetAsSeries(Ind,true);
        }
      break;
      case  Mode_OnlyStDev:// 
        {
         if(CopyBuffer(Ind_Handle,3,0,to_copy,Up)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,2,0,to_copy,Dn)<=0) return(RESET);
         ArraySetAsSeries(Up,true);
         ArraySetAsSeries(Dn,true);
        }
      break;
      case  Mode_LevelsStDev://  
        {
         if(CopyBuffer(Ind_Handle,0,0,to_copy,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,3,0,to_copy,Up)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,2,0,to_copy,Dn)<=0) return(RESET);
         ArraySetAsSeries(Ind,true);
         ArraySetAsSeries(Up,true);
         ArraySetAsSeries(Dn,true);
        }
      break;
      case  Mode_LevelsStDev_On://    
        {
         if(CopyBuffer(Ind_Handle,0,0,to_copy,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,3,0,to_copy,Up)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,2,0,to_copy,Dn)<=0) return(RESET);
         ArraySetAsSeries(Ind,true);
         ArraySetAsSeries(Up,true);
         ArraySetAsSeries(Dn,true);
        }
      break;
      case  Mode_LevelsStDev_Out://    
        {
         if(CopyBuffer(Ind_Handle,0,0,to_copy,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,3,0,to_copy,Up)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,2,0,to_copy,Dn)<=0) return(RESET);
         ArraySetAsSeries(Ind,true);
         ArraySetAsSeries(Up,true);
         ArraySetAsSeries(Dn,true);
        }
      break;
     }
//---         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      switch(Mode)
        {
         case  Mode_OnlyLevels:// 
           {
            if(Ind[bar]>UpLevel) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
            if(Ind[bar]<DnLevel) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
           }
         break;
         case  Mode_OnlyStDev:// 
           {
            if(Up[bar]!=EMPTY_VALUE) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
            if(Dn[bar]!=EMPTY_VALUE) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
           }
         break;
         case  Mode_LevelsStDev://  
           {
            if(Ind[bar]>UpLevel && Up[bar]!=EMPTY_VALUE) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
            if(Ind[bar]<DnLevel && Up[bar]!=EMPTY_VALUE) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
            if(Ind[bar]>UpLevel && Dn[bar]!=EMPTY_VALUE) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
            if(Ind[bar]<DnLevel && Dn[bar]!=EMPTY_VALUE) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
           }
         break;
         case  Mode_LevelsStDev_On://    
           {
            if(Ind[bar]>UpLevel && Up[bar]!=EMPTY_VALUE) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
            if(Ind[bar]<DnLevel && Dn[bar]!=EMPTY_VALUE) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
           }
         break;
         case  Mode_LevelsStDev_Out://    
           {
            if(Ind[bar]>UpLevel && Dn[bar]!=EMPTY_VALUE) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
            if(Ind[bar]<DnLevel && Up[bar]!=EMPTY_VALUE) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
           }
         break;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
