//+------------------------------------------------------------------+
//|                                                      Notches.mq5 |
//|                                 Copyright  2014 Serkov Alexandr | 
//|                                          serkov-alexandr@mail.ru | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2014 Serkov Alexandr"
//---    
#property link "serkov-alexandr@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 4
//---    
#property indicator_plots   4
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrDeepSkyBlue
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "Bulls Notches 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrMagenta
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2  "Bears Notches 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_LINE
//---         
#property indicator_color3  clrLime
//---   3 -  
#property indicator_style3  STYLE_SOLID
//---    3  4
#property indicator_width3  4
//---    
#property indicator_label3  "Bulls Notches 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_LINE
//---         
#property indicator_color4  clrRed
//---   4 -  
#property indicator_style4  STYLE_SOLID
//---    4  4
#property indicator_width4  4
//---    
#property indicator_label4  "Bears Notches 1"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int IndShift=0;   //       
//+----------------------------------------------+
//---   ,   
//---      
double BullsIndBuffer1[];
double BearsIndBuffer1[];
double BullsIndBuffer2[];
double BearsIndBuffer2[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//---    
   min_rates_total=2;
//---    BullsIndBuffer   
   SetIndexBuffer(0,BullsIndBuffer1,INDICATOR_DATA);
//---    1    IndShift
   PlotIndexSetInteger(0,PLOT_SHIFT,IndShift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---    BearsIndBuffer   
   SetIndexBuffer(1,BearsIndBuffer1,INDICATOR_DATA);
//---    2    IndShift
   PlotIndexSetInteger(1,PLOT_SHIFT,IndShift);
//---      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---    BullsIndBuffer   
   SetIndexBuffer(2,BullsIndBuffer2,INDICATOR_DATA);
//---    1    IndShift
   PlotIndexSetInteger(2,PLOT_SHIFT,IndShift);
//---      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//---    BearsIndBuffer   
   SetIndexBuffer(3,BearsIndBuffer2,INDICATOR_DATA);
//---    2    IndShift
   PlotIndexSetInteger(3,PLOT_SHIFT,IndShift);
//---      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);
//---      
   string shortname;
   StringConcatenate(shortname,"Notches(",IndShift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---    
   int first,bar,x,y;
   static int x_,y_;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total; //      
      x_=0;
      y_=0;
     }
   else first=prev_calculated-1; //      
//---
   x=x_;
   y=y_;
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      BearsIndBuffer1[bar]=0.0;
      BullsIndBuffer1[bar]=0.0;
      BearsIndBuffer2[bar]=0.0;
      BullsIndBuffer2[bar]=0.0;

      if(high[bar]>high[bar-1])
        {
         if(x==1)
           {
            BullsIndBuffer1[bar]=high[bar];
            BullsIndBuffer1[bar-1]=high[bar-1];
            x=2;
           }
         else
           {
            BullsIndBuffer2[bar]=high[bar];
            BullsIndBuffer2[bar-1]=high[bar-1];
            x=1;
           }
        }
      //---
      if(low[bar]<low[bar-1])
        {
         if(y==1)
           {
            BearsIndBuffer1[bar]=low[bar];
            BearsIndBuffer1[bar-1]=low[bar-1];
            y=2;
           }
         else
           {
            BearsIndBuffer2[bar]=low[bar];
            BearsIndBuffer2[bar-1]=low[bar-1];
            y=1;
           }
        }
      //---
      if(bar<rates_total-1)
        {
         x_=x;
         y_=y;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
