//+------------------------------------------------------------------+ 
//|                                                  XVolume_HTF.mq5 | 
//|                               Copyright  2014, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2014, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.60"
//----     
#property indicator_separate_window 
//----    3
#property indicator_buffers 3 
//----     
#property indicator_plots   2
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1 clrGray,clrDeepSkyBlue
//----   - 
#property indicator_style1 STYLE_SOLID
//----     5
#property indicator_width1 5
//----   
#property indicator_label1 "Volume HTF"
//+-----------------------------------+
//|     2 |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       Red 
#property indicator_color2 clrRed
//----   -  
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "XVolume HTF"

//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_TIMEFRAMES     TimeFrame=PERIOD_H4;     //  
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input Smooth_Method XMA_Method=MODE_SMA;           //  
input int XLength=12;                              //                      
input int XPhase=15;                               //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input bool                ReDraw=true;             //      
//+-----------------------------------+
//----      
int min_rates_total;
//----      
int XVolume_Handle;
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[],IndBuffer1[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| XVolume indicator initialization function                        | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=3;

//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    XVolume       ");
      return(INIT_FAILED);
     }

//----    XVolume
   XVolume_Handle=iCustom(Symbol(),TimeFrame,"XVolume",VolumeType,XMA_Method,XLength,XPhase,0);
   if(XVolume_Handle==INVALID_HANDLE)
     {
      Print("      XVolume");
      return(INIT_FAILED);
     }

//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//----    IndBuffer   
   SetIndexBuffer(2,IndBuffer1,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer1,true);
   
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   string shortname;
   StringConcatenate(shortname,"XVolume HTF( ",GetStringTimeframe(TimeFrame)," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| XVolume iteration function                                       | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(XVolume_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);

//----   
   int limit,bar;
//----       
   double Volume[1],XVolume[1],Col[1];
   datetime XVolumeTime[1];
   static uint LastCountBar;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       

//----         
   ArraySetAsSeries(time,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=EMPTY_VALUE;
      ColorIndBuffer[bar]=1;
      IndBuffer1[bar]=EMPTY_VALUE;

      //----      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,XVolumeTime)<=0) return(RESET);

      if(time[bar]>=XVolumeTime[0] && time[bar+1]<XVolumeTime[0])
        {
         LastCountBar=bar;
         //----      
         if(CopyBuffer(XVolume_Handle,0,time[bar],1,Volume)<=0) return(RESET);
         if(CopyBuffer(XVolume_Handle,1,time[bar],1,Col)<=0) return(RESET);
         if(CopyBuffer(XVolume_Handle,2,time[bar],1,XVolume)<=0) return(RESET);


         //----      
         IndBuffer[bar]=Volume[0];
         ColorIndBuffer[bar]=Col[0];
         IndBuffer1[bar]=XVolume[0];
        }

      if(ReDraw)
        {
         if(IndBuffer[bar+1]!=EMPTY_VALUE && IndBuffer[bar]==EMPTY_VALUE)
           {
            IndBuffer[bar]=IndBuffer[bar+1];
            ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
            IndBuffer1[bar]=IndBuffer1[bar+1];
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
