//+------------------------------------------------------------------+ 
//|                                            ATR_Normalize_HTF.mq5 | 
//|                               Copyright  2014, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2014, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
#property description "ATR_Normalize       "
//---     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-------------------------------------+
//|                   |
//+-------------------------------------+
#define RESET 0                          //        
#define INDICATOR_NAME "ATR_Normalize"   //    
#define SIZE 1                           //      CountIndicator
//+-------------------------------------+
//|         |
//+-------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrBlue
//---   1 -  
#property indicator_style1  STYLE_SOLID
//----     4
#property indicator_width1  4
//----   
#property indicator_label1  INDICATOR_NAME
//+-------------------------------------+
//|               |
//+-------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+-------------------------------------+
//|           |
//+-------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
//+-------------------------------------+
//|           |
//+-------------------------------------+
input Smooth_Method MA_Method1=MODE_SMA; //    
input int Length1=14; //                       
input int Phase1=15; //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_SMA; //    
input int Length2=14; //    
input int Phase2=15;  //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0; //      
input int inHighLevel=60; //     
input int inMiddleLevel=50; //      
input int inLowLevel=40;  //                
//+-------------------------------------+
//----   ,    
//      
double IndBuffer[];
double ColorIndBuffer[];
//----  
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);

//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);

//----    ATR_Normalize
   Ind_Handle=iCustom(Symbol(),TimeFrame,INDICATOR_NAME,MA_Method1,Length1,Phase1,MA_Method2,Length2,Phase2,0,0,0,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ATR_Normalize");
      return(INIT_FAILED);
     }

//----   
   IndInit(0,IndBuffer,0.0,min_rates_total,Shift);

//----           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
   
//----      3   
   IndicatorSetInteger(INDICATOR_LEVELS,3);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,inHighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,inMiddleLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,inLowLevel);
//----          
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrLime);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrGray);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrRed);
//----      
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_SOLID);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_SOLID);
//----      
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,3);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,1);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,3);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----         
   ArraySetAsSeries(time,true);

//----
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,IndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//----
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
//----
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(
                    uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total //       
                    )
//---- 
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;

//----      
//  limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuf[bar]=0.0;

      //----       IndTime
      if(CopyTime(Symbol_,TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];

         //----      
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);

         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(
                     string IndName,
                     ENUM_TIMEFRAMES TFrame //  
                     )
//TimeFramesCheck(INDICATOR_NAME,TimeFrame)
  {
//----     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
