//+------------------------------------------------------------------+
//|                                             CommonParameters.mq5 |
//|            Copyright 2013, https://login.mql5.com/ru/users/tol64 |
//|                                  Site, http://tol64.blogspot.com |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2013, http://tol64.blogspot.com"
#property link        "http://tol64.blogspot.com"
#property description "email: hello.tol64@gmail.com"
#property version     "1.0"
//--- Allow access to the external file and indicator for optimization in the cloud
#property tester_file      "SymbolsList.txt"
#property tester_indicator "EventsSpy.ex5"
//--- Name of the Expert Advisor
#define EXPERT_NAME MQL5InfoString(MQL5_PROGRAM_NAME)
//--- Include a class of the Standard Library
#include <Trade/Trade.mqh>
//--- Load the class
CTrade   trade;
//--- Include custom libraries
#include "Include/Enums.mqh"
#include "Include/InitializeArrays.mqh"
#include "Include/Errors.mqh"
#include "Include/FileFunctions.mqh"
#include "Include/TradeSignals.mqh"
#include "Include/TradeFunctions.mqh"
#include "Include/ToString.mqh"
#include "Include/Report.mqh"
#include "Include/Auxiliary.mqh"
//--- External parameters of the Expert Advisor
sinput int    SectionOfSymbolList = 1;     // Section number in the symbol lists
sinput bool   UpdateReport        = false; // Report update
sinput string delimeter_00="";   // --------------------------------
sinput long   MagicNumber         = 777;   // Magic number
sinput int    Deviation           = 10;    // Slippage
sinput string delimeter_01="";   // --------------------------------
input  int    IndicatorPeriod     = 5;     // Indicator period
input  double TakeProfit          = 100;   // Take Profit
input  double StopLoss            = 50;    // Stop Loss
input  double TrailingStop        = 10;    // Trailing Stop
input  bool   Reverse             = true;  // Position reversal
input  double Lot                 = 0.1;   // Lot
input  double VolumeIncrease      = 0.1;   // Position volume increase
input  double VolumeIncreaseStep  = 10;    // Volume increase step
//--- Number of traded symbols. It is calculated and depends on the testing mode and the number of symbols in the file
int SYMBOLS_COUNT=0;
//--- Array of symbols involved in testing 
string InputSymbols[];
//--- Array of indicator agent handles
int spy_indicator_handles[];
//--- Array of signal indicator handles
int signal_indicator_handles[];
//--- Data arrays for checking trading conditions
struct PriceData
  {
   double            value[];
  };
PriceData open[];      // Opening price of the bar
PriceData high[];      // High price of the bar
PriceData low[];       // Low price of the bar
PriceData close[];     // Closing price of the bar
PriceData indicator[]; // Array of indicator values
//--- Arrays for getting the opening time of the current bar
struct Datetime
  {
   datetime          time[];
  };
//--- Time of the last bars in the memory
Datetime lastbar_time[];
//--- Array for checking the new bar for each symbol
datetime new_bar[];
//--- Array for untested symbols
string temporary_symbols[];
//--- Arrays for all symbol balances
struct Balance
  {
   double            balance[];
  };
//--- Array of balances for all symbols
Balance symbol_balance[];
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- The Expert Advisor requires around 500 Mb when doing calculations
//    Do not use PCs with less than 1 Gb RAM
   if(TerminalInfoInteger(TERMINAL_MEMORY_PHYSICAL)<1024)
      return(INIT_AGENT_NOT_SUITABLE);
//--- At least 768 Mb of free memory space
   if(TerminalInfoInteger(TERMINAL_MEMORY_AVAILABLE)<768)
      return(INIT_AGENT_NOT_SUITABLE);
//--- Initialize the array of symbols
   InitializeArraySymbols();
//--- Initialize arrays of indicator handles
   InitializeIndicatorHandlesArrays();
//--- Get agent handles
   GetSpyHandles();
//--- Get indicator handles
   GetIndicatorHandles();
//--- Initialize the new bar
   InitializeNewBarArray();
//--- Initialize price and buffer arrays
   ResizeDataArrays();
//--- Initialization completed successfully
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- Print the deinitialization reason to the journal
   Print(GetDeinitReasonText(reason));
//--- Display the amount of memory used (approximate value)
   Print("TERMINAL_MEMORY_USED: ",TerminalInfoInteger(TERMINAL_MEMORY_USED)," Mb");
//--- When deleting from the chart
   if(reason==REASON_REMOVE)
     {
      //--- Delete the indicator handles
      for(int s=0; s<SYMBOLS_COUNT; s++)
        {
         IndicatorRelease(spy_indicator_handles[s]);
         IndicatorRelease(signal_indicator_handles[s]);
        }
     }
  }
//+------------------------------------------------------------------+
//| Chart events handler                                             |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,         // Event identifier
                  const long &lparam,   // Long type event parameter
                  const double &dparam, // Double type event parameter
                  const string &sparam) // String type event parameter
  {
//--- If this is a custom event
   if(id>=CHARTEVENT_CUSTOM)
     {
      //--- Exit if trading is not allowed
      if(CheckTradingPermission()>0)
         return;
      //--- If there was a tick event
      if(lparam==CHARTEVENT_TICK)
        {
         //--- Check signals and trade on them
         CheckSignalsAndTrade();
         return;
        }
     }
  }
//+------------------------------------------------------------------+
//| Handler of the event of completion of testing                    |
//+------------------------------------------------------------------+
double OnTester()
  {
//--- Write the report only if this is specified and only after the test has been completed
   if(UpdateReport && IsTester() && !IsOptimization() && !IsVisualMode())
      //--- Generation of the report and writing to the file
      CreateSymbolBalanceReport();
//---
   return(0.0);
  }
//+------------------------------------------------------------------+
//| Checking signals and trading based on the new bar event          |
//+------------------------------------------------------------------+
void CheckSignalsAndTrade()
  {
//--- Iterate over all specified symbols
   for(int s=0; s<SYMBOLS_COUNT; s++)
     {
      //--- If the symbol name is correct
      if(InputSymbols[s]!="")
        {
         //--- If the bar is not new, proceed to the next symbol
         if(!CheckNewBar(s))
            continue;
         //--- If there is a new bar
         else
           {
            //--- Get indicator data. If there is no data, proceed to the next symbol
            if(!GetDataIndicators(s))
               continue;
            //--- Get bar data               
            GetBarsData(s);
            //--- Check the conditions and trade
            TradingBlock(s);
            //--- Trailing Stop
            ModifyTrailingStop(s);
           }
        }
     }
  }
//+------------------------------------------------------------------+
