//--- Connection with the main file of the Expert Advisor
#include "..\ReduceOverfittingEA.mq5"
//--- Include custom libraries
#include "Enums.mqh"
#include "Errors.mqh"
#include "FileFunctions.mqh"
#include "TradeSignals.mqh"
#include "TradeFunctions.mqh"
#include "ToString.mqh"
#include "Report.mqh"
#include "Auxiliary.mqh"
//+------------------------------------------------------------------+
//| Filling the array of symbols                                     |
//+------------------------------------------------------------------+
void InitializeArraySymbols()
  {
   int    strings_count  =0;   // Number of strings in the symbol file
   string checked_symbol ="";  // To check the accessibility of the symbol on the trade server
//--- Test mode message
   string message_01="<--- All symbol names in the <- SymbolsList.txt -> file are incorrect ... --->\n"
                     "<--- ... or the value of the \"Section of List Symbols\" parameter is greater "
                     "than the number of file sections! --->\n"
                     "<--- Therefore we will test only the current symbol. --->";
//--- Real-time mode message
   string message_02="<--- In real-time mode, we only work with the current symbol. --->";
//--- If in real-time mode
   if(!IsRealtime())
     {
      //--- Get the number of strings from the specified symbol set in the file and fill the temporary array of symbols
      strings_count=ReadSymbolsFromFile("SymbolsList.txt");
      //--- Iterate over all symbols from the specified set
      for(int s=0; s<strings_count; s++)
        {
         //--- If the correct string is returned following the symbol check
         if((checked_symbol=GetSymbolByName(temporary_symbols[s]))!="")
           {
            //--- increase the counter
            SYMBOLS_COUNT++;
            //--- set/increase the array size
            ArrayResize(InputSymbols,SYMBOLS_COUNT);
            //--- index with the symbol name
            InputSymbols[SYMBOLS_COUNT-1]=checked_symbol;
           }
        }
     }
//--- If all symbol names were not input correctly or if currently working in real-time mode
   if(SYMBOLS_COUNT==0)
     {
      //--- Real-time mode message
      if(IsRealtime())
         Print(message_02);
      //--- Test mode message
      if(!IsRealtime())
         Print(message_01);
      //--- We will work with the current symbol only
      SYMBOLS_COUNT=1;
      //--- set the array size and
      ArrayResize(InputSymbols,SYMBOLS_COUNT);
      //--- index with the current symbol name
      InputSymbols[0]=_Symbol;
     }
  }
//+------------------------------------------------------------------+
//| Initializing the new bar array                                   |
//+------------------------------------------------------------------+
void InitializeNewBarArray()
  {
//--- Set the size of arrays
   ArrayResize(new_bar,SYMBOLS_COUNT);
   ArrayResize(lastbar_time,SYMBOLS_COUNT);
//--- Initialize to zeros
   ArrayInitialize(new_bar,0);
//--- Iterate over all symbols
   for(int s=0; s<SYMBOLS_COUNT; s++)
     {
      //--- If the symbol name is correct
      if(InputSymbols[s]!="")
         //--- Initialize the time of the current bar
         CheckNewBar(s);
     }
  }
//+------------------------------------------------------------------+
//| Initializing arrays of indicator handles                         |
//+------------------------------------------------------------------+
void InitializeIndicatorHandlesArrays()
  {
//--- Set the size of arrays of handles
   ArrayResize(spy_indicator_handles,SYMBOLS_COUNT);
   ArrayResize(signal_indicator_handles,SYMBOLS_COUNT);
//--- Initialize arrays of handles to invalid values
   ArrayInitialize(spy_indicator_handles,INVALID_HANDLE);
   ArrayInitialize(signal_indicator_handles,INVALID_HANDLE);
  }
//+------------------------------------------------------------------+
//| Setting the size of price arrays and indicator buffers           |
//+------------------------------------------------------------------+
void ResizeDataArrays()
  {
   ArrayResize(close,SYMBOLS_COUNT);
   ArrayResize(open,SYMBOLS_COUNT);
   ArrayResize(high,SYMBOLS_COUNT);
   ArrayResize(low,SYMBOLS_COUNT);
   ArrayResize(indicator,SYMBOLS_COUNT);
  }
//+------------------------------------------------------------------+
//| Adding the specified symbol to the Market Watch window           |
//+------------------------------------------------------------------+
string GetSymbolByName(string symbol)
  {
   string symbol_name=""; // Symbol name on the server
//--- If an empty string is passed, return the empty string
   if(symbol=="")
      return("");
//--- Iterate over the list of all symbols on the server
   for(int s=0; s<SymbolsTotal(false); s++)
     {
      //--- Get the symbol name
      symbol_name=SymbolName(s,false);
      //--- If the required symbol is available on the server
      if(symbol==symbol_name)
        {
         //--- Select it in the Market Watch window
         SymbolSelect(symbol,true);
         //--- Return the symbol name
         return(symbol);
        }
     }
//--- If the required symbol cannot be found, return the empty string
   Print("The "+symbol+" symbol could not be found on the server!");
   return("");
  }
//+------------------------------------------------------------------+
