//+------------------------------------------------------------------+
//|                                                    EventsSpy.mq5 |
//|                                            Copyright 2010, Lizar |
//|                            https://login.mql5.com/ru/users/Lizar |
//+------------------------------------------------------------------+
#define VERSION       "1.00 Build 3 (26 Dec 2010)"
//---
#property copyright   "Copyright 2010, Lizar"
#property link        "https://login.mql5.com/ru/users/Lizar"
#property description "This is Control panel MCM indicator agent."
#property description "It can be launched on a required instrument on any time frame to generate NewBar and/or NewTick custom event for a receiving chart"
//---
#property indicator_chart_window
#property indicator_plots 0
//---
//+-----------------------------------------------------------------------+
//| Enumeration of all events by symbol is arranged as flags.             |
//| It determines what events can be obtained. Elements of the enumeration|
//| can be combined using "|" symbol                                      |
//+-----------------------------------------------------------------------+
enum ENUM_CHART_EVENT_SYMBOL
  {
   CHARTEVENT_INIT      =0,          // Initialization event 
   CHARTEVENT_NO        =0,          // Events are disabled
   //---
   CHARTEVENT_NEWBAR_M1 =0x00000001, // New bar event on a minute chart
   CHARTEVENT_NEWBAR_M2 =0x00000002, // New bar event on a 2-minute chart
   CHARTEVENT_NEWBAR_M3 =0x00000004, // New bar event on a 3-minute chart
   CHARTEVENT_NEWBAR_M4 =0x00000008, // New bar event on a 4-minute chart
   //---
   CHARTEVENT_NEWBAR_M5 =0x00000010, // New bar event on a 5-minute chart
   CHARTEVENT_NEWBAR_M6 =0x00000020, // New bar event on a 6-minute chart
   CHARTEVENT_NEWBAR_M10=0x00000040, // New bar event on a 10-minute chart
   CHARTEVENT_NEWBAR_M12=0x00000080, // New bar event on a 12-minute chart
   //---
   CHARTEVENT_NEWBAR_M15=0x00000100, // New bar event on a 15-minute chart
   CHARTEVENT_NEWBAR_M20=0x00000200, // New bar event on a 20-minute chart
   CHARTEVENT_NEWBAR_M30=0x00000400, // New bar event on a 30-minute chart
   CHARTEVENT_NEWBAR_H1 =0x00000800, // New bar event on an hour chart
   //---
   CHARTEVENT_NEWBAR_H2 =0x00001000, // New bar event on a 2-hour chart
   CHARTEVENT_NEWBAR_H3 =0x00002000, // New bar event on a 3-hour chart
   CHARTEVENT_NEWBAR_H4 =0x00004000, // New bar event on a 4-hour chart
   CHARTEVENT_NEWBAR_H6 =0x00008000, // New bar event on a 6-hour chart
   //---
   CHARTEVENT_NEWBAR_H8 =0x00010000, // New bar event on a 8-hour chart
   CHARTEVENT_NEWBAR_H12=0x00020000, // New bar event on a 12-hour chart
   CHARTEVENT_NEWBAR_D1 =0x00040000, // New bar event on a daily chart
   CHARTEVENT_NEWBAR_W1 =0x00080000, // New bar event on a weekly chart
   //---
   CHARTEVENT_NEWBAR_MN1=0x00100000, // New bar event on a monthly chart   
   CHARTEVENT_TICK      =0x00200000, // New tick event
   //---
   CHARTEVENT_ALL=0xFFFFFFFF         // All events are enabled
  };
//---
input long                    chart_id;                 // receiving chart identifier
input ushort                  custom_event_id;          // event identifier  
input ENUM_CHART_EVENT_SYMBOL flag_event=CHARTEVENT_NO; // flag determining the event type.
//---
MqlDateTime time,prev_time;
//---
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate (const int rates_total,     // size of the price[] array
                 const int prev_calculated, // bars handled at the previous call
                 const int begin,           // significant data starting point
                 const double& price[]      // array for calculation
                 )
  {
   double price_current=price[rates_total-1];
//---
   TimeCurrent(time);
//---
   if(prev_calculated==0)
     {
      EventCustom(CHARTEVENT_INIT,price_current);
      prev_time=time;
      return(rates_total);
     }
//---
// New tick
   if((flag_event&CHARTEVENT_TICK)!=0) { EventCustom(CHARTEVENT_TICK,price_current); }
//---
// Check change time
   if(time.min==prev_time.min   && 
      time.hour==prev_time.hour && 
      time.day==prev_time.day   &&
      time.mon==prev_time.mon
      )
     {
      return(rates_total);
     }
//---
// New minute
   if((flag_event&CHARTEVENT_NEWBAR_M1)!=0) { EventCustom(CHARTEVENT_NEWBAR_M1,price_current); }
//---
   if(time.min%2 ==0 && (flag_event&CHARTEVENT_NEWBAR_M2)!=0)  { EventCustom(CHARTEVENT_NEWBAR_M2,price_current); }
   if(time.min%3 ==0 && (flag_event&CHARTEVENT_NEWBAR_M3)!=0)  { EventCustom(CHARTEVENT_NEWBAR_M3,price_current); }
   if(time.min%4 ==0 && (flag_event&CHARTEVENT_NEWBAR_M4)!=0)  { EventCustom(CHARTEVENT_NEWBAR_M4,price_current); }
   if(time.min%5 ==0 && (flag_event&CHARTEVENT_NEWBAR_M5)!=0)  { EventCustom(CHARTEVENT_NEWBAR_M5,price_current); }
   if(time.min%6 ==0 && (flag_event&CHARTEVENT_NEWBAR_M6)!=0)  { EventCustom(CHARTEVENT_NEWBAR_M6,price_current); }
   if(time.min%10==0 && (flag_event&CHARTEVENT_NEWBAR_M10)!=0) { EventCustom(CHARTEVENT_NEWBAR_M10,price_current); }
   if(time.min%12==0 && (flag_event&CHARTEVENT_NEWBAR_M12)!=0) { EventCustom(CHARTEVENT_NEWBAR_M12,price_current); }
   if(time.min%15==0 && (flag_event&CHARTEVENT_NEWBAR_M15)!=0) { EventCustom(CHARTEVENT_NEWBAR_M15,price_current); }
   if(time.min%20==0 && (flag_event&CHARTEVENT_NEWBAR_M20)!=0) { EventCustom(CHARTEVENT_NEWBAR_M20,price_current); }
   if(time.min%30==0 && (flag_event&CHARTEVENT_NEWBAR_M30)!=0) { EventCustom(CHARTEVENT_NEWBAR_M30,price_current); }
//---
   if(time.min!=0) { prev_time=time; return(rates_total); }
//---
// New hour
   if((flag_event&CHARTEVENT_NEWBAR_H1)!=0) { EventCustom(CHARTEVENT_NEWBAR_H1,price_current); }
//---
   if(time.hour%2 ==0 && (flag_event&CHARTEVENT_NEWBAR_H2)!=0)  { EventCustom(CHARTEVENT_NEWBAR_H2,price_current); }
   if(time.hour%3 ==0 && (flag_event&CHARTEVENT_NEWBAR_H3)!=0)  { EventCustom(CHARTEVENT_NEWBAR_H3,price_current); }
   if(time.hour%4 ==0 && (flag_event&CHARTEVENT_NEWBAR_H4)!=0)  { EventCustom(CHARTEVENT_NEWBAR_H4,price_current); }
   if(time.hour%6 ==0 && (flag_event&CHARTEVENT_NEWBAR_H6)!=0)  { EventCustom(CHARTEVENT_NEWBAR_H6,price_current); }
   if(time.hour%8 ==0 && (flag_event&CHARTEVENT_NEWBAR_H8)!=0)  { EventCustom(CHARTEVENT_NEWBAR_H8,price_current); }
   if(time.hour%12==0 && (flag_event&CHARTEVENT_NEWBAR_H12)!=0) { EventCustom(CHARTEVENT_NEWBAR_H12,price_current); }
//---
   if(time.hour!=0) { prev_time=time; return(rates_total); }
//---
// New day
   if((flag_event&CHARTEVENT_NEWBAR_D1)!=0) { EventCustom(CHARTEVENT_NEWBAR_D1,price_current); }
//---
// New week
   if(time.day_of_week==1 && (flag_event&CHARTEVENT_NEWBAR_W1)!=0) { EventCustom(CHARTEVENT_NEWBAR_W1,price_current); }
//---
// New month
   if(time.day==1 && (flag_event&CHARTEVENT_NEWBAR_MN1)!=0) { EventCustom(CHARTEVENT_NEWBAR_MN1,price_current); }
//---
   prev_time=time;
//---
// Return value of prev_calculated for next call
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//| CUSTOM EVENT                                                     |
//+------------------------------------------------------------------+
void EventCustom(ENUM_CHART_EVENT_SYMBOL event,double price)
  {
   EventChartCustom(chart_id,custom_event_id,(long)event,price,_Symbol); return;
  }
//+------------------------------------------------------------------+
