//+------------------------------------------------------------------+
//|                                                   MA-Support.mq5 |
//|                                       Oleg Fedorov (aka certain) |
//|                                   mailto:coder.fedorov@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Oleg Fedorov (aka certain)"
#property link      "mailto:coder.fedorov@gmail.com"
#property version   "1.00"
#property indicator_chart_window
//#property indicator_separate_window
//#property indicator_height 100
#property indicator_buffers 2
#property indicator_plots   2

//--- plot ArrowUp
#property indicator_label1  "ArrowUp"
#property indicator_color1  clrBlue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot ArrowDown
#property indicator_label2  "ArrowDown"
#property indicator_color2  clrRed
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- input parameters
input int                 MABars=10;
input ENUM_MA_METHOD      MAMethod=MODE_SMA;
int                 ATRBars=5;
//--- indicator buffers
double         ArrowUpBuffer[];
double         ArrowDownBuffer[];

//--- handles
int extMAHandle,extATRHandle;

//---
int extStartPosition;
double extATRData[],extMAData[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
 {
//--- indicator buffers mapping
  SetIndexBuffer(0,ArrowUpBuffer,INDICATOR_DATA);
  SetIndexBuffer(1,ArrowDownBuffer,INDICATOR_DATA);

  PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_ARROW);
  PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_ARROW);

  PlotIndexSetInteger(0,PLOT_ARROW,233);
  PlotIndexSetInteger(1,PLOT_ARROW,234);

  extStartPosition = MathMax(ATRBars,MABars);
  PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,extStartPosition);
  PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,extStartPosition);

  extMAHandle=iMA(NULL,0,MABars,0,MAMethod,PRICE_CLOSE);
  extATRHandle=iATR(NULL,0,ATRBars);

  PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
  PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);

//---
  return(INIT_SUCCEEDED);
 }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
 {
//---
  int i;

  if(rates_total<extStartPosition)
    return(0);
//--- not all data may be calculated
  if(CheckIndicatorsCalculated(rates_total)==0)
   {
    return(0);
   }
//--- we can copy not all data
  int to_copy;
  if(prev_calculated>rates_total || prev_calculated<0)
    to_copy=rates_total;
  else
   {
    to_copy=rates_total-prev_calculated;
    if(prev_calculated>0)
      to_copy++;
   }
//--- get Fast EMA buffer
  if(IsStopped()) // checking for stop flag
    return(0);
  if(CopyBuffer(extMAHandle,0,0,to_copy,extMAData)<=0)
   {
    Print("Getting high EMA is failed! Error ",GetLastError());
    return(0);
   }

//---
  if(IsStopped()) // checking for stop flag
    return(0);
  if(CopyBuffer(extATRHandle,0,0,to_copy,extATRData)<=0)
   {
    Print("Getting ATR is failed! Error ",GetLastError());
    return(0);
   }
//---
  int start;
  if(prev_calculated==0)
    start=0;
  else
    start=prev_calculated-1;

//--- main cycle
  for(i=start+3; i<rates_total && !IsStopped(); i++)
   {
    ArrowDownBuffer[i]=0;
    ArrowUpBuffer[i]=0;

    //---

    if(
      (high[i-1]>=extMAData[i-1]
       && close[i-1]<extMAData[i-1]
       && open[i-1]<extMAData[i-1]
      )

    )
     {
      ArrowDownBuffer[i]=high[i]+extATRData[i]/5;
     }
    else
      if(
        (low[i-1]<=extMAData[i-1]
         && close[i-1]>extMAData[i-1]
         && open[i-1]>extMAData[i-1]
        )
      )
       {
        ArrowUpBuffer[i]=low[i]-extATRData[i]/5;
       }
   }

//--- return value of prev_calculated for next call
  return(rates_total);
 }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CheckIndicatorsCalculated(int rates_total)
 {
  int calculated=BarsCalculated(extMAHandle);
  if(calculated<rates_total)
   {
    Print("Not all data of extMAHandle is calculated (",calculated," bars). Error ",GetLastError());
    return(0);
   }
  calculated=BarsCalculated(extATRHandle);
  if(calculated<rates_total)
   {
    Print("Not all data of extATRHandle is calculated (",calculated," bars). Error ",GetLastError());
    return(0);
   }
//---
  return(1);
 }
//+------------------------------------------------------------------+
