//+------------------------------------------------------------------+
//|                                                       ATR3x5.mq5 |
//|                                       Oleg Fedorov (aka certain) |
//|                                   mailto:coder.fedorov@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Oleg Fedorov (aka certain)"
#property link      "mailto:coder.fedorov@gmail.com"
#property version   "1.00"
#property indicator_chart_window
//#property indicator_separate_window
//#property indicator_height 100
#property indicator_buffers 4
#property indicator_plots   4
//--- plot MAUp
#property indicator_label1  "MAUp"
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot MADown
#property indicator_label2  "MADown"
#property indicator_color2  clrBlue
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- plot ArrowUp
#property indicator_label3  "ArrowUp"
#property indicator_color3  clrBlue
#property indicator_style3  STYLE_SOLID
#property indicator_width3  1
//--- plot ArrowDown
#property indicator_label4  "ArrowDown"
#property indicator_color4  clrRed
#property indicator_style4  STYLE_SOLID
#property indicator_width4  1
//--- input parameters
input int                 ATRBars=5;
input int                 MABars=3;
input double              DistanceCoefficient=1;
input bool                showLines=true;
input bool                showArrows=true;
input ENUM_MA_METHOD      MAMethod=0;
//--- indicator buffers
double         MAUpBuffer[],extMAUpData[];
double         MADownBuffer[],extMADownData[];
double         ArrowUpBuffer[];
double         ArrowDownBuffer[];
double         extATRData[];

//--- handles
int extMAHighHandle,extMALowHandle,extATRHandle;
//---
int extStartPosition;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
 {
//--- indicator buffers mapping
  SetIndexBuffer(0,MAUpBuffer,INDICATOR_DATA);
  SetIndexBuffer(1,MADownBuffer,INDICATOR_DATA);
  SetIndexBuffer(2,ArrowUpBuffer,INDICATOR_DATA);
  SetIndexBuffer(3,ArrowDownBuffer,INDICATOR_DATA);

  if(!showArrows)
   {
    PlotIndexSetInteger(2,PLOT_DRAW_TYPE,DRAW_NONE);
    PlotIndexSetInteger(3,PLOT_DRAW_TYPE,DRAW_NONE);
   }
  else
   {
    PlotIndexSetInteger(2,PLOT_DRAW_TYPE,DRAW_ARROW);
    PlotIndexSetInteger(3,PLOT_DRAW_TYPE,DRAW_ARROW);
   }
  if(!showLines)
   {
    PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_NONE);
    PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_NONE);
   }
  else
   {
    PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_LINE);
    PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_LINE);
   }

  PlotIndexSetInteger(2,PLOT_ARROW,233);
  PlotIndexSetInteger(3,PLOT_ARROW,234);

  extStartPosition = MathMax(ATRBars,MABars);
  PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,extStartPosition);
  PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,extStartPosition);
  PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,extStartPosition);
  PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,extStartPosition);

  extMAHighHandle=iMA(NULL,0,MABars,0,MAMethod,PRICE_HIGH);
  extMALowHandle=iMA(NULL,0,MABars,0,MAMethod,PRICE_LOW);
  extATRHandle=iATR(NULL,0,ATRBars);

  PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
  PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
  PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
  PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0);

  ChartRedraw();
//---
  return(INIT_SUCCEEDED);
 }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
 {
//---
  int i;

  if(rates_total<extStartPosition)
    return(0);
//--- not all data may be calculated
  if(CheckIndicatorsCalculated(rates_total)==0)
   {
    return(0);
   }
//--- we can copy not all data
  int to_copy;
  if(prev_calculated>rates_total || prev_calculated<0)
    to_copy=rates_total;
  else
   {
    to_copy=rates_total-prev_calculated;
    if(prev_calculated>0)
      to_copy++;
   }
//--- get Fast EMA buffer
  if(IsStopped()) // checking for stop flag
    return(0);
  if(CopyBuffer(extMAHighHandle,0,0,to_copy,extMAUpData)<=0)
   {
    Print("Getting high EMA is failed! Error ",GetLastError());
    return(0);
   }
//--- get SlowSMA buffer
  if(IsStopped()) // checking for stop flag
    return(0);
  if(CopyBuffer(extMALowHandle,0,0,to_copy,extMADownData)<=0)
   {
    Print("Getting low SMA is failed! Error ",GetLastError());
    return(0);
   }
//---
  if(IsStopped()) // checking for stop flag
    return(0);
  if(CopyBuffer(extATRHandle,0,0,to_copy,extATRData)<=0)
   {
    Print("Getting ATR is failed! Error ",GetLastError());
    return(0);
   }
//---
  int start;
  if(prev_calculated==0)
    start=0;
  else
    start=prev_calculated-1;

//--- main cycle
  for(i=start+3; i<rates_total && !IsStopped(); i++)
   {
    ArrowDownBuffer[i]=0;
    ArrowUpBuffer[i]=0;
    //MAUpBuffer[i]=0;
    //MADownBuffer[i]=0;
    //---

    MAUpBuffer[i]=extMAUpData[i]+extATRData[i]*DistanceCoefficient;
    MADownBuffer[i]=extMADownData[i]-extATRData[i]*DistanceCoefficient;

    if(
      (high[i-1]>=MAUpBuffer[i-1]
       && close[i-1]<MAUpBuffer[i-1])
      ||(
        close[i-2]>MAUpBuffer[i-2]
        && close[i-1]<MAUpBuffer[i-1]
      )
    )
     {
      ArrowDownBuffer[i]=high[i]+extATRData[i]/5;
     }
    else
      if(
        (low[i-1]<=MADownBuffer[i-1]
         && close[i-1]>MADownBuffer[i-1])
        ||(
          close[i-2]<MADownBuffer[i-2]
          &&close[i-1]>MADownBuffer[i-1]
        )
      )
       {
        ArrowUpBuffer[i]=low[i]-extATRData[i]/5;
       }
   }// main cycle

//--- return value of prev_calculated for next call
  return(rates_total);
 }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CheckIndicatorsCalculated(int rates_total)
 {
  int calculated=BarsCalculated(extMAHighHandle);
  if(calculated<rates_total)
   {
    Print("Not all data of extMAHighHandle is calculated (",calculated," bars). Error ",GetLastError());
    return(0);
   }
  calculated=BarsCalculated(extMALowHandle);
  if(calculated<rates_total)
   {
    Print("Not all data of extMALowHandle is calculated (",calculated," bars). Error ",GetLastError());
    return(0);
   }
  calculated=BarsCalculated(extATRHandle);
  if(calculated<rates_total)
   {
    Print("Not all data of extATRHandle is calculated (",calculated," bars). Error ",GetLastError());
    return(0);
   }
//---
  return(1);
 }
//+------------------------------------------------------------------+
